/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.MessageSizeEstimator;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.PromiseCombiner;
import io.netty5.util.internal.ObjectPool;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;
import java.util.function.Function;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt("io.netty5.transport.pendingWriteSizeOverhead", 64);
    private final EventExecutor executor;
    private final MessageSizeEstimator.Handle sizeEstimatorHandle;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(EventExecutor executor, MessageSizeEstimator.Handle handle) {
        this.executor = Objects.requireNonNull(executor, "executor");
        this.sizeEstimatorHandle = Objects.requireNonNull(handle, "handle");
    }

    public boolean isEmpty() {
        assert (this.executor.inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.executor.inEventLoop());
        return this.size;
    }

    public long bytes() {
        assert (this.executor.inEventLoop());
        return this.bytes;
    }

    private int size(Object msg) {
        int messageSize = this.sizeEstimatorHandle.size(msg);
        if (messageSize < 0) {
            messageSize = 0;
        }
        return messageSize + PENDING_WRITE_OVERHEAD;
    }

    public void add(Object msg, Promise<Void> promise) {
        assert (this.executor.inEventLoop());
        Objects.requireNonNull(msg, "msg");
        Objects.requireNonNull(promise, "promise");
        int messageSize = this.size(msg);
        PendingWrite write = PendingWrite.newInstance(msg, messageSize, promise);
        PendingWrite currentTail = this.tail;
        if (currentTail == null) {
            this.tail = this.head = write;
        } else {
            currentTail.next = write;
            this.tail = write;
        }
        ++this.size;
        this.bytes += (long)messageSize;
    }

    public Future<Void> removeAndTransferAll(Function<Object, Future<Void>> transferFunc) {
        assert (this.executor.inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        Promise<Void> p = this.executor.newPromise();
        PromiseCombiner combiner = new PromiseCombiner(this.executor);
        try {
            PendingWrite write = this.head;
            while (write != null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (write != null) {
                    PendingWrite next = write.next;
                    Object msg = write.msg;
                    Promise<Void> promise = write.promise;
                    this.recycle(write, false);
                    transferFunc.apply(msg).cascadeTo(promise);
                    write = next;
                }
                write = this.head;
            }
            combiner.finish(p);
        }
        catch (Throwable cause) {
            p.setFailure(cause);
        }
        this.assertEmpty();
        return p.asFuture();
    }

    public void removeAndFailAll(Throwable cause) {
        assert (this.executor.inEventLoop());
        Objects.requireNonNull(cause, "cause");
        PendingWrite write = this.head;
        while (write != null) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (write != null) {
                PendingWrite next = write.next;
                SilentDispose.dispose(write.msg, logger);
                Promise<Void> promise = write.promise;
                this.recycle(write, false);
                PendingWriteQueue.safeFail(promise, cause);
                write = next;
            }
            write = this.head;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable cause) {
        assert (this.executor.inEventLoop());
        Objects.requireNonNull(cause, "cause");
        PendingWrite write = this.head;
        if (write == null) {
            return;
        }
        SilentDispose.dispose(write.msg, logger);
        Promise<Void> promise = write.promise;
        PendingWriteQueue.safeFail(promise, cause);
        this.recycle(write, true);
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public Future<Void> removeAndTransfer(Function<Object, Future<Void>> transferFunc) {
        assert (this.executor.inEventLoop());
        PendingWrite write = this.head;
        if (write == null) {
            return null;
        }
        Object msg = write.msg;
        Promise<Void> promise = write.promise;
        this.recycle(write, true);
        Future<Void> future = transferFunc.apply(msg);
        future.cascadeTo(promise);
        return future;
    }

    public Promise<Void> remove() {
        assert (this.executor.inEventLoop());
        PendingWrite write = this.head;
        if (write == null) {
            return null;
        }
        Promise<Void> promise = write.promise;
        SilentDispose.dispose(write.msg, logger);
        this.recycle(write, true);
        return promise;
    }

    public Object current() {
        assert (this.executor.inEventLoop());
        PendingWrite write = this.head;
        if (write == null) {
            return null;
        }
        return write.msg;
    }

    private void recycle(PendingWrite write, boolean update) {
        PendingWrite next = write.next;
        long writeSize = write.size;
        if (update) {
            if (next == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = next;
                --this.size;
                this.bytes -= writeSize;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        write.recycle();
    }

    private static void safeFail(Promise<Void> promise, Throwable cause) {
        if (!promise.tryFailure(cause)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise, (Object)cause);
        }
    }

    static final class PendingWrite {
        private static final ObjectPool<PendingWrite> RECYCLER = ObjectPool.newPool(PendingWrite::new);
        private final ObjectPool.Handle<PendingWrite> handle;
        private PendingWrite next;
        private long size;
        private Promise<Void> promise;
        private Object msg;

        private PendingWrite(ObjectPool.Handle<PendingWrite> handle) {
            this.handle = handle;
        }

        static PendingWrite newInstance(Object msg, int size, Promise<Void> promise) {
            PendingWrite write = RECYCLER.get();
            write.size = size;
            write.msg = msg;
            write.promise = promise;
            return write;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

