/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.Channel;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.util.internal.ObjectUtil;

public class MaxMessagesWriteHandleFactory
implements WriteHandleFactory {
    private final int maxMessagesPerWrite;

    public MaxMessagesWriteHandleFactory(int maxMessagesPerWrite) {
        this.maxMessagesPerWrite = ObjectUtil.checkPositive(maxMessagesPerWrite, "maxMessagesPerWrite");
    }

    @Override
    public final WriteHandleFactory.WriteHandle newHandle(Channel channel) {
        return this.newHandle(channel, this.maxMessagesPerWrite);
    }

    protected MaxMessagesWriteHandle newHandle(Channel channel, int maxMessagesPerWrite) {
        return new MaxMessagesWriteHandle(maxMessagesPerWrite);
    }

    protected static class MaxMessagesWriteHandle
    implements WriteHandleFactory.WriteHandle {
        private final int maxMessagesPerWrite;
        private int totalNumMessages;

        protected MaxMessagesWriteHandle(int maxMessagesPerWrite) {
            this.maxMessagesPerWrite = ObjectUtil.checkPositive(maxMessagesPerWrite, "maxMessagesPerWrite");
        }

        @Override
        public boolean lastWrite(long attemptedBytesWrite, long actualBytesWrite, int numMessagesWrite) {
            if (numMessagesWrite > 0) {
                this.totalNumMessages += numMessagesWrite;
            }
            return this.totalNumMessages <= this.maxMessagesPerWrite;
        }

        @Override
        public void writeComplete() {
            this.totalNumMessages = 0;
        }
    }
}

