/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.Channel;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.util.internal.ObjectUtil;

public abstract class MaxMessagesReadHandleFactory
implements ReadHandleFactory {
    private final int maxMessagesPerRead;

    protected MaxMessagesReadHandleFactory() {
        this(1);
    }

    protected MaxMessagesReadHandleFactory(int maxMessagesPerRead) {
        this.maxMessagesPerRead = ObjectUtil.checkPositive(maxMessagesPerRead, "maxMessagesPerRead");
    }

    @Override
    public final ReadHandleFactory.ReadHandle newHandle(Channel channel) {
        return this.newMaxMessageHandle(this.maxMessagesPerRead);
    }

    protected abstract MaxMessageReadHandle newMaxMessageHandle(int var1);

    protected static abstract class MaxMessageReadHandle
    implements ReadHandleFactory.ReadHandle {
        private final int maxMessagesPerRead;
        private int totalMessages;

        protected MaxMessageReadHandle(int maxMessagesPerRead) {
            this.maxMessagesPerRead = ObjectUtil.checkPositive(maxMessagesPerRead, "maxMessagesPerRead");
        }

        @Override
        public boolean lastRead(int attemptedBytesRead, int actualBytesRead, int numMessagesRead) {
            if (numMessagesRead > 0) {
                this.totalMessages += numMessagesRead;
            }
            return this.totalMessages < this.maxMessagesPerRead;
        }

        @Override
        public void readComplete() {
            this.totalMessages = 0;
        }
    }
}

