/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.MaxMessagesReadHandleFactory;
import io.netty5.util.internal.ObjectUtil;

public class FixedReadHandleFactory
extends MaxMessagesReadHandleFactory {
    private final int bufferSize;

    public FixedReadHandleFactory(int bufferSize) {
        this.bufferSize = ObjectUtil.checkPositive(bufferSize, "bufferSize");
    }

    public FixedReadHandleFactory(int maxMessagesPerRead, int bufferSize) {
        super(maxMessagesPerRead);
        this.bufferSize = ObjectUtil.checkPositive(bufferSize, "bufferSize");
    }

    @Override
    public MaxMessagesReadHandleFactory.MaxMessageReadHandle newMaxMessageHandle(int maxMessagesPerRead) {
        return new ReadHandleImpl(maxMessagesPerRead, this.bufferSize);
    }

    private static final class ReadHandleImpl
    extends MaxMessagesReadHandleFactory.MaxMessageReadHandle {
        private final int bufferSize;

        ReadHandleImpl(int maxMessagesPerRead, int bufferSize) {
            super(maxMessagesPerRead);
            this.bufferSize = bufferSize;
        }

        @Override
        public int estimatedBufferCapacity() {
            return this.bufferSize;
        }
    }
}

