/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelPipelineException;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultChannelHandlerContext;
import io.netty5.channel.MessageSizeEstimator;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.util.Resource;
import io.netty5.util.ResourceLeakDetector;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.FastThreadLocal;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.IntSupplier;
import java.util.function.Predicate;

public abstract class DefaultChannelPipeline
implements ChannelPipeline {
    static final ReadBufferAllocator DEFAULT_READ_BUFFER_ALLOCATOR = BufferAllocator::allocate;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    private static final String HEAD_NAME = DefaultChannelPipeline.generateName0(HeadHandler.class);
    private static final String TAIL_NAME = DefaultChannelPipeline.generateName0(TailHandler.class);
    private static final ChannelHandler HEAD_HANDLER = new HeadHandler();
    private static final ChannelHandler TAIL_HANDLER = new TailHandler();
    private static final FastThreadLocal<Map<Class<?>, String>> nameCaches = new FastThreadLocal<Map<Class<?>, String>>(){

        @Override
        protected Map<Class<?>, String> initialValue() {
            return new WeakHashMap();
        }
    };
    private static final AtomicReferenceFieldUpdater<DefaultChannelPipeline, MessageSizeEstimator.Handle> ESTIMATOR = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelPipeline.class, MessageSizeEstimator.Handle.class, "estimatorHandle");
    private final DefaultChannelHandlerContext head;
    private final DefaultChannelHandlerContext tail;
    private final Channel channel;
    private final Future<Void> succeededFuture;
    private final boolean touch = ResourceLeakDetector.isEnabled();
    private final List<DefaultChannelHandlerContext> handlers = new ArrayList<DefaultChannelHandlerContext>(4);
    private volatile MessageSizeEstimator.Handle estimatorHandle;
    private static final AtomicLongFieldUpdater<DefaultChannelPipeline> TOTAL_PENDING_OUTBOUND_BYTES_UPDATER = AtomicLongFieldUpdater.newUpdater(DefaultChannelPipeline.class, "pendingOutboundBytes");
    private volatile long pendingOutboundBytes;

    protected DefaultChannelPipeline(Channel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.succeededFuture = channel.executor().newSucceededFuture(null);
        this.tail = new DefaultChannelHandlerContext(this, TAIL_NAME, TAIL_HANDLER);
        this.head = new DefaultChannelHandlerContext(this, HEAD_NAME, HEAD_HANDLER);
        this.head.next = this.tail;
        this.tail.prev = this.head;
        this.head.setAddComplete();
        this.tail.setAddComplete();
    }

    final MessageSizeEstimator.Handle estimatorHandle() {
        MessageSizeEstimator.Handle handle = this.estimatorHandle;
        if (handle == null && !ESTIMATOR.compareAndSet(this, null, handle = this.channel.getOption(ChannelOption.MESSAGE_SIZE_ESTIMATOR).newHandle())) {
            handle = this.estimatorHandle;
        }
        return handle;
    }

    final Object touch(Object msg, DefaultChannelHandlerContext next) {
        if (this.touch) {
            Resource.touch(msg, next);
        }
        return msg;
    }

    private DefaultChannelHandlerContext newContext(String name, ChannelHandler handler) {
        DefaultChannelPipeline.checkMultiplicity(handler);
        if (name == null) {
            name = this.generateName(handler);
        }
        return new DefaultChannelHandlerContext(this, name, handler);
    }

    private void checkDuplicateName(String name) {
        if (this.context(name) != null) {
            throw new IllegalArgumentException("Duplicate handler name: " + name);
        }
    }

    private static int checkNoSuchElement(int idx, String name) {
        if (idx == -1) {
            throw new NoSuchElementException(name);
        }
        return idx;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    @Override
    public final EventExecutor executor() {
        return this.channel().executor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelPipeline addFirst(String name, ChannelHandler handler) {
        DefaultChannelHandlerContext newCtx = this.newContext(name, handler);
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            this.checkDuplicateName(newCtx.name());
            this.handlers.add(0, newCtx);
            if (!inEventLoop) {
                try {
                    executor.execute(() -> this.addFirst0(newCtx));
                    return this;
                }
                catch (Throwable cause) {
                    this.handlers.remove(0);
                    throw cause;
                }
            }
        }
        this.addFirst0(newCtx);
        return this;
    }

    private void addFirst0(DefaultChannelHandlerContext newCtx) {
        DefaultChannelHandlerContext nextCtx = this.head.next;
        newCtx.prev = this.head;
        newCtx.next = nextCtx;
        this.head.next = newCtx;
        nextCtx.prev = newCtx;
        this.callHandlerAdded0(newCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelPipeline addLast(String name, ChannelHandler handler) {
        DefaultChannelHandlerContext newCtx = this.newContext(name, handler);
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            this.checkDuplicateName(newCtx.name());
            this.handlers.add(newCtx);
            if (!inEventLoop) {
                try {
                    executor.execute(() -> this.addLast0(newCtx));
                    return this;
                }
                catch (Throwable cause) {
                    this.handlers.remove(this.handlers.size() - 1);
                    throw cause;
                }
            }
        }
        this.addLast0(newCtx);
        return this;
    }

    private void addLast0(DefaultChannelHandlerContext newCtx) {
        DefaultChannelHandlerContext prev;
        newCtx.prev = prev = this.tail.prev;
        newCtx.next = this.tail;
        prev.next = newCtx;
        this.tail.prev = newCtx;
        this.callHandlerAdded0(newCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelPipeline addBefore(String baseName, String name, ChannelHandler handler) {
        DefaultChannelHandlerContext ctx;
        DefaultChannelHandlerContext newCtx = this.newContext(name, handler);
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            int i = DefaultChannelPipeline.checkNoSuchElement(this.findCtxIdx(context -> context.name().equals(baseName)), baseName);
            this.checkDuplicateName(newCtx.name());
            ctx = this.handlers.get(i);
            this.handlers.add(i, newCtx);
            if (!inEventLoop) {
                try {
                    executor.execute(() -> this.addBefore0(ctx, newCtx));
                    return this;
                }
                catch (Throwable cause) {
                    this.handlers.remove(i);
                    throw cause;
                }
            }
        }
        this.addBefore0(ctx, newCtx);
        return this;
    }

    private void addBefore0(DefaultChannelHandlerContext ctx, DefaultChannelHandlerContext newCtx) {
        newCtx.prev = ctx.prev;
        newCtx.next = ctx;
        ctx.prev.next = newCtx;
        ctx.prev = newCtx;
        this.callHandlerAdded0(newCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelPipeline addAfter(String baseName, String name, ChannelHandler handler) {
        DefaultChannelHandlerContext ctx;
        if (name == null) {
            name = this.generateName(handler);
        }
        DefaultChannelHandlerContext newCtx = this.newContext(name, handler);
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            int i = DefaultChannelPipeline.checkNoSuchElement(this.findCtxIdx(context -> context.name().equals(baseName)), baseName);
            this.checkDuplicateName(newCtx.name());
            ctx = this.handlers.get(i);
            this.handlers.add(i + 1, newCtx);
            if (!inEventLoop) {
                try {
                    executor.execute(() -> this.addAfter0(ctx, newCtx));
                    return this;
                }
                catch (Throwable cause) {
                    this.handlers.remove(i + 1);
                    throw cause;
                }
            }
        }
        this.addAfter0(ctx, newCtx);
        return this;
    }

    private void addAfter0(DefaultChannelHandlerContext ctx, DefaultChannelHandlerContext newCtx) {
        newCtx.prev = ctx;
        newCtx.next = ctx.next;
        ctx.next.prev = newCtx;
        ctx.next = newCtx;
        this.callHandlerAdded0(newCtx);
    }

    public final ChannelPipeline addFirst(ChannelHandler handler) {
        return this.addFirst((String)null, handler);
    }

    @Override
    public final ChannelPipeline addFirst(ChannelHandler ... handlers) {
        Objects.requireNonNull(handlers, "handlers");
        for (int i = handlers.length - 1; i >= 0; --i) {
            ChannelHandler h = handlers[i];
            if (h == null) continue;
            this.addFirst((String)null, h);
        }
        return this;
    }

    public final ChannelPipeline addLast(ChannelHandler handler) {
        return this.addLast((String)null, handler);
    }

    @Override
    public final ChannelPipeline addLast(ChannelHandler ... handlers) {
        Objects.requireNonNull(handlers, "handlers");
        for (ChannelHandler h : handlers) {
            if (h == null) continue;
            this.addLast((String)null, h);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateName(ChannelHandler handler) {
        Class<?> handlerType;
        Map<Class<?>, String> cache = nameCaches.get();
        Object name = cache.get(handlerType = handler.getClass());
        if (name == null) {
            name = DefaultChannelPipeline.generateName0(handlerType);
            cache.put(handlerType, (String)name);
        }
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            if (this.context((String)name) != null) {
                String baseName = ((String)name).substring(0, ((String)name).length() - 1);
                int i = 1;
                while (true) {
                    String newName;
                    if (this.context(newName = baseName + i) == null) {
                        name = newName;
                        break;
                    }
                    ++i;
                }
            }
        }
        return name;
    }

    private static String generateName0(Class<?> handlerType) {
        return StringUtil.simpleClassName(handlerType) + "#0";
    }

    private int findCtxIdx(Predicate<DefaultChannelHandlerContext> predicate) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            if (!predicate.test(this.handlers.get(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelPipeline remove(ChannelHandler handler) {
        DefaultChannelHandlerContext ctx;
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            int idx = DefaultChannelPipeline.checkNoSuchElement(this.findCtxIdx(context -> context.handler() == handler), null);
            ctx = this.handlers.remove(idx);
            assert (ctx != null);
            if (!inEventLoop) {
                this.scheduleRemove(idx, ctx);
                return this;
            }
        }
        this.remove0(ctx);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelHandler remove(String name) {
        DefaultChannelHandlerContext ctx;
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            int idx = DefaultChannelPipeline.checkNoSuchElement(this.findCtxIdx(context -> context.name().equals(name)), name);
            ctx = this.handlers.remove(idx);
            assert (ctx != null);
            if (!inEventLoop) {
                return this.scheduleRemove(idx, ctx);
            }
        }
        this.remove0(ctx);
        return ctx.handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends ChannelHandler> T remove(Class<T> handlerType) {
        DefaultChannelHandlerContext ctx;
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            int idx = DefaultChannelPipeline.checkNoSuchElement(this.findCtxIdx(context -> handlerType.isAssignableFrom(context.handler().getClass())), null);
            ctx = this.handlers.remove(idx);
            assert (ctx != null);
            if (!inEventLoop) {
                return this.scheduleRemove(idx, ctx);
            }
        }
        this.remove0(ctx);
        return (T)ctx.handler();
    }

    @Override
    public final <T extends ChannelHandler> T removeIfExists(String name) {
        return this.removeIfExists(() -> this.findCtxIdx(context -> name.equals(context.name())));
    }

    @Override
    public final <T extends ChannelHandler> T removeIfExists(Class<T> handlerType) {
        return this.removeIfExists(() -> this.findCtxIdx(context -> handlerType.isAssignableFrom(context.handler().getClass())));
    }

    @Override
    public final <T extends ChannelHandler> T removeIfExists(ChannelHandler handler) {
        return this.removeIfExists(() -> this.findCtxIdx(context -> handler == context.handler()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ChannelHandler> T removeIfExists(IntSupplier idxSupplier) {
        DefaultChannelHandlerContext ctx;
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            int idx = idxSupplier.getAsInt();
            if (idx == -1) {
                return null;
            }
            ctx = this.handlers.remove(idx);
            assert (ctx != null);
            if (!inEventLoop) {
                return this.scheduleRemove(idx, ctx);
            }
        }
        this.remove0(ctx);
        return (T)ctx.handler();
    }

    private void remove0(DefaultChannelHandlerContext ctx) {
        try {
            this.callHandlerRemoved0(ctx);
        }
        finally {
            ctx.remove(true);
        }
    }

    @Override
    public final ChannelPipeline replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        this.replace((DefaultChannelHandlerContext ctx) -> ctx.handler() == oldHandler, newName, newHandler);
        return this;
    }

    @Override
    public final ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        return this.replace((DefaultChannelHandlerContext ctx) -> ctx.name().equals(oldName), newName, newHandler);
    }

    @Override
    public final <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return (T)this.replace((DefaultChannelHandlerContext ctx) -> oldHandlerType.isAssignableFrom(ctx.handler().getClass()), newName, newHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelHandler replace(Predicate<DefaultChannelHandlerContext> predicate, String newName, ChannelHandler newHandler) {
        DefaultChannelHandlerContext oldCtx;
        DefaultChannelHandlerContext newCtx = this.newContext(newName, newHandler);
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            int idx = DefaultChannelPipeline.checkNoSuchElement(this.findCtxIdx(predicate), null);
            oldCtx = this.handlers.get(idx);
            assert (oldCtx != this.head && oldCtx != this.tail && oldCtx != null);
            if (!oldCtx.name().equals(newCtx.name())) {
                this.checkDuplicateName(newCtx.name());
            }
            DefaultChannelHandlerContext removed = this.handlers.set(idx, newCtx);
            assert (removed != null);
            if (!inEventLoop) {
                try {
                    executor.execute(() -> this.replace0(oldCtx, newCtx));
                    return oldCtx.handler();
                }
                catch (Throwable cause) {
                    this.handlers.set(idx, oldCtx);
                    throw cause;
                }
            }
        }
        this.replace0(oldCtx, newCtx);
        return oldCtx.handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace0(DefaultChannelHandlerContext oldCtx, DefaultChannelHandlerContext newCtx) {
        DefaultChannelHandlerContext prev = oldCtx.prev;
        DefaultChannelHandlerContext next = oldCtx.next;
        newCtx.prev = prev;
        newCtx.next = next;
        prev.next = newCtx;
        next.prev = newCtx;
        oldCtx.prev = newCtx;
        oldCtx.next = newCtx;
        try {
            this.callHandlerAdded0(newCtx);
            this.callHandlerRemoved0(oldCtx);
        }
        finally {
            oldCtx.remove(false);
        }
    }

    private static void checkMultiplicity(ChannelHandler handler) {
        if (handler instanceof ChannelHandlerAdapter) {
            ChannelHandlerAdapter h = (ChannelHandlerAdapter)handler;
            if (!h.isSharable() && h.added) {
                throw new ChannelPipelineException(h.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            h.added = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHandlerAdded0(DefaultChannelHandlerContext ctx) {
        try {
            ctx.callHandlerAdded();
        }
        catch (Throwable t) {
            boolean removed = false;
            try {
                List<DefaultChannelHandlerContext> list = this.handlers;
                synchronized (list) {
                    this.handlers.remove(ctx);
                }
                ctx.callHandlerRemoved();
                removed = true;
            }
            catch (Throwable t2) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to remove a handler: " + ctx.name(), t2);
                }
            }
            finally {
                ctx.remove(true);
            }
            if (removed) {
                this.fireChannelExceptionCaught(new ChannelPipelineException(ctx.handler().getClass().getName() + ".handlerAdded() has thrown an exception; removed.", t));
            }
            this.fireChannelExceptionCaught(new ChannelPipelineException(ctx.handler().getClass().getName() + ".handlerAdded() has thrown an exception; also failed to remove.", t));
        }
    }

    private void callHandlerRemoved0(DefaultChannelHandlerContext ctx) {
        try {
            ctx.callHandlerRemoved();
        }
        catch (Throwable t) {
            this.fireChannelExceptionCaught(new ChannelPipelineException(ctx.handler().getClass().getName() + ".handlerRemoved() has thrown an exception.", t));
        }
    }

    @Override
    public final ChannelHandler get(String name) {
        ChannelHandlerContext ctx = this.context(name);
        return ctx == null ? null : ctx.handler();
    }

    @Override
    public final <T extends ChannelHandler> T get(Class<T> handlerType) {
        ChannelHandlerContext ctx = this.context(handlerType);
        return (T)(ctx == null ? null : ctx.handler());
    }

    private DefaultChannelHandlerContext findCtx(Predicate<DefaultChannelHandlerContext> predicate) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            DefaultChannelHandlerContext ctx = this.handlers.get(i);
            if (!predicate.test(ctx)) continue;
            return ctx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelHandlerContext context(String name) {
        Objects.requireNonNull(name, "name");
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            return this.findCtx(ctx -> ctx.name().equals(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelHandlerContext context(ChannelHandler handler) {
        Objects.requireNonNull(handler, "handler");
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            return this.findCtx(ctx -> ctx.handler() == handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ChannelHandlerContext context(Class<? extends ChannelHandler> handlerType) {
        Objects.requireNonNull(handlerType, "handlerType");
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            return this.findCtx(ctx -> handlerType.isAssignableFrom(ctx.handler().getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<String> names() {
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            ArrayList<String> names = new ArrayList<String>(this.handlers.size());
            for (int i = 0; i < this.handlers.size(); ++i) {
                names.add(this.handlers.get(i).name());
            }
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName(this)).append('{');
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.isEmpty()) {
                for (int i = 0; i < this.handlers.size(); ++i) {
                    DefaultChannelHandlerContext ctx = this.handlers.get(i);
                    buf.append('(').append(ctx.name()).append(" = ").append(ctx.handler().getClass().getName()).append("), ");
                }
                buf.setLength(buf.length() - 2);
            }
        }
        buf.append('}');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelHandler removeFirst() {
        DefaultChannelHandlerContext ctx;
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            if (this.handlers.isEmpty()) {
                throw new NoSuchElementException();
            }
            int idx = 0;
            ctx = this.handlers.remove(idx);
            assert (ctx != null);
            if (!inEventLoop) {
                return this.scheduleRemove(idx, ctx);
            }
        }
        this.remove0(ctx);
        return ctx.handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelHandler removeLast() {
        DefaultChannelHandlerContext ctx;
        EventExecutor executor = this.executor();
        boolean inEventLoop = executor.inEventLoop();
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            if (this.handlers.isEmpty()) {
                return null;
            }
            int idx = this.handlers.size() - 1;
            ctx = this.handlers.remove(idx);
            assert (ctx != null);
            if (!inEventLoop) {
                return this.scheduleRemove(idx, ctx);
            }
        }
        this.remove0(ctx);
        return ctx.handler();
    }

    private <T extends ChannelHandler> T scheduleRemove(int idx, DefaultChannelHandlerContext ctx) {
        try {
            ctx.executor().execute(() -> this.remove0(ctx));
            return (T)ctx.handler();
        }
        catch (Throwable cause) {
            this.handlers.add(idx, ctx);
            throw cause;
        }
    }

    @Override
    public ChannelHandler first() {
        ChannelHandlerContext ctx = this.firstContext();
        return ctx == null ? null : ctx.handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelHandlerContext firstContext() {
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            return this.handlers.isEmpty() ? null : (ChannelHandlerContext)this.handlers.get(0);
        }
    }

    @Override
    public ChannelHandler last() {
        ChannelHandlerContext ctx = this.lastContext();
        return ctx == null ? null : ctx.handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelHandlerContext lastContext() {
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            return this.handlers.isEmpty() ? null : (ChannelHandlerContext)this.handlers.get(this.handlers.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ChannelHandler> toMap() {
        List<DefaultChannelHandlerContext> list = this.handlers;
        synchronized (list) {
            if (this.handlers.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, ChannelHandler> map = new LinkedHashMap<String, ChannelHandler>(this.handlers.size());
            for (int i = 0; i < this.handlers.size(); ++i) {
                ChannelHandlerContext ctx = this.handlers.get(i);
                map.put(ctx.name(), ctx.handler());
            }
            return map;
        }
    }

    @Override
    public Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.toMap().entrySet().iterator();
    }

    @Override
    public final ChannelPipeline fireChannelRegistered() {
        this.head.invokeChannelRegistered();
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelUnregistered() {
        this.head.invokeChannelUnregistered();
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelActive() {
        this.head.invokeChannelActive();
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelInactive() {
        this.head.invokeChannelInactive();
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelShutdown(ChannelShutdownDirection direction) {
        this.head.invokeChannelShutdown(direction);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelExceptionCaught(Throwable cause) {
        this.head.invokeChannelExceptionCaught(cause);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelInboundEvent(Object event) {
        this.head.invokeChannelInboundEvent(event);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelRead(Object msg) {
        this.head.invokeChannelRead(msg);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelReadComplete() {
        this.head.invokeChannelReadComplete();
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelWritabilityChanged() {
        this.head.invokeChannelWritabilityChanged();
        return this;
    }

    @Override
    public final Future<Void> bind(SocketAddress localAddress) {
        return this.tail.bind(localAddress);
    }

    @Override
    public final Future<Void> connect(SocketAddress remoteAddress) {
        return this.tail.connect(remoteAddress);
    }

    @Override
    public final Future<Void> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.tail.connect(remoteAddress, localAddress);
    }

    @Override
    public final Future<Void> disconnect() {
        return this.tail.disconnect();
    }

    @Override
    public final Future<Void> close() {
        return this.tail.close();
    }

    @Override
    public Future<Void> shutdown(ChannelShutdownDirection direction) {
        return this.tail.shutdown(direction);
    }

    @Override
    public final Future<Void> register() {
        return this.tail.register();
    }

    @Override
    public final Future<Void> deregister() {
        return this.tail.deregister();
    }

    @Override
    public final ChannelPipeline flush() {
        this.tail.flush();
        return this;
    }

    @Override
    public final ChannelPipeline read() {
        this.tail.read();
        return this;
    }

    @Override
    public final ChannelPipeline read(ReadBufferAllocator readBufferAllocator) {
        this.tail.read(readBufferAllocator);
        return this;
    }

    @Override
    public final Future<Void> write(Object msg) {
        return this.tail.write(msg);
    }

    @Override
    public final Future<Void> writeAndFlush(Object msg) {
        return this.tail.writeAndFlush(msg);
    }

    @Override
    public final Future<Void> sendOutboundEvent(Object event) {
        return this.tail.sendOutboundEvent(event);
    }

    @Override
    public final <V> Promise<V> newPromise() {
        return ChannelPipeline.super.newPromise();
    }

    @Override
    public final Future<Void> newSucceededFuture() {
        return this.succeededFuture;
    }

    @Override
    public final <V> Future<V> newSucceededFuture(V value) {
        return ChannelPipeline.super.newSucceededFuture(value);
    }

    @Override
    public final <V> Future<V> newFailedFuture(Throwable cause) {
        return ChannelPipeline.super.newFailedFuture(cause);
    }

    protected void onUnhandledInboundException(Throwable cause) {
        try {
            logger.warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", cause);
        }
        finally {
            Resource.dispose(cause);
        }
    }

    protected void onUnhandledInboundChannelActive() {
    }

    protected void onUnhandledInboundChannelInactive() {
    }

    protected void onUnhandledInboundChannelShutdown(ChannelShutdownDirection direction) {
    }

    protected void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
        try {
            logger.debug("Discarded inbound message {} that reached at the tail of the pipeline. Please check your pipeline configuration. Discarded message pipeline : {}. Channel : {}.", msg, ctx.pipeline().names(), ctx.channel());
        }
        finally {
            Resource.dispose(msg);
        }
    }

    protected void onUnhandledInboundChannelReadComplete() {
    }

    protected void onUnhandledChannelInboundEvent(Object evt) {
        Resource.dispose(evt);
    }

    protected void onUnhandledChannelWritabilityChanged() {
    }

    protected abstract void pendingOutboundBytesUpdated(long var1);

    @Override
    public final long pendingOutboundBytes() {
        return TOTAL_PENDING_OUTBOUND_BYTES_UPDATER.get(this);
    }

    final void incrementPendingOutboundBytes(long delta) {
        assert (delta > 0L);
        long pending = TOTAL_PENDING_OUTBOUND_BYTES_UPDATER.addAndGet(this, delta);
        if (pending < 0L) {
            this.forceCloseTransport();
            throw new IllegalStateException("pendingOutboundBytes overflowed, force closed transport.");
        }
        this.pendingOutboundBytesUpdated(pending);
    }

    final void decrementPendingOutboundBytes(long delta) {
        assert (delta > 0L);
        long pending = TOTAL_PENDING_OUTBOUND_BYTES_UPDATER.addAndGet(this, -delta);
        if (pending < 0L) {
            this.forceCloseTransport();
            throw new IllegalStateException("pendingOutboundBytes underflowed, force closed transport.");
        }
        this.pendingOutboundBytesUpdated(pending);
    }

    private static DefaultChannelPipeline defaultChannelPipeline(ChannelHandlerContext ctx) {
        return (DefaultChannelPipeline)ctx.pipeline();
    }

    final void forceCloseTransport() {
        EventExecutor executor = this.transportExecutor();
        Promise<Void> promise = executor.newPromise();
        if (executor.inEventLoop()) {
            this.closeTransport(promise);
        } else {
            DefaultChannelHandlerContext.safeExecute(executor, () -> this.closeTransport(promise), promise, null);
        }
    }

    protected abstract EventExecutor transportExecutor();

    protected abstract void registerTransport(Promise<Void> var1);

    protected abstract void bindTransport(SocketAddress var1, Promise<Void> var2);

    protected abstract void connectTransport(SocketAddress var1, SocketAddress var2, Promise<Void> var3);

    protected abstract void disconnectTransport(Promise<Void> var1);

    protected abstract void closeTransport(Promise<Void> var1);

    protected abstract void shutdownTransport(ChannelShutdownDirection var1, Promise<Void> var2);

    protected abstract void deregisterTransport(Promise<Void> var1);

    protected abstract void readTransport(ReadBufferAllocator var1);

    protected abstract void writeTransport(Object var1, Promise<Void> var2);

    protected abstract void flushTransport();

    protected abstract void sendOutboundEventTransport(Object var1, Promise<Void> var2);

    protected abstract boolean isTransportSupportingDisconnect();

    private static final class HeadHandler
    implements ChannelHandler {
        private HeadHandler() {
        }

        @Override
        public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.bindTransport(localAddress, promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.bindTransport(localAddress, promise), promise, null);
            }
            return promise.asFuture();
        }

        @Override
        public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.connectTransport(remoteAddress, localAddress, promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.connectTransport(remoteAddress, localAddress, promise), promise, null);
            }
            return promise.asFuture();
        }

        @Override
        public Future<Void> disconnect(ChannelHandlerContext ctx) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.disconnectTransport(promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.disconnectTransport(promise), promise, null);
            }
            return promise.asFuture();
        }

        @Override
        public Future<Void> close(ChannelHandlerContext ctx) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.closeTransport(promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.closeTransport(promise), promise, null);
            }
            return promise.asFuture();
        }

        @Override
        public Future<Void> shutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.shutdownTransport(direction, promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.shutdownTransport(direction, promise), promise, null);
            }
            return promise.asFuture();
        }

        @Override
        public Future<Void> register(ChannelHandlerContext ctx) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.registerTransport(promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.registerTransport(promise), promise, null);
            }
            return promise.asFuture();
        }

        @Override
        public Future<Void> deregister(ChannelHandlerContext ctx) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.deregisterTransport(promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.deregisterTransport(promise), promise, null);
            }
            return promise.asFuture();
        }

        @Override
        public void read(ChannelHandlerContext ctx, ReadBufferAllocator readBufferAllocator) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            if (executor.inEventLoop()) {
                pipeline.readTransport(readBufferAllocator);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.readTransport(readBufferAllocator), null, null);
            }
        }

        @Override
        public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.writeTransport(msg, promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.writeTransport(msg, promise), promise, msg);
            }
            return promise.asFuture();
        }

        @Override
        public void flush(ChannelHandlerContext ctx) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            if (executor.inEventLoop()) {
                pipeline.flushTransport();
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, pipeline::flushTransport, null, null);
            }
        }

        @Override
        public Future<Void> sendOutboundEvent(ChannelHandlerContext ctx, Object event) {
            DefaultChannelPipeline pipeline = DefaultChannelPipeline.defaultChannelPipeline(ctx);
            EventExecutor executor = pipeline.transportExecutor();
            Promise<Void> promise = executor.newPromise();
            if (executor.inEventLoop()) {
                pipeline.sendOutboundEventTransport(event, promise);
            } else {
                DefaultChannelHandlerContext.safeExecute(executor, () -> pipeline.sendOutboundEventTransport(event, promise), promise, event);
            }
            return promise.asFuture();
        }
    }

    private static final class TailHandler
    implements ChannelHandler {
        private TailHandler() {
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.defaultChannelPipeline(ctx).onUnhandledInboundChannelActive();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.defaultChannelPipeline(ctx).onUnhandledInboundChannelInactive();
        }

        @Override
        public void channelShutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) {
            DefaultChannelPipeline.defaultChannelPipeline(ctx).onUnhandledInboundChannelShutdown(direction);
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.defaultChannelPipeline(ctx).onUnhandledChannelWritabilityChanged();
        }

        @Override
        public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) {
            ((DefaultChannelPipeline)ctx.pipeline()).onUnhandledChannelInboundEvent(evt);
        }

        @Override
        public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            DefaultChannelPipeline.defaultChannelPipeline(ctx).onUnhandledInboundException(cause);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            DefaultChannelPipeline.defaultChannelPipeline(ctx).onUnhandledInboundMessage(ctx, msg);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.defaultChannelPipeline(ctx).onUnhandledInboundChannelReadComplete();
        }
    }
}

