/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelHandlerMask;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelPipelineException;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.channel.internal.DelegatingChannelHandlerContext;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Objects;

public class CombinedChannelDuplexHandler<I extends ChannelHandler, O extends ChannelHandler>
extends ChannelHandlerAdapter {
    private CombinedChannelHandlerContext inboundCtx;
    private CombinedChannelHandlerContext outboundCtx;
    private volatile boolean handlerAdded;
    private I inboundHandler;
    private O outboundHandler;

    protected CombinedChannelDuplexHandler() {
    }

    public CombinedChannelDuplexHandler(I inboundHandler, O outboundHandler) {
        this.init(inboundHandler, outboundHandler);
    }

    @Override
    public final boolean isSharable() {
        return false;
    }

    protected final void init(I inboundHandler, O outboundHandler) {
        this.validate(inboundHandler, outboundHandler);
        this.inboundHandler = inboundHandler;
        this.outboundHandler = outboundHandler;
    }

    private void validate(I inboundHandler, O outboundHandler) {
        if (this.inboundHandler != null) {
            throw new IllegalStateException("init() can not be invoked if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with non-default constructor.");
        }
        Objects.requireNonNull(inboundHandler, "inboundHandler");
        Objects.requireNonNull(outboundHandler, "outboundHandler");
        if (ChannelHandlerMask.isOutbound(inboundHandler.getClass())) {
            throw new IllegalArgumentException("inboundHandler must not implement any outbound method to get combined.");
        }
        if (ChannelHandlerMask.isInbound(outboundHandler.getClass())) {
            throw new IllegalArgumentException("outboundHandler must not implement any inbound method to get combined.");
        }
    }

    protected final I inboundHandler() {
        return this.inboundHandler;
    }

    protected final O outboundHandler() {
        return this.outboundHandler;
    }

    private void checkAdded() {
        if (!this.handlerAdded) {
            throw new IllegalStateException("handler not added to pipeline yet");
        }
    }

    public final void removeInboundHandler() {
        this.checkAdded();
        this.inboundCtx.remove();
    }

    public final void removeOutboundHandler() {
        this.checkAdded();
        this.outboundCtx.remove();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.inboundHandler == null) {
            throw new IllegalStateException("init() must be invoked before being added to a " + ChannelPipeline.class.getSimpleName() + " if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with the default constructor.");
        }
        this.outboundCtx = new CombinedChannelHandlerContext(ctx, (ChannelHandler)this.outboundHandler);
        this.inboundCtx = new CombinedChannelHandlerContext(ctx, (ChannelHandler)this.inboundHandler);
        this.handlerAdded = true;
        try {
            this.inboundHandler.handlerAdded(this.inboundCtx);
        }
        finally {
            this.outboundHandler.handlerAdded(this.outboundCtx);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            this.inboundCtx.remove();
        }
        finally {
            this.outboundCtx.remove();
        }
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelRegistered(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelRegistered();
        }
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelUnregistered(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelUnregistered();
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelActive(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelActive();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelInactive(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelInactive();
        }
    }

    @Override
    public void channelShutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelShutdown(this.inboundCtx, direction);
        } else {
            this.inboundCtx.fireChannelInactive();
        }
    }

    @Override
    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelExceptionCaught(this.inboundCtx, cause);
        } else {
            this.inboundCtx.fireChannelExceptionCaught(cause);
        }
    }

    @Override
    public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelInboundEvent(this.inboundCtx, evt);
        } else {
            this.inboundCtx.fireChannelInboundEvent(evt);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelRead(this.inboundCtx, msg);
        } else {
            this.inboundCtx.fireChannelRead(msg);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelReadComplete(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelReadComplete();
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        assert (ctx == this.inboundCtx.delegatingCtx());
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelWritabilityChanged(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelWritabilityChanged();
        }
    }

    @Override
    public Future<Void> bind(ChannelHandlerContext ctx, SocketAddress localAddress) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.bind(this.outboundCtx, localAddress);
        }
        return this.outboundCtx.bind(localAddress);
    }

    @Override
    public Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.connect(this.outboundCtx, remoteAddress, localAddress);
        }
        return this.outboundCtx.connect(remoteAddress, localAddress);
    }

    @Override
    public Future<Void> disconnect(ChannelHandlerContext ctx) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.disconnect(this.outboundCtx);
        }
        return this.outboundCtx.disconnect();
    }

    @Override
    public Future<Void> close(ChannelHandlerContext ctx) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.close(this.outboundCtx);
        }
        return this.outboundCtx.close();
    }

    @Override
    public Future<Void> shutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.shutdown(this.outboundCtx, direction);
        }
        return this.outboundCtx.shutdown(direction);
    }

    @Override
    public Future<Void> register(ChannelHandlerContext ctx) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.register(this.outboundCtx);
        }
        return this.outboundCtx.register();
    }

    @Override
    public Future<Void> deregister(ChannelHandlerContext ctx) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.deregister(this.outboundCtx);
        }
        return this.outboundCtx.deregister();
    }

    @Override
    public void read(ChannelHandlerContext ctx, ReadBufferAllocator readBufferAllocator) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            this.outboundHandler.read(this.outboundCtx, readBufferAllocator);
        } else {
            this.outboundCtx.read(readBufferAllocator);
        }
    }

    @Override
    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.write(this.outboundCtx, msg);
        }
        return this.outboundCtx.write(msg);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            this.outboundHandler.flush(this.outboundCtx);
        } else {
            this.outboundCtx.flush();
        }
    }

    @Override
    public Future<Void> sendOutboundEvent(ChannelHandlerContext ctx, Object event) {
        assert (ctx == this.outboundCtx.delegatingCtx());
        if (!this.outboundCtx.removed) {
            return this.outboundHandler.sendOutboundEvent(this.outboundCtx, event);
        }
        return this.outboundCtx.sendOutboundEvent(event);
    }

    @Override
    public long pendingOutboundBytes(ChannelHandlerContext ctx) {
        if (!this.outboundCtx.removed) {
            return this.outboundCtx.handler().pendingOutboundBytes(this.outboundCtx);
        }
        return 0L;
    }

    private static final class CombinedChannelHandlerContext
    extends DelegatingChannelHandlerContext {
        private final ChannelHandler handler;
        boolean removed;

        CombinedChannelHandlerContext(ChannelHandlerContext ctx, ChannelHandler handler) {
            super(ctx);
            this.handler = handler;
        }

        @Override
        public boolean isRemoved() {
            return this.delegatingCtx().isRemoved() || this.removed;
        }

        @Override
        public ChannelHandler handler() {
            return this.handler;
        }

        void remove() {
            EventExecutor executor = this.executor();
            if (executor.inEventLoop()) {
                this.remove0();
            } else {
                executor.execute(this::remove0);
            }
        }

        private void remove0() {
            if (!this.removed) {
                this.removed = true;
                try {
                    this.handler.handlerRemoved(this);
                }
                catch (Throwable cause) {
                    this.fireChannelExceptionCaught(new ChannelPipelineException(this.handler.getClass().getName() + ".handlerRemoved() has thrown an exception.", cause));
                }
            }
        }
    }
}

