/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureContextListener;

public final class ChannelFutureListeners {
    public static final FutureContextListener<ChannelOutboundInvoker, Object> CLOSE = new Close();
    public static final FutureContextListener<ChannelOutboundInvoker, Object> CLOSE_ON_FAILURE = new CloseOnFailure();
    public static final FutureContextListener<Channel, Object> FIRE_EXCEPTION_ON_FAILURE = new FireExceptionOnFailure();

    private ChannelFutureListeners() {
    }

    private static final class FireExceptionOnFailure
    implements FutureContextListener<Channel, Object> {
        private FireExceptionOnFailure() {
        }

        @Override
        public void operationComplete(Channel context, Future<?> future) throws Exception {
            if (future.isFailed()) {
                context.pipeline().fireChannelExceptionCaught(future.cause());
            }
        }
    }

    private static final class CloseOnFailure
    implements FutureContextListener<ChannelOutboundInvoker, Object> {
        private CloseOnFailure() {
        }

        @Override
        public void operationComplete(ChannelOutboundInvoker context, Future<?> future) throws Exception {
            if (future.isFailed()) {
                context.close();
            }
        }
    }

    private static final class Close
    implements FutureContextListener<ChannelOutboundInvoker, Object> {
        private Close() {
        }

        @Override
        public void operationComplete(ChannelOutboundInvoker context, Future<?> future) throws Exception {
            context.close();
        }
    }
}

