/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.MaxMessagesReadHandleFactory;
import io.netty5.util.internal.ObjectUtil;
import java.util.ArrayList;

public class AdaptiveReadHandleFactory
extends MaxMessagesReadHandleFactory {
    static final int DEFAULT_MINIMUM = 64;
    static final int DEFAULT_INITIAL = 2048;
    static final int DEFAULT_MAXIMUM = 65536;
    private static final int INDEX_INCREMENT = 4;
    private static final int INDEX_DECREMENT = 1;
    private static final int[] SIZE_TABLE;
    private final int minIndex;
    private final int maxIndex;
    private final int initial;

    private static int getSizeTableIndex(int size) {
        int a;
        int mid;
        int low = 0;
        int high = SIZE_TABLE.length - 1;
        while (true) {
            if (high < low) {
                return low;
            }
            if (high == low) {
                return high;
            }
            mid = low + high >>> 1;
            a = SIZE_TABLE[mid];
            int b = SIZE_TABLE[mid + 1];
            if (size > b) {
                low = mid + 1;
                continue;
            }
            if (size >= a) break;
            high = mid - 1;
        }
        if (size == a) {
            return mid;
        }
        return mid + 1;
    }

    public AdaptiveReadHandleFactory() {
        this(1);
    }

    public AdaptiveReadHandleFactory(int maxMessagesPerRead) {
        this(maxMessagesPerRead, 64, 2048, 65536);
    }

    public AdaptiveReadHandleFactory(int maxMessagesPerRead, int minimum, int initial, int maximum) {
        super(maxMessagesPerRead);
        ObjectUtil.checkPositive(minimum, "minimum");
        if (initial < minimum) {
            throw new IllegalArgumentException("initial: " + initial);
        }
        if (maximum < initial) {
            throw new IllegalArgumentException("maximum: " + maximum);
        }
        int minIndex = AdaptiveReadHandleFactory.getSizeTableIndex(minimum);
        this.minIndex = SIZE_TABLE[minIndex] < minimum ? minIndex + 1 : minIndex;
        int maxIndex = AdaptiveReadHandleFactory.getSizeTableIndex(maximum);
        this.maxIndex = SIZE_TABLE[maxIndex] > maximum ? maxIndex - 1 : maxIndex;
        this.initial = initial;
    }

    @Override
    public MaxMessagesReadHandleFactory.MaxMessageReadHandle newMaxMessageHandle(int maxMessagesPerRead) {
        return new ReadHandleImpl(maxMessagesPerRead, this.minIndex, this.maxIndex, this.initial);
    }

    static {
        int i;
        ArrayList<Integer> sizeTable = new ArrayList<Integer>();
        for (i = 16; i < 512; i += 16) {
            sizeTable.add(i);
        }
        for (i = 512; i > 0; i <<= 1) {
            sizeTable.add(i);
        }
        SIZE_TABLE = new int[sizeTable.size()];
        for (i = 0; i < SIZE_TABLE.length; ++i) {
            AdaptiveReadHandleFactory.SIZE_TABLE[i] = (Integer)sizeTable.get(i);
        }
    }

    private static final class ReadHandleImpl
    extends MaxMessagesReadHandleFactory.MaxMessageReadHandle {
        private final int minIndex;
        private final int maxIndex;
        private int index;
        private int nextReceiveBufferSize;
        private boolean decreaseNow;
        private int totalBytesRead;

        ReadHandleImpl(int maxMessagesPerRead, int minIndex, int maxIndex, int initial) {
            super(maxMessagesPerRead);
            this.minIndex = minIndex;
            this.maxIndex = maxIndex;
            this.index = AdaptiveReadHandleFactory.getSizeTableIndex(initial);
            this.nextReceiveBufferSize = SIZE_TABLE[this.index];
        }

        @Override
        public boolean lastRead(int attemptedBytesRead, int actualBytesRead, int numMessagesRead) {
            if (attemptedBytesRead == actualBytesRead) {
                this.record(actualBytesRead);
            }
            if (actualBytesRead > 0) {
                this.totalBytesRead += actualBytesRead;
            }
            return super.lastRead(attemptedBytesRead, actualBytesRead, numMessagesRead);
        }

        @Override
        public int estimatedBufferCapacity() {
            return this.nextReceiveBufferSize;
        }

        private void record(int actualReadBytes) {
            if (actualReadBytes <= SIZE_TABLE[Math.max(0, this.index - 1)]) {
                if (this.decreaseNow) {
                    this.index = Math.max(this.index - 1, this.minIndex);
                    this.nextReceiveBufferSize = SIZE_TABLE[this.index];
                    this.decreaseNow = false;
                } else {
                    this.decreaseNow = true;
                }
            } else if (actualReadBytes >= this.nextReceiveBufferSize) {
                this.index = Math.min(this.index + 4, this.maxIndex);
                this.nextReceiveBufferSize = SIZE_TABLE[this.index];
                this.decreaseNow = false;
            }
        }

        @Override
        public void readComplete() {
            this.record(this.totalBytesRead());
            this.totalBytesRead = 0;
            super.readComplete();
        }

        private int totalBytesRead() {
            return this.totalBytesRead < 0 ? Integer.MAX_VALUE : this.totalBytesRead;
        }
    }
}

