/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;

@UnstableApi
public abstract class AbstractCoalescingBufferQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractCoalescingBufferQueue.class);
    private final ArrayDeque<Object> bufAndListenerPairs;
    private int readableBytes;

    protected AbstractCoalescingBufferQueue(int initSize) {
        this.bufAndListenerPairs = new ArrayDeque(initSize);
    }

    public final void addFirst(Buffer buf, Promise<Void> promise) {
        this.addFirst(buf, (Future<Void> f) -> f.cascadeTo(promise));
    }

    private void addFirst(Buffer buf, FutureListener<Void> listener) {
        if (listener != null) {
            this.bufAndListenerPairs.addFirst(listener);
        }
        this.bufAndListenerPairs.addFirst(buf);
        this.incrementReadableBytes(buf.readableBytes());
    }

    public final void add(Buffer buf) {
        this.add(buf, (FutureListener<Void>)null);
    }

    public final void add(Buffer buf, Promise<Void> promise) {
        this.add(buf, (Future<Void> f) -> f.cascadeTo(promise));
    }

    public final void add(Buffer buf, FutureListener<Void> listener) {
        this.bufAndListenerPairs.add(buf);
        if (listener != null) {
            this.bufAndListenerPairs.add(listener);
        }
        this.incrementReadableBytes(buf.readableBytes());
    }

    public final Buffer removeFirst(Promise<Void> aggregatePromise) {
        Object entry = this.bufAndListenerPairs.poll();
        if (entry == null) {
            return null;
        }
        assert (entry instanceof Buffer);
        Buffer result = (Buffer)entry;
        this.decrementReadableBytes(result.readableBytes());
        entry = this.bufAndListenerPairs.peek();
        if (entry instanceof FutureListener) {
            aggregatePromise.asFuture().addListener((FutureListener)entry);
            this.bufAndListenerPairs.poll();
        }
        return result;
    }

    public final Buffer remove(BufferAllocator alloc, int bytes, Promise<Void> aggregatePromise) {
        ObjectUtil.checkPositiveOrZero(bytes, "bytes");
        Objects.requireNonNull(aggregatePromise, "aggregatePromise");
        if (this.bufAndListenerPairs.isEmpty()) {
            assert (this.readableBytes == 0);
            return this.removeEmptyValue();
        }
        bytes = Math.min(bytes, this.readableBytes);
        Buffer toReturn = null;
        Buffer entryBuffer = null;
        int originalBytes = bytes;
        try {
            Object entry;
            while ((entry = this.bufAndListenerPairs.poll()) != null) {
                if (entry instanceof FutureListener) {
                    aggregatePromise.asFuture().addListener((FutureListener)entry);
                    continue;
                }
                entryBuffer = (Buffer)entry;
                if (entryBuffer.readableBytes() > bytes) {
                    this.bufAndListenerPairs.addFirst(entryBuffer);
                    if (bytes > 0) {
                        entryBuffer = entryBuffer.readSplit(bytes);
                        toReturn = toReturn == null ? this.composeFirst(alloc, entryBuffer) : this.compose(alloc, toReturn, entryBuffer);
                        bytes = 0;
                    }
                    break;
                }
                bytes -= entryBuffer.readableBytes();
                toReturn = toReturn == null ? this.composeFirst(alloc, entryBuffer) : this.compose(alloc, toReturn, entryBuffer);
                entryBuffer = null;
            }
        }
        catch (Throwable cause) {
            SilentDispose.dispose(entryBuffer, logger);
            SilentDispose.dispose(toReturn, logger);
            aggregatePromise.setFailure(cause);
            throw cause;
        }
        this.decrementReadableBytes(originalBytes - bytes);
        return toReturn;
    }

    public final int readableBytes() {
        return this.readableBytes;
    }

    public final boolean isEmpty() {
        return this.bufAndListenerPairs.isEmpty();
    }

    public final void releaseAndFailAll(ChannelOutboundInvoker invoker, Throwable cause) {
        this.releaseAndCompleteAll(invoker.newFailedFuture(cause));
    }

    public final void copyTo(AbstractCoalescingBufferQueue dest) {
        dest.bufAndListenerPairs.addAll(this.bufAndListenerPairs);
        dest.incrementReadableBytes(this.readableBytes);
    }

    public final void writeAndRemoveAll(ChannelHandlerContext ctx) {
        Throwable pending = null;
        Buffer previousBuf = null;
        while (true) {
            Object entry = this.bufAndListenerPairs.poll();
            try {
                if (entry == null) {
                    if (previousBuf == null) break;
                    this.decrementReadableBytes(previousBuf.readableBytes());
                    ctx.write(previousBuf).addListener(ctx.channel(), ChannelFutureListeners.FIRE_EXCEPTION_ON_FAILURE);
                    break;
                }
                if (entry instanceof Buffer) {
                    if (previousBuf != null) {
                        this.decrementReadableBytes(previousBuf.readableBytes());
                        ctx.write(previousBuf).addListener(ctx.channel(), ChannelFutureListeners.FIRE_EXCEPTION_ON_FAILURE);
                    }
                    previousBuf = (Buffer)entry;
                    continue;
                }
                if (entry instanceof Promise) {
                    this.decrementReadableBytes(previousBuf.readableBytes());
                    ctx.write(previousBuf).cascadeTo((Promise)entry);
                    previousBuf = null;
                    continue;
                }
                this.decrementReadableBytes(previousBuf.readableBytes());
                ctx.write(previousBuf).addListener((FutureListener)entry);
                previousBuf = null;
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    public String toString() {
        return "bytes: " + this.readableBytes + " buffers: " + (this.size() >> 1);
    }

    protected abstract Buffer compose(BufferAllocator var1, Buffer var2, Buffer var3);

    protected final Buffer composeIntoComposite(BufferAllocator alloc, Buffer cumulation, Buffer next) {
        return alloc.compose(List.of(cumulation.send(), next.send()));
    }

    protected final Buffer copyAndCompose(BufferAllocator alloc, Buffer cumulation, Buffer next, int minIncrement) {
        try (Buffer buffer = cumulation;){
            Buffer buffer2;
            block12: {
                Buffer buffer3 = next;
                try {
                    int sum = cumulation.readableBytes() + Math.max(minIncrement, next.readableBytes());
                    buffer2 = alloc.allocate(sum).writeBytes(cumulation).writeBytes(next);
                    if (buffer3 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (buffer3 != null) {
                        try {
                            buffer3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                buffer3.close();
            }
            return buffer2;
        }
    }

    protected Buffer composeFirst(BufferAllocator allocator, Buffer first) {
        return first;
    }

    protected abstract Buffer removeEmptyValue();

    protected final int size() {
        return this.bufAndListenerPairs.size();
    }

    private void releaseAndCompleteAll(Future<Void> future) {
        Object entry;
        Throwable pending = null;
        while ((entry = this.bufAndListenerPairs.poll()) != null) {
            try {
                if (entry instanceof Buffer) {
                    Buffer buffer = (Buffer)entry;
                    this.decrementReadableBytes(buffer.readableBytes());
                    SilentDispose.dispose(buffer, logger);
                    continue;
                }
                ((FutureListener)entry).operationComplete(future);
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    private void incrementReadableBytes(int increment) {
        int nextReadableBytes = this.readableBytes + increment;
        if (nextReadableBytes < this.readableBytes) {
            throw new IllegalStateException("buffer queue length overflow: " + this.readableBytes + " + " + increment);
        }
        this.readableBytes = nextReadableBytes;
    }

    private void decrementReadableBytes(int decrement) {
        this.readableBytes -= decrement;
        assert (this.readableBytes >= 0);
    }
}

