/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.AdaptiveReadHandleFactory;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelId;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelOutboundBuffer;
import io.netty5.channel.ChannelOutputShutdownException;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.ConnectTimeoutException;
import io.netty5.channel.DefaultChannelId;
import io.netty5.channel.DefaultChannelPipeline;
import io.netty5.channel.DefaultFileRegion;
import io.netty5.channel.DefaultMessageSizeEstimator;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MaxMessagesWriteHandleFactory;
import io.netty5.channel.MessageSizeEstimator;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.ServerChannel;
import io.netty5.channel.StacklessClosedChannelException;
import io.netty5.channel.WriteBufferWaterMark;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.util.DefaultAttributeMap;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Predicate;

public abstract class AbstractChannel<P extends Channel, L extends SocketAddress, R extends SocketAddress>
extends DefaultAttributeMap
implements Channel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannel.class);
    private static final MessageSizeEstimator DEFAULT_MSG_SIZE_ESTIMATOR = DefaultMessageSizeEstimator.DEFAULT;
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final Set<ChannelOption<?>> SUPPORTED_CHANNEL_OPTIONS = AbstractChannel.supportedOptions();
    private final P parent;
    private final ChannelId id;
    private final ChannelPipeline pipeline;
    private final ClosePromise closePromise;
    private final Runnable fireChannelWritabilityChangedTask;
    private final EventLoop eventLoop;
    private final boolean supportingDisconnect;
    private static final AtomicIntegerFieldUpdater<AbstractChannel> WRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannel.class, "writable");
    private volatile int writable = 1;
    private volatile ChannelOutboundBuffer outboundBuffer;
    private volatile L localAddress;
    private volatile R remoteAddress;
    private volatile boolean registered;
    private volatile ReadBufferAllocator currentBufferAllocator;
    private static final AtomicIntegerFieldUpdater<AbstractChannel> AUTOREAD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannel.class, "autoRead");
    private volatile BufferAllocator bufferAllocator = DefaultBufferAllocators.preferredAllocator();
    private volatile ReadHandleFactory readHandleFactory;
    private volatile WriteHandleFactory writeHandleFactory;
    private volatile MessageSizeEstimator msgSizeEstimator = DEFAULT_MSG_SIZE_ESTIMATOR;
    private volatile int connectTimeoutMillis = 30000;
    private volatile int autoRead = 1;
    private volatile boolean autoClose = true;
    private volatile WriteBufferWaterMark writeBufferWaterMark = WriteBufferWaterMark.DEFAULT;
    private volatile boolean allowHalfClosure;
    private boolean strValActive;
    private String strVal;
    private boolean closeInitiated;
    private Throwable initialCloseCause;
    private ReadBufferAllocator readBeforeActive;
    private ReadSink readSink;
    private WriteSink writeSink;
    private MessageSizeEstimator.Handle estimatorHandle;
    private boolean inWriteFlushed;
    private boolean neverRegistered = true;
    private boolean neverActive = true;
    private boolean inputClosedSeenErrorOnRead;
    private Promise<Void> connectPromise;
    private Future<?> connectTimeoutFuture;
    private R requestedRemoteAddress;

    protected AbstractChannel(P parent, EventLoop eventLoop, boolean supportingDisconnect) {
        this(parent, eventLoop, supportingDisconnect, new AdaptiveReadHandleFactory(), new MaxMessagesWriteHandleFactory(Integer.MAX_VALUE));
    }

    protected AbstractChannel(P parent, EventLoop eventLoop, boolean supportingDisconnect, ReadHandleFactory defaultReadHandleFactory, WriteHandleFactory defaultWriteHandleFactory) {
        this(parent, eventLoop, supportingDisconnect, defaultReadHandleFactory, defaultWriteHandleFactory, DefaultChannelId.newInstance());
    }

    protected AbstractChannel(P parent, EventLoop eventLoop, boolean supportingDisconnect, ReadHandleFactory defaultReadHandleFactory, WriteHandleFactory defaultWriteHandleFactory, ChannelId id) {
        this.parent = parent;
        this.eventLoop = AbstractChannel.validateEventLoopGroup(eventLoop, "eventLoop", this.getClass());
        this.id = Objects.requireNonNull(id, "id");
        this.supportingDisconnect = supportingDisconnect;
        this.readHandleFactory = Objects.requireNonNull(defaultReadHandleFactory, "defaultReadHandleFactory");
        this.writeHandleFactory = Objects.requireNonNull(defaultWriteHandleFactory, "defaultWriteHandleFactory");
        this.closePromise = new ClosePromise(eventLoop);
        this.outboundBuffer = new ChannelOutboundBuffer(eventLoop);
        this.pipeline = this.newChannelPipeline();
        this.fireChannelWritabilityChangedTask = () -> this.pipeline().fireChannelWritabilityChanged();
    }

    protected static <T extends EventLoopGroup> T validateEventLoopGroup(T group, String name, Class<? extends Channel> channelType) {
        Objects.requireNonNull(group, name);
        if (!group.isCompatible(channelType)) {
            throw new IllegalArgumentException(group + " does not support channel of type " + StringUtil.simpleClassName(channelType));
        }
        return group;
    }

    @Override
    public final ChannelId id() {
        return this.id;
    }

    protected ChannelPipeline newChannelPipeline() {
        return new DefaultAbstractChannelPipeline(this);
    }

    @Override
    public final BufferAllocator bufferAllocator() {
        return this.bufferAllocator;
    }

    public final P parent() {
        return this.parent;
    }

    @Override
    public final ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public final EventLoop executor() {
        return this.eventLoop;
    }

    public final L localAddress() {
        L localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                this.localAddress = localAddress = this.localAddress0();
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    public final R remoteAddress() {
        R remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = this.remoteAddress0();
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    protected final void cacheAddresses(L localAddress, R remoteAddress) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
    }

    @Override
    public final boolean isRegistered() {
        return this.registered;
    }

    @Override
    public final Future<Void> closeFuture() {
        return this.closePromise;
    }

    private long totalPending() {
        ChannelOutboundBuffer buf = this.outboundBuffer;
        if (buf == null) {
            return -1L;
        }
        return buf.totalPendingWriteBytes() + this.pipeline().pendingOutboundBytes();
    }

    @Override
    public final long writableBytes() {
        long totalPending = this.totalPending();
        if (totalPending == -1L) {
            return 0L;
        }
        long bytes = (long)this.writeBufferWaterMark.high() - totalPending;
        if (bytes > 0L) {
            return WRITABLE_UPDATER.get(this) == 0 ? 0L : bytes;
        }
        return 0L;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    @Override
    public final int compareTo(Channel o) {
        if (this == o) {
            return 0;
        }
        return this.id().compareTo(o.id());
    }

    public String toString() {
        boolean active = this.isActive();
        if (this.strValActive == active && this.strVal != null) {
            return this.strVal;
        }
        R remoteAddr = this.remoteAddress();
        L localAddr = this.localAddress();
        if (remoteAddr != null) {
            StringBuilder buf = new StringBuilder(96).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(localAddr).append(active ? " - " : " ! ").append("R:").append(remoteAddr).append(']');
            this.strVal = buf.toString();
        } else if (localAddr != null) {
            StringBuilder buf = new StringBuilder(64).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(localAddr).append(']');
            this.strVal = buf.toString();
        } else {
            StringBuilder buf = new StringBuilder(16).append("[id: 0x").append(this.id.asShortText()).append(']');
            this.strVal = buf.toString();
        }
        this.strValActive = active;
        return this.strVal;
    }

    protected final void readIfIsAutoRead() {
        this.assertEventLoop();
        if (this.readBeforeActive != null) {
            ReadBufferAllocator readBufferAllocator = this.readBeforeActive;
            this.readBeforeActive = null;
            this.readTransport(readBufferAllocator);
        } else if (this.isAutoRead()) {
            this.read();
        }
    }

    private void assertEventLoop() {
        assert (this.eventLoop.inEventLoop());
    }

    protected final ReadHandleFactory.ReadHandle readHandle() {
        return this.readSink().readHandle;
    }

    protected final WriteHandleFactory.WriteHandle writeHandle() {
        return this.writeSink().writeHandle;
    }

    private ReadSink readSink() {
        this.assertEventLoop();
        if (this.readSink == null) {
            this.readSink = new ReadSink(this.getReadHandleFactory().newHandle(this));
        }
        return this.readSink;
    }

    private WriteSink writeSink() {
        this.assertEventLoop();
        if (this.writeSink == null) {
            this.writeSink = new WriteSink(this.getWriteHandleFactory().newHandle(this));
        }
        return this.writeSink;
    }

    private MessageSizeEstimator.Handle sizeEstimatorHandle() {
        this.assertEventLoop();
        if (this.estimatorHandle == null) {
            this.estimatorHandle = this.getMessageSizeEstimator().newHandle();
        }
        return this.estimatorHandle;
    }

    private void registerTransport(Promise<Void> promise) {
        this.assertEventLoop();
        if (this.isRegistered()) {
            promise.setFailure(new IllegalStateException("registered to an event loop already"));
            return;
        }
        try {
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            boolean firstRegistration = this.neverRegistered;
            this.executor().registerForIo(this).addListener(f -> {
                if (f.isSuccess()) {
                    this.neverRegistered = false;
                    this.registered = true;
                    AbstractChannel.safeSetSuccess(promise);
                    this.pipeline.fireChannelRegistered();
                    if (this.isActive()) {
                        if (firstRegistration) {
                            this.fireChannelActiveIfNotActiveBefore();
                        }
                        this.readIfIsAutoRead();
                    }
                } else {
                    this.closeNowAndFail(promise, f.cause());
                }
            });
        }
        catch (Throwable t) {
            this.closeNowAndFail(promise, t);
        }
    }

    private boolean fireChannelActiveIfNotActiveBefore() {
        if (this.neverActive) {
            this.neverActive = false;
            this.pipeline().fireChannelActive();
            return true;
        }
        return false;
    }

    private void closeNowAndFail(Promise<Void> promise, Throwable cause) {
        try {
            this.cancelConnect();
            this.doClose();
        }
        catch (Exception e) {
            logger.warn("Failed to close a channel.", e);
        }
        this.closePromise.setClosed();
        AbstractChannel.safeSetFailure(promise, cause);
    }

    private void bindTransport(SocketAddress localAddress, Promise<Void> promise) {
        this.assertEventLoop();
        if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
            return;
        }
        if (localAddress instanceof InetSocketAddress && this.isOptionSupported(ChannelOption.SO_BROADCAST) && Boolean.TRUE.equals(this.getOption(ChannelOption.SO_BROADCAST)) && !((InetSocketAddress)localAddress).getAddress().isAnyLocalAddress() && !PlatformDependent.isWindows() && !PlatformDependent.maybeSuperUser()) {
            logger.warn("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; binding to a non-wildcard address (" + localAddress + ") anyway as requested.");
        }
        boolean wasActive = this.isActive();
        try {
            this.doBind(localAddress);
        }
        catch (Throwable t) {
            AbstractChannel.safeSetFailure(promise, t);
            this.closeIfClosed();
            return;
        }
        if (!wasActive && this.isActive()) {
            this.invokeLater(() -> {
                if (this.fireChannelActiveIfNotActiveBefore()) {
                    this.readIfIsAutoRead();
                }
            });
        }
        AbstractChannel.safeSetSuccess(promise);
    }

    private void disconnectTransport(Promise<Void> promise) {
        this.assertEventLoop();
        if (!promise.setUncancellable()) {
            return;
        }
        boolean wasActive = this.isActive();
        try {
            this.doDisconnect();
            this.remoteAddress = null;
            this.localAddress = null;
            this.neverActive = true;
        }
        catch (Throwable t) {
            AbstractChannel.safeSetFailure(promise, t);
            this.closeIfClosed();
            return;
        }
        if (wasActive && !this.isActive()) {
            this.invokeLater(this.pipeline::fireChannelInactive);
        }
        AbstractChannel.safeSetSuccess(promise);
        this.closeIfClosed();
    }

    protected void closeTransport(Promise<Void> promise) {
        this.assertEventLoop();
        StacklessClosedChannelException closedChannelException = StacklessClosedChannelException.newInstance(AbstractChannel.class, "close(Promise)");
        this.close(promise, closedChannelException, closedChannelException);
    }

    private void updateWritabilityIfNeeded(boolean notify, boolean notifyLater) {
        long totalPending = this.totalPending();
        if (totalPending > (long)this.writeBufferWaterMark.high()) {
            if (WRITABLE_UPDATER.compareAndSet(this, 1, 0)) {
                this.fireChannelWritabilityChangedIfNeeded(notify, notifyLater);
            }
        } else if (totalPending < (long)this.writeBufferWaterMark.low() && WRITABLE_UPDATER.compareAndSet(this, 0, 1)) {
            this.fireChannelWritabilityChangedIfNeeded(notify, notifyLater);
        }
    }

    private void fireChannelWritabilityChangedIfNeeded(boolean notify, boolean notifyLater) {
        if (!notify) {
            return;
        }
        if (notifyLater) {
            this.executor().execute(this.fireChannelWritabilityChangedTask);
        } else {
            this.pipeline().fireChannelWritabilityChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdownOutput(Promise<Void> promise, Throwable cause) {
        ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
        if (outboundBuffer == null) {
            promise.setFailure(new ClosedChannelException());
            return false;
        }
        this.outboundBuffer = null;
        ChannelOutputShutdownException shutdownCause = cause == null ? new ChannelOutputShutdownException("Channel output shutdown") : new ChannelOutputShutdownException("Channel output shutdown", cause);
        try {
            this.doShutdown(ChannelShutdownDirection.Outbound);
            promise.setSuccess(null);
        }
        catch (Throwable err) {
            promise.setFailure(err);
        }
        finally {
            outboundBuffer.failFlushedAndClose(shutdownCause, shutdownCause);
        }
        return true;
    }

    private void close(Promise<Void> promise, Throwable cause, ClosedChannelException closeCause) {
        if (!promise.setUncancellable()) {
            return;
        }
        if (this.closeInitiated) {
            if (this.closePromise.isDone()) {
                AbstractChannel.safeSetSuccess(promise);
            } else {
                this.closePromise.addListener(promise, (p, future) -> p.setSuccess(null));
            }
            return;
        }
        this.closeInitiated = true;
        boolean wasActive = this.isActive();
        ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
        this.outboundBuffer = null;
        Future<Executor> closeExecutorFuture = this.prepareToClose();
        if (closeExecutorFuture != null) {
            closeExecutorFuture.addListener(f -> {
                if (f.isFailed()) {
                    logger.warn("We couldnt obtain the closeExecutor", f.cause());
                    this.closeNow(outboundBuffer, wasActive, promise, cause, closeCause);
                } else {
                    Executor closeExecutor = (Executor)f.getNow();
                    closeExecutor.execute(() -> {
                        try {
                            this.doClose0(promise);
                        }
                        finally {
                            this.invokeLater(() -> {
                                this.closeAndUpdateWritability(outboundBuffer, cause, closeCause);
                                this.fireChannelInactiveAndDeregister(wasActive);
                            });
                        }
                    });
                }
            });
        } else {
            this.closeNow(outboundBuffer, wasActive, promise, cause, closeCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNow(ChannelOutboundBuffer outboundBuffer, boolean wasActive, Promise<Void> promise, Throwable cause, ClosedChannelException closeCause) {
        try {
            this.doClose0(promise);
        }
        finally {
            this.closeAndUpdateWritability(outboundBuffer, cause, closeCause);
        }
        if (this.inWriteFlushed) {
            this.invokeLater(() -> this.fireChannelInactiveAndDeregister(wasActive));
        } else {
            this.fireChannelInactiveAndDeregister(wasActive);
        }
    }

    private void closeAndUpdateWritability(ChannelOutboundBuffer outboundBuffer, Throwable cause, Throwable closeCause) {
        if (outboundBuffer != null) {
            outboundBuffer.failFlushedAndClose(cause, closeCause);
            this.updateWritabilityIfNeeded(false, false);
        }
    }

    private void doClose0(Promise<Void> promise) {
        try {
            this.cancelConnect();
            this.doClose();
            this.closePromise.setClosed();
            AbstractChannel.safeSetSuccess(promise);
        }
        catch (Throwable t) {
            this.closePromise.setClosed();
            AbstractChannel.safeSetFailure(promise, t);
        }
    }

    private void fireChannelInactiveAndDeregister(boolean wasActive) {
        this.deregister(this.newPromise(), wasActive && !this.isActive());
    }

    private void cancelConnect() {
        Future<?> future;
        Promise<Void> promise = this.connectPromise;
        if (promise != null) {
            promise.tryFailure(new ClosedChannelException());
            this.connectPromise = null;
        }
        if ((future = this.connectTimeoutFuture) != null) {
            future.cancel();
            this.connectTimeoutFuture = null;
        }
    }

    private void shutdownTransport(ChannelShutdownDirection direction, Promise<Void> promise) {
        this.assertEventLoop();
        if (!promise.setUncancellable()) {
            return;
        }
        if (!this.isActive()) {
            if (this.isOpen()) {
                promise.setFailure(new NotYetConnectedException());
            } else {
                promise.setFailure(new ClosedChannelException());
            }
            return;
        }
        if (this.isShutdown(direction)) {
            promise.setSuccess(null);
            return;
        }
        boolean fireEvent = false;
        switch (direction) {
            case Outbound: {
                fireEvent = this.shutdownOutput(promise, null);
                break;
            }
            case Inbound: {
                try {
                    this.doShutdown(direction);
                    promise.setSuccess(null);
                    fireEvent = true;
                }
                catch (Throwable cause) {
                    promise.setFailure(cause);
                }
                break;
            }
            default: {
                promise.setFailure((Throwable)((Object)new AssertionError()));
            }
        }
        if (fireEvent) {
            this.pipeline().fireChannelShutdown(direction);
        }
    }

    private void deregisterTransport(Promise<Void> promise) {
        this.assertEventLoop();
        this.deregister(promise, false);
    }

    private void deregister(Promise<Void> promise, boolean fireChannelInactive) {
        if (!promise.setUncancellable()) {
            return;
        }
        if (!this.registered) {
            AbstractChannel.safeSetSuccess(promise);
            return;
        }
        this.invokeLater(() -> {
            try {
                this.eventLoop.deregisterForIo(this).addListener(f -> {
                    if (f.isFailed()) {
                        logger.warn("Unexpected exception occurred while deregistering a channel.", f.cause());
                    }
                    this.deregisterDone(fireChannelInactive, promise);
                });
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception occurred while deregistering a channel.", t);
                this.deregisterDone(fireChannelInactive, promise);
            }
        });
    }

    private void deregisterDone(boolean fireChannelInactive, Promise<Void> promise) {
        if (fireChannelInactive) {
            this.pipeline.fireChannelInactive();
        }
        this.clearScheduledRead();
        if (this.registered) {
            this.registered = false;
            this.pipeline.fireChannelUnregistered();
            if (!this.isOpen()) {
                while (!this.pipeline.isEmpty()) {
                    try {
                        this.pipeline.removeLast();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            }
        }
        AbstractChannel.safeSetSuccess(promise);
    }

    private void readTransport(ReadBufferAllocator readBufferAllocator) {
        this.assertEventLoop();
        if (!this.isActive()) {
            this.readBeforeActive = readBufferAllocator;
            return;
        }
        if (this.isShutdown(ChannelShutdownDirection.Inbound)) {
            return;
        }
        boolean wasReadPending = this.currentBufferAllocator != null;
        this.currentBufferAllocator = readBufferAllocator;
        try {
            this.doRead(wasReadPending);
        }
        catch (Exception e) {
            this.invokeLater(() -> this.pipeline.fireChannelExceptionCaught(e));
            this.closeTransport(this.newPromise());
        }
    }

    protected final void readNow() {
        assert (this.executor().inEventLoop());
        if (this.isShutdown(ChannelShutdownDirection.Inbound) && (this.inputClosedSeenErrorOnRead || !this.isAllowHalfClosure())) {
            this.clearScheduledRead();
            return;
        }
        ReadSink readSink = this.readSink();
        readSink.readLoop();
    }

    protected final void shutdownReadSide() {
        if (!this.isShutdown(ChannelShutdownDirection.Inbound)) {
            if (this.isAllowHalfClosure()) {
                this.shutdownTransport(ChannelShutdownDirection.Inbound, this.newPromise());
            } else {
                this.closeTransport(this.newPromise());
            }
        } else {
            this.inputClosedSeenErrorOnRead = true;
        }
    }

    private void clearScheduledRead() {
        this.assertEventLoop();
        this.currentBufferAllocator = null;
        this.doClearScheduledRead();
    }

    protected void doClearScheduledRead() {
    }

    protected abstract boolean doReadNow(ReadSink var1) throws Exception;

    protected final boolean isReadPending() {
        this.assertEventLoop();
        return this.currentBufferAllocator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTransport(Object msg, Promise<Void> promise) {
        int size;
        this.assertEventLoop();
        ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
        if (outboundBuffer == null) {
            try {
                Resource.dispose(msg);
            }
            finally {
                IOException cause = !this.isActive() ? AbstractChannel.newClosedChannelException(this.initialCloseCause, "write(Object, Promise)") : ChannelOutputShutdownException.newInstance(AbstractChannel.class, "writeTransport(Object, Promise)");
                AbstractChannel.safeSetFailure(promise, cause);
            }
            return;
        }
        try {
            msg = this.filterOutboundMessage(msg);
            size = this.sizeEstimatorHandle().size(msg);
            if (size < 0) {
                size = 0;
            }
        }
        catch (Throwable t) {
            try {
                Resource.dispose(msg);
            }
            catch (Throwable inner) {
                t.addSuppressed(inner);
            }
            finally {
                AbstractChannel.safeSetFailure(promise, t);
            }
            return;
        }
        outboundBuffer.addMessage(msg, size, promise);
        this.updateWritabilityIfNeeded(true, false);
    }

    private void flushTransport() {
        this.assertEventLoop();
        ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
        if (outboundBuffer == null) {
            return;
        }
        outboundBuffer.addFlush();
        this.writeFlushed();
    }

    protected boolean isWriteFlushedScheduled() {
        return false;
    }

    protected final void writeFlushed() {
        this.assertEventLoop();
        if (this.isWriteFlushedScheduled()) {
            return;
        }
        this.writeFlushedNow();
    }

    protected final void writeFlushedNow() {
        this.assertEventLoop();
        if (this.inWriteFlushed) {
            return;
        }
        ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
        if (outboundBuffer == null || outboundBuffer.isEmpty()) {
            return;
        }
        this.inWriteFlushed = true;
        try {
            if (!this.isActive()) {
                if (!outboundBuffer.isEmpty()) {
                    if (this.isOpen()) {
                        outboundBuffer.failFlushed(new NotYetConnectedException());
                        this.updateWritabilityIfNeeded(true, true);
                    } else {
                        outboundBuffer.failFlushed(AbstractChannel.newClosedChannelException(this.initialCloseCause, "writeFlushed()"));
                    }
                }
                return;
            }
            WriteSink writeSink = this.writeSink();
            writeSink.writeLoop(outboundBuffer);
        }
        finally {
            this.inWriteFlushed = false;
        }
    }

    protected void writeLoopComplete(boolean allWritten) {
        if (!allWritten) {
            this.executor().execute(this::writeFlushed);
        }
    }

    private void closeWithErrorFromWriteFlushed(Throwable t) {
        this.initialCloseCause = t;
        this.close(this.newPromise(), t, AbstractChannel.newClosedChannelException(t, "writeFlushed()"));
    }

    private void handleWriteError(Throwable t) {
        this.assertEventLoop();
        if (t instanceof IOException && this.isAutoClose()) {
            this.closeWithErrorFromWriteFlushed(t);
        } else {
            try {
                if (this.shutdownOutput(this.newPromise(), t)) {
                    this.pipeline().fireChannelShutdown(ChannelShutdownDirection.Outbound);
                }
            }
            catch (Throwable t2) {
                this.initialCloseCause = t;
                this.close(this.newPromise(), t2, AbstractChannel.newClosedChannelException(t, "writeFlushed()"));
            }
        }
    }

    private static ClosedChannelException newClosedChannelException(Throwable cause, String method) {
        StacklessClosedChannelException exception = StacklessClosedChannelException.newInstance(AbstractChannel.class, method);
        if (cause != null) {
            exception.initCause(cause);
        }
        return exception;
    }

    private static void sendOutboundEventTransport(Object event, Promise<Void> promise) {
        Resource.dispose(event);
        promise.setSuccess(null);
    }

    private boolean ensureOpen(Promise<Void> promise) {
        if (this.isOpen()) {
            return true;
        }
        AbstractChannel.safeSetFailure(promise, AbstractChannel.newClosedChannelException(this.initialCloseCause, "ensureOpen(Promise)"));
        return false;
    }

    private static void safeSetSuccess(Promise<Void> promise) {
        if (!promise.trySuccess(null)) {
            logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)promise);
        }
    }

    private static void safeSetFailure(Promise<Void> promise, Throwable cause) {
        if (!promise.tryFailure(cause)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise, (Object)cause);
        }
    }

    private void closeIfClosed() {
        this.assertEventLoop();
        if (this.isOpen()) {
            return;
        }
        this.closeTransport(this.newPromise());
    }

    private void invokeLater(Runnable task) {
        try {
            this.executor().execute(task);
        }
        catch (RejectedExecutionException e) {
            logger.warn("Can't invoke task later as EventLoop rejected it", e);
        }
    }

    private static Throwable annotateConnectException(Throwable cause, SocketAddress remoteAddress) {
        if (cause instanceof ConnectException) {
            return new AnnotatedConnectException((ConnectException)cause, remoteAddress);
        }
        if (cause instanceof NoRouteToHostException) {
            return new AnnotatedNoRouteToHostException((NoRouteToHostException)cause, remoteAddress);
        }
        if (cause instanceof SocketException) {
            return new AnnotatedSocketException((SocketException)cause, remoteAddress);
        }
        return cause;
    }

    protected Future<Executor> prepareToClose() {
        return null;
    }

    protected abstract L localAddress0();

    protected abstract R remoteAddress0();

    protected abstract void doBind(SocketAddress var1) throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected abstract void doClose() throws Exception;

    protected abstract void doShutdown(ChannelShutdownDirection var1) throws Exception;

    protected abstract void doRead(boolean var1) throws Exception;

    protected abstract void doWriteNow(WriteSink var1) throws Exception;

    protected abstract boolean doConnect(SocketAddress var1, SocketAddress var2, Buffer var3) throws Exception;

    protected abstract boolean doFinishConnect(R var1) throws Exception;

    protected final boolean isConnectPending() {
        this.assertEventLoop();
        return this.connectPromise != null;
    }

    private void connectTransport(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
        this.assertEventLoop();
        if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
            return;
        }
        try {
            if (this.connectPromise != null) {
                throw new ConnectionPendingException();
            }
            if (this.remoteAddress() != null) {
                throw new AlreadyConnectedException();
            }
            boolean wasActive = this.isActive();
            Buffer message = null;
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer != null && this.isOptionSupported(ChannelOption.TCP_FASTOPEN_CONNECT) && this.getOption(ChannelOption.TCP_FASTOPEN_CONNECT).booleanValue()) {
                outboundBuffer.addFlush();
                Object current = outboundBuffer.current();
                if (current instanceof Buffer) {
                    message = (Buffer)current;
                }
            }
            if (this.doConnect(remoteAddress, localAddress, message)) {
                this.fulfillConnectPromise(promise, wasActive);
                if (message != null && message.readableBytes() == 0) {
                    outboundBuffer.remove();
                }
            } else {
                this.connectPromise = promise;
                this.requestedRemoteAddress = remoteAddress;
                int connectTimeoutMillis = this.getConnectTimeoutMillis();
                if (connectTimeoutMillis > 0) {
                    this.connectTimeoutFuture = this.executor().schedule(() -> {
                        Promise<Void> connectPromise = this.connectPromise;
                        if (connectPromise != null && !connectPromise.isDone() && connectPromise.tryFailure(new ConnectTimeoutException("connection timed out: " + remoteAddress))) {
                            this.closeTransport(this.newPromise());
                        }
                    }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
                }
                promise.asFuture().addListener(future -> {
                    if (future.isCancelled()) {
                        if (this.connectTimeoutFuture != null) {
                            this.connectTimeoutFuture.cancel();
                        }
                        this.connectPromise = null;
                        this.closeTransport(this.newPromise());
                    }
                });
            }
        }
        catch (Throwable t) {
            this.closeIfClosed();
            promise.tryFailure(AbstractChannel.annotateConnectException(t, remoteAddress));
        }
    }

    private void fulfillConnectPromise(Promise<Void> promise, boolean wasActive) {
        if (promise == null) {
            return;
        }
        boolean active = this.isActive();
        boolean promiseSet = promise.trySuccess(null);
        if (!wasActive && active && this.fireChannelActiveIfNotActiveBefore()) {
            this.readIfIsAutoRead();
        }
        if (!promiseSet) {
            this.closeTransport(this.newPromise());
        }
    }

    private void fulfillConnectPromise(Promise<Void> promise, Throwable cause) {
        if (promise == null) {
            return;
        }
        promise.tryFailure(cause);
        this.closeIfClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean finishConnect() {
        this.assertEventLoop();
        if (!this.isConnectPending()) {
            throw new AlreadyConnectedException();
        }
        boolean connectStillInProgress = false;
        try {
            boolean wasActive = this.isActive();
            if (!this.doFinishConnect(this.requestedRemoteAddress)) {
                connectStillInProgress = true;
                boolean bl = false;
                return bl;
            }
            this.requestedRemoteAddress = null;
            this.fulfillConnectPromise(this.connectPromise, wasActive);
        }
        catch (Throwable t) {
            this.fulfillConnectPromise(this.connectPromise, AbstractChannel.annotateConnectException(t, this.requestedRemoteAddress));
        }
        finally {
            if (!connectStillInProgress) {
                if (this.connectTimeoutFuture != null) {
                    this.connectTimeoutFuture.cancel();
                }
                this.connectPromise = null;
            }
        }
        return true;
    }

    protected Object filterOutboundMessage(Object msg) throws Exception {
        return msg;
    }

    protected static void validateFileRegion(DefaultFileRegion region, long position) throws IOException {
        DefaultFileRegion.validate(region, position);
    }

    protected final boolean isSupportingDisconnect() {
        return this.supportingDisconnect;
    }

    @Override
    public final <T> T getOption(ChannelOption<T> option) {
        Objects.requireNonNull(option, "option");
        if (option == ChannelOption.AUTO_READ) {
            return (T)Boolean.valueOf(this.isAutoRead());
        }
        if (option == ChannelOption.WRITE_BUFFER_WATER_MARK) {
            return (T)this.getWriteBufferWaterMark();
        }
        if (option == ChannelOption.CONNECT_TIMEOUT_MILLIS) {
            return (T)Integer.valueOf(this.getConnectTimeoutMillis());
        }
        if (option == ChannelOption.BUFFER_ALLOCATOR) {
            return (T)this.getBufferAllocator();
        }
        if (option == ChannelOption.READ_HANDLE_FACTORY) {
            return this.getReadHandleFactory();
        }
        if (option == ChannelOption.WRITE_HANDLE_FACTORY) {
            return this.getWriteHandleFactory();
        }
        if (option == ChannelOption.AUTO_CLOSE) {
            return (T)Boolean.valueOf(this.isAutoClose());
        }
        if (option == ChannelOption.MESSAGE_SIZE_ESTIMATOR) {
            return (T)this.getMessageSizeEstimator();
        }
        if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        return this.getExtendedOption(option);
    }

    protected <T> T getExtendedOption(ChannelOption<T> option) {
        throw new UnsupportedOperationException("ChannelOption not supported: " + option);
    }

    @Override
    public final <T> Channel setOption(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        option.validate(value);
        if (option == ChannelOption.AUTO_READ) {
            this.setAutoRead((Boolean)value);
        } else if (option == ChannelOption.WRITE_BUFFER_WATER_MARK) {
            this.setWriteBufferWaterMark((WriteBufferWaterMark)value);
        } else if (option == ChannelOption.CONNECT_TIMEOUT_MILLIS) {
            this.setConnectTimeoutMillis((Integer)value);
        } else if (option == ChannelOption.BUFFER_ALLOCATOR) {
            this.setBufferAllocator((BufferAllocator)value);
        } else if (option == ChannelOption.READ_HANDLE_FACTORY) {
            this.setReadHandleFactory((ReadHandleFactory)value);
        } else if (option == ChannelOption.WRITE_HANDLE_FACTORY) {
            this.setWriteHandleFactory((WriteHandleFactory)value);
        } else if (option == ChannelOption.AUTO_CLOSE) {
            this.setAutoClose((Boolean)value);
        } else if (option == ChannelOption.MESSAGE_SIZE_ESTIMATOR) {
            this.setMessageSizeEstimator((MessageSizeEstimator)value);
        } else if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)value);
        } else {
            this.setExtendedOption(option, value);
        }
        return this;
    }

    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        throw new UnsupportedOperationException("ChannelOption not supported: " + option);
    }

    @Override
    public final boolean isOptionSupported(ChannelOption<?> option) {
        if (SUPPORTED_CHANNEL_OPTIONS.contains(option)) {
            return true;
        }
        return this.isExtendedOptionSupported(option);
    }

    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return false;
    }

    private static Set<ChannelOption<?>> supportedOptions() {
        return AbstractChannel.newSupportedIdentityOptionsSet(ChannelOption.AUTO_READ, ChannelOption.WRITE_BUFFER_WATER_MARK, ChannelOption.CONNECT_TIMEOUT_MILLIS, ChannelOption.BUFFER_ALLOCATOR, ChannelOption.READ_HANDLE_FACTORY, ChannelOption.WRITE_HANDLE_FACTORY, ChannelOption.AUTO_CLOSE, ChannelOption.MESSAGE_SIZE_ESTIMATOR, ChannelOption.ALLOW_HALF_CLOSURE);
    }

    protected static Set<ChannelOption<?>> newSupportedIdentityOptionsSet(ChannelOption<?> ... options) {
        if (options == null || options.length == 0) {
            return Collections.emptySet();
        }
        Set supportedOptionsSet = Collections.newSetFromMap(new IdentityHashMap());
        Collections.addAll(supportedOptionsSet, options);
        return Collections.unmodifiableSet(supportedOptionsSet);
    }

    private int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    private void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = ObjectUtil.checkPositiveOrZero(connectTimeoutMillis, "connectTimeoutMillis");
    }

    private BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    private void setBufferAllocator(BufferAllocator bufferAllocator) {
        this.bufferAllocator = Objects.requireNonNull(bufferAllocator, "bufferAllocator");
    }

    private <T extends ReadHandleFactory> T getReadHandleFactory() {
        return (T)this.readHandleFactory;
    }

    private void setReadHandleFactory(ReadHandleFactory readHandleFactory) {
        this.readHandleFactory = Objects.requireNonNull(readHandleFactory, "readHandleFactory");
    }

    private <T extends WriteHandleFactory> T getWriteHandleFactory() {
        return (T)this.writeHandleFactory;
    }

    private void setWriteHandleFactory(WriteHandleFactory writeHandleFactory) {
        this.writeHandleFactory = Objects.requireNonNull(writeHandleFactory, "writeHandleFactory");
    }

    private boolean isAutoRead() {
        return this.autoRead == 1;
    }

    private void setAutoRead(boolean autoRead) {
        boolean oldAutoRead;
        boolean bl = oldAutoRead = AUTOREAD_UPDATER.getAndSet(this, autoRead ? 1 : 0) == 1;
        if (autoRead && !oldAutoRead) {
            this.read();
        } else if (!autoRead && oldAutoRead) {
            this.currentBufferAllocator = null;
            if (this.executor().inEventLoop()) {
                this.clearScheduledRead();
            } else {
                this.executor().execute(() -> {
                    if (!this.isReadPending() && !this.isAutoRead()) {
                        this.clearScheduledRead();
                    }
                });
            }
        }
    }

    private boolean isAutoClose() {
        return this.autoClose;
    }

    private void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    private void setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        this.writeBufferWaterMark = Objects.requireNonNull(writeBufferWaterMark, "writeBufferWaterMark");
    }

    private WriteBufferWaterMark getWriteBufferWaterMark() {
        return this.writeBufferWaterMark;
    }

    private MessageSizeEstimator getMessageSizeEstimator() {
        return this.msgSizeEstimator;
    }

    private void setMessageSizeEstimator(MessageSizeEstimator estimator) {
        this.msgSizeEstimator = Objects.requireNonNull(estimator, "estimator");
    }

    private boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    private void setAllowHalfClosure(boolean allowHalfClosure) {
        this.allowHalfClosure = allowHalfClosure;
    }

    protected BufferAllocator readBufferAllocator() {
        return this.bufferAllocator();
    }

    protected void readLoopComplete() {
    }

    protected final class WriteSink {
        private long writtenBytes;
        private int writtenMessages;
        private final Predicate<Object> predicate = o -> {
            if (o instanceof Buffer) {
                Buffer buffer = (Buffer)o;
                int readable = buffer.readableBytes();
                buffer.skipReadableBytes((int)Math.min((long)readable, this.writtenBytes));
                if (buffer.readableBytes() == 0) {
                    this.writtenBytes -= (long)readable;
                    ++this.writtenMessages;
                    return true;
                }
            }
            return false;
        };
        final WriteHandleFactory.WriteHandle writeHandle;
        private ChannelOutboundBuffer outboundBuffer;
        private long attemptedBytesWrite;
        private long actualBytesWrite;
        private int messagesWritten;
        private Throwable writeError;
        private Boolean continueWriting;

        WriteSink(WriteHandleFactory.WriteHandle writeHandle) {
            this.writeHandle = writeHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void writeLoop(ChannelOutboundBuffer outboundBuffer) {
            AbstractChannel.this.assertEventLoop();
            this.outboundBuffer = outboundBuffer;
            try {
                try {
                    do {
                        AbstractChannel.this.doWriteNow(AbstractChannel.this.writeSink);
                    } while (this.continueWriting() && !outboundBuffer.isEmpty());
                }
                catch (Throwable t) {
                    try {
                        AbstractChannel.this.handleWriteError(t);
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            AbstractChannel.this.writeLoopComplete(outboundBuffer.isEmpty());
                        }
                        catch (Throwable cause) {
                            AbstractChannel.this.closeWithErrorFromWriteFlushed(cause);
                        }
                    }
                }
                try {
                    AbstractChannel.this.writeLoopComplete(outboundBuffer.isEmpty());
                    return;
                }
                catch (Throwable cause) {
                    AbstractChannel.this.closeWithErrorFromWriteFlushed(cause);
                    return;
                }
            }
            finally {
                this.writeHandle.writeComplete();
                AbstractChannel.this.updateWritabilityIfNeeded(true, true);
            }
        }

        public int updateBufferReaderOffsets(long writtenBytes) {
            AbstractChannel.this.assertEventLoop();
            if (writtenBytes < 0L) {
                return 0;
            }
            this.writtenMessages = 0;
            this.writtenBytes = writtenBytes;
            this.forEachFlushedMessage(this.predicate);
            return this.writtenMessages;
        }

        public long estimatedMaxBytesPerGatheringWrite() {
            AbstractChannel.this.assertEventLoop();
            return this.writeHandle.estimatedMaxBytesPerGatheringWrite();
        }

        public int numFlushedMessages() {
            AbstractChannel.this.assertEventLoop();
            return this.outboundBuffer.size();
        }

        public Object currentFlushedMessage() {
            AbstractChannel.this.assertEventLoop();
            return this.outboundBuffer.current();
        }

        public void forEachFlushedMessage(Predicate<Object> processor) {
            AbstractChannel.this.assertEventLoop();
            this.outboundBuffer.forEachFlushedMessage(processor);
        }

        public void complete(long attemptedBytesWrite, long actualBytesWrite, int messagesWritten, boolean mightContinueWriting) {
            AbstractChannel.this.assertEventLoop();
            this.checkCompleteAlready();
            this.attemptedBytesWrite = ObjectUtil.checkPositiveOrZero(attemptedBytesWrite, "attemptedBytesWrite");
            this.actualBytesWrite = actualBytesWrite;
            this.messagesWritten = this.verifyMessagesWritten(messagesWritten);
            this.continueWriting = mightContinueWriting ? Boolean.TRUE : Boolean.FALSE;
            this.writeError = null;
        }

        private int verifyMessagesWritten(int messagesWritten) {
            ObjectUtil.checkPositiveOrZero(messagesWritten, "messagesWritten");
            if (messagesWritten > this.numFlushedMessages()) {
                throw new IllegalArgumentException("messagesWritten > size(): " + messagesWritten + " (expected: 0-" + this.numFlushedMessages() + ")");
            }
            return messagesWritten;
        }

        public void complete(long attemptedBytesWrite, Throwable cause, boolean mightContinueWriting) {
            AbstractChannel.this.assertEventLoop();
            this.checkCompleteAlready();
            this.attemptedBytesWrite = ObjectUtil.checkPositiveOrZero(attemptedBytesWrite, "attemptedBytesWrite");
            this.writeError = Objects.requireNonNull(cause, "cause");
            this.actualBytesWrite = 0L;
            this.messagesWritten = 0;
            this.continueWriting = mightContinueWriting ? Boolean.TRUE : Boolean.FALSE;
        }

        private void checkCompleteAlready() {
            if (this.continueWriting != null) {
                throw new IllegalStateException(StringUtil.simpleClassName(WriteSink.class) + ".complete(...) was already called");
            }
        }

        private boolean continueWriting() {
            if (this.continueWriting == null) {
                throw new IllegalStateException(StringUtil.simpleClassName(WriteSink.class) + ".complete(...) was not called");
            }
            try {
                if (this.writeError != null) {
                    this.outboundBuffer.remove(this.writeError);
                } else if (this.messagesWritten > 0) {
                    int written = this.messagesWritten;
                    do {
                        this.outboundBuffer.remove();
                    } while (--written > 0);
                }
                boolean bl = this.writeHandle.lastWrite(this.attemptedBytesWrite, this.actualBytesWrite, this.messagesWritten) && this.continueWriting == Boolean.TRUE;
                return bl;
            }
            finally {
                this.writeError = null;
                this.messagesWritten = 0;
                this.attemptedBytesWrite = 0L;
                this.actualBytesWrite = 0L;
                this.continueWriting = null;
            }
        }
    }

    protected final class ReadSink {
        final ReadHandleFactory.ReadHandle readHandle;
        private boolean readSomething;
        private boolean continueReading;

        ReadSink(ReadHandleFactory.ReadHandle readHandle) {
            this.readHandle = readHandle;
        }

        public void processRead(int attemptedBytesRead, int actualBytesRead, Object message) {
            if (message == null) {
                this.readHandle.lastRead(attemptedBytesRead, actualBytesRead, 0);
                this.continueReading = false;
            } else {
                this.readSomething = true;
                AbstractChannel.this.currentBufferAllocator = null;
                this.continueReading = this.readHandle.lastRead(attemptedBytesRead, actualBytesRead, 1);
                AbstractChannel.this.pipeline().fireChannelRead(message);
            }
        }

        public Buffer allocateBuffer() {
            ReadBufferAllocator readBufferAllocator = AbstractChannel.this.currentBufferAllocator;
            if (readBufferAllocator == null) {
                readBufferAllocator = DefaultChannelPipeline.DEFAULT_READ_BUFFER_ALLOCATOR;
            }
            return readBufferAllocator.allocate(AbstractChannel.this.readBufferAllocator(), this.readHandle.estimatedBufferCapacity());
        }

        private void complete() {
            try {
                this.readSomething();
            }
            finally {
                this.continueReading = false;
                AbstractChannel.this.readLoopComplete();
            }
        }

        private boolean completeFailure(Throwable cause) {
            try {
                this.readSomething();
                AbstractChannel.this.pipeline().fireChannelExceptionCaught(cause);
                if (cause instanceof PortUnreachableException) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = cause instanceof IOException && !(AbstractChannel.this instanceof ServerChannel);
                return bl;
            }
            finally {
                this.continueReading = false;
                AbstractChannel.this.readLoopComplete();
            }
        }

        private void readSomething() {
            if (this.readSomething) {
                this.readSomething = false;
                AbstractChannel.this.pipeline().fireChannelReadComplete();
            }
            this.readHandle.readComplete();
        }

        void readLoop() {
            boolean closed;
            this.continueReading = false;
            try {
                do {
                    try {
                        closed = AbstractChannel.this.doReadNow(this);
                    }
                    catch (Throwable cause) {
                        if (this.completeFailure(cause)) {
                            AbstractChannel.this.shutdownReadSide();
                        } else {
                            AbstractChannel.this.closeTransport(AbstractChannel.this.newPromise());
                        }
                        if (!AbstractChannel.this.isReadPending() && !AbstractChannel.this.isAutoRead()) {
                            AbstractChannel.this.clearScheduledRead();
                        }
                        return;
                    }
                } while (this.continueReading && !closed && !AbstractChannel.this.isShutdown(ChannelShutdownDirection.Inbound));
                this.complete();
            }
            finally {
                if (!AbstractChannel.this.isReadPending() && !AbstractChannel.this.isAutoRead()) {
                    AbstractChannel.this.clearScheduledRead();
                }
            }
            if (closed) {
                AbstractChannel.this.shutdownReadSide();
            } else {
                AbstractChannel.this.readIfIsAutoRead();
            }
        }
    }

    protected static class DefaultAbstractChannelPipeline
    extends DefaultChannelPipeline {
        protected DefaultAbstractChannelPipeline(AbstractChannel<?, ?, ?> channel) {
            super(channel);
        }

        protected final AbstractChannel<?, ?, ?> abstractChannel() {
            return (AbstractChannel)this.channel();
        }

        @Override
        protected final EventExecutor transportExecutor() {
            return this.abstractChannel().executor();
        }

        @Override
        protected final void pendingOutboundBytesUpdated(long pendingOutboundBytes) {
            this.abstractChannel().updateWritabilityIfNeeded(true, false);
        }

        @Override
        protected final void registerTransport(Promise<Void> promise) {
            this.abstractChannel().registerTransport(promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void bindTransport(SocketAddress localAddress, Promise<Void> promise) {
            this.abstractChannel().bindTransport(localAddress, promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void connectTransport(SocketAddress remoteAddress, SocketAddress localAddress, Promise<Void> promise) {
            this.abstractChannel().connectTransport(remoteAddress, localAddress, promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void disconnectTransport(Promise<Void> promise) {
            this.abstractChannel().disconnectTransport(promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void closeTransport(Promise<Void> promise) {
            this.abstractChannel().closeTransport(promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void shutdownTransport(ChannelShutdownDirection direction, Promise<Void> promise) {
            this.abstractChannel().shutdownTransport(direction, promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void deregisterTransport(Promise<Void> promise) {
            AbstractChannel<?, ?, ?> channel = this.abstractChannel();
            channel.deregisterTransport(promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void readTransport(ReadBufferAllocator readBufferAllocator) {
            AbstractChannel<?, ?, ?> channel = this.abstractChannel();
            channel.readTransport(readBufferAllocator);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void writeTransport(Object msg, Promise<Void> promise) {
            AbstractChannel<?, ?, ?> channel = this.abstractChannel();
            channel.writeTransport(msg, promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final void flushTransport() {
            AbstractChannel<?, ?, ?> channel = this.abstractChannel();
            channel.flushTransport();
            this.runAfterTransportOperation();
        }

        @Override
        protected final void sendOutboundEventTransport(Object event, Promise<Void> promise) {
            AbstractChannel<?, ?, ?> channel = this.abstractChannel();
            AbstractChannel.sendOutboundEventTransport(event, promise);
            this.runAfterTransportOperation();
        }

        @Override
        protected final boolean isTransportSupportingDisconnect() {
            return this.abstractChannel().isSupportingDisconnect();
        }

        protected void runAfterTransportOperation() {
        }
    }

    private static final class AnnotatedSocketException
    extends SocketException {
        private static final long serialVersionUID = 3896743275010454039L;

        AnnotatedSocketException(SocketException exception, SocketAddress remoteAddress) {
            super(exception.getMessage() + ": " + remoteAddress);
            this.initCause(exception);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedNoRouteToHostException
    extends NoRouteToHostException {
        private static final long serialVersionUID = -6801433937592080623L;

        AnnotatedNoRouteToHostException(NoRouteToHostException exception, SocketAddress remoteAddress) {
            super(exception.getMessage() + ": " + remoteAddress);
            this.initCause(exception);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedConnectException
    extends ConnectException {
        private static final long serialVersionUID = 3901958112696433556L;

        AnnotatedConnectException(ConnectException exception, SocketAddress remoteAddress) {
            super(exception.getMessage() + ": " + remoteAddress);
            this.initCause(exception);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class ClosePromise
    extends DefaultPromise<Void> {
        ClosePromise(EventExecutor eventExecutor) {
            super(eventExecutor);
        }

        @Override
        public Promise<Void> setSuccess(Void result) {
            throw new IllegalStateException();
        }

        @Override
        public Promise<Void> setFailure(Throwable cause) {
            throw new IllegalStateException();
        }

        @Override
        public boolean trySuccess(Void result) {
            throw new IllegalStateException();
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            throw new IllegalStateException();
        }

        @Override
        public boolean setUncancellable() {
            return false;
        }

        void setClosed() {
            super.trySuccess(null);
        }
    }
}

