/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.unsafe;

import io.netty5.buffer.AllocationType;
import io.netty5.buffer.AllocatorControl;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.Drop;
import io.netty5.buffer.MemoryManager;
import io.netty5.buffer.StandardAllocationTypes;
import io.netty5.buffer.internal.ArcDrop;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.internal.WrappingAllocation;
import io.netty5.buffer.unsafe.FreeAddress;
import io.netty5.buffer.unsafe.UnsafeBuffer;
import io.netty5.buffer.unsafe.UnsafeMemory;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.SystemPropertyUtil;
import java.lang.ref.Cleaner;
import java.util.function.Function;

public final class UnsafeMemoryManager
implements MemoryManager {
    private static final boolean FREE_IMMEDIATELY = SystemPropertyUtil.getBoolean("io.netty5.buffer.unsafe.UnsafeMemoryManager.freeDirectMemoryImmediately", true);

    public UnsafeMemoryManager() {
        if (!PlatformDependent.hasUnsafe()) {
            UnsupportedOperationException notSupported = new UnsupportedOperationException("Unsafe is not available.");
            notSupported.addSuppressed(PlatformDependent.getUnsafeUnavailabilityCause());
            throw notSupported;
        }
        if (!PlatformDependent.hasDirectBufferNoCleanerConstructor()) {
            throw new UnsupportedOperationException("DirectByteBuffer internal constructor is not available.");
        }
    }

    @Override
    public Buffer allocateShared(AllocatorControl control, long size, Function<Drop<Buffer>, Drop<Buffer>> dropDecorator, AllocationType allocationType) {
        UnsafeMemory memory;
        int size32 = Math.toIntExact(size);
        Cleaner cleaner = InternalBufferUtils.CLEANER;
        Drop<Buffer> drop = InternalBufferUtils.NO_OP_DROP;
        if (allocationType == StandardAllocationTypes.OFF_HEAP) {
            Object base = null;
            long address = PlatformDependent.allocateMemory(size);
            InternalBufferUtils.MEM_USAGE_NATIVE.add(size);
            memory = new UnsafeMemory(base, address, size32);
            FreeAddress freeAddress = new FreeAddress(address, size32);
            if (FREE_IMMEDIATELY) {
                drop = ArcDrop.wrap(freeAddress);
            } else {
                cleaner.register(memory, freeAddress);
            }
        } else if (allocationType == StandardAllocationTypes.ON_HEAP) {
            byte[] base = PlatformDependent.allocateUninitializedArray(size32);
            long address = PlatformDependent.byteArrayBaseOffset();
            memory = new UnsafeMemory(base, address, size32);
        } else if (allocationType instanceof WrappingAllocation) {
            byte[] base = ((WrappingAllocation)allocationType).getArray();
            long address = PlatformDependent.byteArrayBaseOffset();
            memory = new UnsafeMemory(base, address, size32);
        } else {
            throw new IllegalArgumentException("Unknown allocation type: " + allocationType);
        }
        return UnsafeMemoryManager.createBuffer(memory, size32, control, dropDecorator.apply(drop));
    }

    @Override
    public Buffer allocateConstChild(Buffer readOnlyConstParent) {
        UnsafeBuffer buf = (UnsafeBuffer)readOnlyConstParent;
        return buf.newConstChild();
    }

    @Override
    public Object unwrapRecoverableMemory(Buffer buf) {
        return ((UnsafeBuffer)buf).recover();
    }

    @Override
    public Buffer recoverMemory(AllocatorControl allocatorControl, Object recoverableMemory, Drop<Buffer> drop) {
        UnsafeMemory memory = (UnsafeMemory)recoverableMemory;
        int size = memory.size;
        return UnsafeMemoryManager.createBuffer(memory, size, allocatorControl, drop);
    }

    private static UnsafeBuffer createBuffer(UnsafeMemory memory, int size, AllocatorControl allocatorControl, Drop<Buffer> drop) {
        Drop<UnsafeBuffer> concreteDrop = InternalBufferUtils.convert(drop);
        UnsafeBuffer unsafeBuffer = new UnsafeBuffer(memory, 0L, size, allocatorControl, concreteDrop);
        concreteDrop.attach(unsafeBuffer);
        return unsafeBuffer;
    }

    @Override
    public Object sliceMemory(Object memory, int offset, int length) {
        return ((UnsafeMemory)memory).slice(offset, length);
    }

    @Override
    public void clearMemory(Object memory) {
        ((UnsafeMemory)memory).clearMemory();
    }

    @Override
    public String implementationName() {
        return "Unsafe";
    }
}

