/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.unsafe;

import io.netty5.buffer.AllocatorControl;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferClosedException;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.BufferReadOnlyException;
import io.netty5.buffer.ByteCursor;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.Drop;
import io.netty5.buffer.Owned;
import io.netty5.buffer.internal.AdaptableBuffer;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.internal.NotReadOnlyReadableComponent;
import io.netty5.buffer.unsafe.UnsafeMemory;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.UnsafeAccess;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import sun.misc.Unsafe;

@UnsafeAccess
final class UnsafeBuffer
extends AdaptableBuffer<UnsafeBuffer>
implements BufferComponent,
NotReadOnlyReadableComponent,
ComponentIterator<UnsafeBuffer>,
ComponentIterator.Next {
    private static final int CLOSED_SIZE = -1;
    private static final boolean ACCESS_UNALIGNED = PlatformDependent.isUnaligned();
    private static final boolean FLIP_BYTES = ByteOrder.BIG_ENDIAN != ByteOrder.nativeOrder();
    private static final Unsafe UNSAFE = (Unsafe)PlatformDependent.unwrapUnsafeOrNull();
    private UnsafeMemory memory;
    private Object base;
    private long baseOffset;
    private long address;
    private int rsize;
    private int wsize;
    private boolean readOnly;
    private int roff;
    private int woff;
    private int implicitCapacityLimit;
    private static final boolean BYTES_BEFORE_USE_LITTLE_ENDIAN = PlatformDependent.isUnaligned() && ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN;

    UnsafeBuffer(UnsafeMemory memory, long offset, int size, AllocatorControl control, Drop<UnsafeBuffer> drop) {
        super(drop, control);
        this.memory = memory;
        this.base = memory.base;
        this.baseOffset = offset;
        this.address = memory.address + offset;
        this.rsize = size;
        this.wsize = size;
        this.implicitCapacityLimit = 0x7FFFFFF7;
    }

    private UnsafeBuffer(UnsafeBuffer parent, Drop<UnsafeBuffer> drop) {
        super(drop, parent.control);
        this.implicitCapacityLimit = parent.implicitCapacityLimit;
        this.memory = parent.memory;
        this.base = parent.base;
        this.baseOffset = parent.baseOffset;
        this.address = parent.address;
        this.rsize = parent.rsize;
        this.wsize = parent.wsize;
        this.readOnly = parent.readOnly;
        this.roff = parent.roff;
        this.woff = parent.woff;
    }

    public String toString() {
        return "Buffer[roff:" + this.roff + ", woff:" + this.woff + ", cap:" + this.rsize + "]";
    }

    @Override
    protected RuntimeException createResourceClosedException() {
        return InternalBufferUtils.bufferIsClosed(this);
    }

    @Override
    public int capacity() {
        return Math.max(0, this.rsize);
    }

    @Override
    public int readerOffset() {
        return this.roff;
    }

    @Override
    public Buffer readerOffset(int offset) {
        this.checkRead(offset, 0);
        this.roff = offset;
        return this;
    }

    @Override
    public int writerOffset() {
        return this.woff;
    }

    @Override
    public Buffer writerOffset(int offset) {
        this.checkWrite(offset, 0, false);
        this.woff = offset;
        return this;
    }

    @Override
    public int readableBytes() {
        return super.readableBytes();
    }

    @Override
    public int writableBytes() {
        return super.writableBytes();
    }

    @Override
    public UnsafeBuffer skipReadableBytes(int delta) {
        return (UnsafeBuffer)super.skipReadableBytes(delta);
    }

    @Override
    public UnsafeBuffer skipWritableBytes(int delta) {
        return (UnsafeBuffer)super.skipWritableBytes(delta);
    }

    @Override
    public Buffer fill(byte value) {
        this.checkSet(0, this.capacity());
        if (this.rsize == -1) {
            throw this.bufferIsClosed();
        }
        try {
            PlatformDependent.setMemory(this.base, this.address, (long)this.rsize, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    private long nativeAddress() {
        return this.base == null ? this.address : 0L;
    }

    @Override
    public Buffer makeReadOnly() {
        this.readOnly = true;
        this.wsize = -1;
        return this;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.base == null;
    }

    @Override
    public Buffer implicitCapacityLimit(int limit) {
        InternalBufferUtils.checkImplicitCapacity(limit, this.capacity());
        this.implicitCapacityLimit = limit;
        return this;
    }

    @Override
    public int implicitCapacityLimit() {
        return this.implicitCapacityLimit;
    }

    @Override
    public Buffer copy(int offset, int length, boolean readOnly) {
        InternalBufferUtils.checkLength(length);
        this.checkGet(offset, length);
        if (readOnly && this.readOnly()) {
            UnsafeBuffer copy = this.newConstChild();
            copy.baseOffset += (long)offset;
            copy.address += (long)offset;
            copy.rsize = length;
            copy.roff = 0;
            copy.woff = length;
            return copy;
        }
        Buffer copy = this.control.getAllocator().allocate(length);
        try {
            this.copyInto(offset, copy, 0, length);
            copy.writerOffset(length);
            if (readOnly) {
                copy.makeReadOnly();
            }
            return copy;
        }
        catch (Throwable e) {
            copy.close();
            throw e;
        }
    }

    @Override
    public void copyInto(int srcPos, byte[] dest, int destPos, int length) {
        this.checkCopyIntoArgs(srcPos, length, destPos, dest.length);
        this.copyIntoArray(srcPos, dest, destPos, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyIntoArray(int srcPos, byte[] dest, int destPos, int length) {
        long destOffset = PlatformDependent.byteArrayBaseOffset();
        try {
            PlatformDependent.copyMemory(this.base, this.address + (long)srcPos, (Object)dest, destOffset + (long)destPos, (long)length);
        }
        finally {
            Reference.reachabilityFence(this.memory);
            Reference.reachabilityFence(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInto(int srcPos, ByteBuffer dest, int destPos, int length) {
        this.checkCopyIntoArgs(srcPos, length, destPos, dest.capacity());
        if (dest.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (dest.hasArray()) {
            this.copyIntoArray(srcPos, dest.array(), dest.arrayOffset() + destPos, length);
        } else {
            assert (dest.isDirect());
            long destAddr = PlatformDependent.directBufferAddress(dest);
            try {
                PlatformDependent.copyMemory(this.base, this.address + (long)srcPos, null, destAddr + (long)destPos, (long)length);
            }
            finally {
                Reference.reachabilityFence(this.memory);
                Reference.reachabilityFence(dest);
            }
        }
    }

    private void checkCopyIntoArgs(int srcPos, int length, int destPos, int destLength) {
        if (this.rsize == -1) {
            throw this.bufferIsClosed();
        }
        if (srcPos < 0) {
            throw new IndexOutOfBoundsException("The srcPos cannot be negative: " + srcPos + ".");
        }
        InternalBufferUtils.checkLength(length);
        if (this.rsize < srcPos + length) {
            throw new IndexOutOfBoundsException("The srcPos + length is beyond the end of the buffer: srcPos = " + srcPos + ", length = " + length + ".");
        }
        if (destPos < 0) {
            throw new IndexOutOfBoundsException("The destPos cannot be negative: " + destPos + ".");
        }
        if (destLength < destPos + length) {
            throw new IndexOutOfBoundsException("The destPos + length is beyond the end of the destination: destPos = " + destPos + ", length = " + length + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInto(int srcPos, Buffer dest, int destPos, int length) {
        if (!dest.isAccessible()) {
            throw InternalBufferUtils.bufferIsClosed(dest);
        }
        this.checkCopyIntoArgs(srcPos, length, destPos, dest.capacity());
        if (dest.readOnly()) {
            throw InternalBufferUtils.bufferIsReadOnly(this);
        }
        try {
            if (dest instanceof UnsafeBuffer) {
                UnsafeBuffer destUnsafe = (UnsafeBuffer)dest;
                long nativeAddress = destUnsafe.nativeAddress();
                if (nativeAddress != 0L) {
                    PlatformDependent.copyMemory(this.base, this.address + (long)srcPos, null, nativeAddress + (long)destPos, (long)length);
                } else {
                    PlatformDependent.copyMemory(this.base, this.address + (long)srcPos, destUnsafe.base, destUnsafe.address + (long)destPos, (long)length);
                }
            } else {
                InternalBufferUtils.copyToViaReverseLoop(this, srcPos, dest, destPos, length);
            }
        }
        finally {
            Reference.reachabilityFence(this.memory);
            Reference.reachabilityFence(dest);
        }
    }

    @Override
    public int transferTo(WritableByteChannel channel, int length) throws IOException {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        length = Math.min(this.readableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkGet(this.readerOffset(), length);
        int bytesWritten = channel.write(this.readableBuffer().limit(length));
        this.skipReadableBytes(bytesWritten);
        return bytesWritten;
    }

    @Override
    public int transferFrom(FileChannel channel, long position, int length) throws IOException {
        ObjectUtil.checkPositiveOrZero(position, "position");
        ObjectUtil.checkPositiveOrZero(length, "length");
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (this.readOnly()) {
            throw InternalBufferUtils.bufferIsReadOnly(this);
        }
        length = Math.min(this.writableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkSet(this.writerOffset(), length);
        int bytesRead = channel.read(this.writableBuffer().limit(length), position);
        if (bytesRead > 0) {
            this.skipWritableBytes(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public int transferFrom(ReadableByteChannel channel, int length) throws IOException {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (this.readOnly()) {
            throw InternalBufferUtils.bufferIsReadOnly(this);
        }
        length = Math.min(this.writableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkSet(this.writerOffset(), length);
        int bytesRead = channel.read(this.writableBuffer().limit(length));
        if (bytesRead != -1) {
            this.skipWritableBytes(bytesRead);
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bytesBefore(byte needle) {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        try {
            int offset;
            int length = this.woff - this.roff;
            int end = this.woff;
            long addr = this.address;
            if (length > 7) {
                long pattern = ((long)needle & 0xFFL) * 0x101010101010101L;
                int longEnd = offset + (length >>> 3) * 8;
                for (offset = this.roff; offset < longEnd; offset += 8) {
                    int binaryPosition;
                    long word = BYTES_BEFORE_USE_LITTLE_ENDIAN ? PlatformDependent.getLong(this.base, addr + (long)offset) : this.loadLong(addr + (long)offset);
                    long input = word ^ pattern;
                    long tmp = ((input & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL | input | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
                    int n = binaryPosition = BYTES_BEFORE_USE_LITTLE_ENDIAN ? Long.numberOfTrailingZeros(tmp) : Long.numberOfLeadingZeros(tmp);
                    if (binaryPosition >= 64) continue;
                    int n2 = offset + (binaryPosition >>> 3) - this.roff;
                    return n2;
                }
            }
            while (offset < end) {
                if (this.loadByte(addr + (long)offset) == needle) {
                    int n = offset - this.roff;
                    return n;
                }
                ++offset;
            }
            int n = -1;
            return n;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bytesBefore(Buffer needle) {
        try {
            InternalBufferUtils.UncheckedLoadByte uncheckedLoadByte = UnsafeBuffer::uncheckedLoadByte;
            int n = InternalBufferUtils.bytesBefore(this, uncheckedLoadByte, needle, needle instanceof UnsafeBuffer ? uncheckedLoadByte : null);
            return n;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    private static byte uncheckedLoadByte(Buffer buffer, int offset) {
        UnsafeBuffer unsafeBuffer = (UnsafeBuffer)buffer;
        return UNSAFE.getByte(unsafeBuffer.base, unsafeBuffer.address + (long)offset);
    }

    @Override
    public ByteCursor openCursor() {
        return this.openCursor(this.readerOffset(), this.readableBytes());
    }

    @Override
    public ByteCursor openCursor(int fromOffset, int length) {
        if (this.rsize == -1) {
            throw this.bufferIsClosed();
        }
        if (fromOffset < 0) {
            throw new IndexOutOfBoundsException("The fromOffset cannot be negative: " + fromOffset + ".");
        }
        InternalBufferUtils.checkLength(length);
        if (this.capacity() < fromOffset + length) {
            throw new IndexOutOfBoundsException("The fromOffset + length is beyond the end of the buffer: fromOffset = " + fromOffset + ", length = " + length + ".");
        }
        return new ForwardUnsafeByteCursor(this.memory, this.base, this.address, fromOffset, length);
    }

    @Override
    public ByteCursor openReverseCursor(int fromOffset, int length) {
        if (this.rsize == -1) {
            throw this.bufferIsClosed();
        }
        if (fromOffset < 0) {
            throw new IndexOutOfBoundsException("The fromOffset cannot be negative: " + fromOffset + ".");
        }
        InternalBufferUtils.checkLength(length);
        if (this.capacity() <= fromOffset) {
            throw new IndexOutOfBoundsException("The fromOffset is beyond the end of the buffer: " + fromOffset + ".");
        }
        if (fromOffset - length < -1) {
            throw new IndexOutOfBoundsException("The fromOffset - length would underflow the buffer: fromOffset = " + fromOffset + ", length = " + length + ".");
        }
        return new ReverseUnsafeByteCursor(this.memory, this.base, this.address, fromOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer ensureWritable(int size, int minimumGrowth, boolean allowCompaction) {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (!this.isOwned()) {
            throw this.attachTrace(new IllegalStateException("Buffer is not owned. Only owned buffers can call ensureWritable."));
        }
        if (size < 0) {
            throw new IllegalArgumentException("Cannot ensure writable for a negative size: " + size + ".");
        }
        if (minimumGrowth < 0) {
            throw new IllegalArgumentException("The minimum growth cannot be negative: " + minimumGrowth + ".");
        }
        if (this.rsize != this.wsize) {
            throw InternalBufferUtils.bufferIsReadOnly(this);
        }
        if (this.writableBytes() >= size) {
            return this;
        }
        if (allowCompaction && this.writableBytes() + this.readerOffset() >= size) {
            return this.compact();
        }
        long newSize = (long)this.capacity() + (long)Math.max(size - this.writableBytes(), minimumGrowth);
        InternalBufferUtils.assertValidBufferSize(newSize);
        UnsafeBuffer buffer = (UnsafeBuffer)this.control.getAllocator().allocate((int)newSize);
        try {
            this.copyInto(0, buffer, 0, this.capacity());
        }
        finally {
            Reference.reachabilityFence(this.memory);
            Reference.reachabilityFence(buffer.memory);
        }
        Drop<UnsafeBuffer> drop = buffer.unsafeGetDrop();
        this.disconnectDrop(drop);
        this.attachNewMemory(buffer.memory, drop);
        return this;
    }

    private Drop<UnsafeBuffer> disconnectDrop(Drop<UnsafeBuffer> newDrop) {
        Drop<UnsafeBuffer> drop = this.unsafeGetDrop();
        int roff = this.roff;
        int woff = this.woff;
        drop.drop(this);
        this.unsafeSetDrop(newDrop);
        this.roff = roff;
        this.woff = woff;
        return drop;
    }

    private void attachNewMemory(UnsafeMemory memory, Drop<UnsafeBuffer> drop) {
        this.memory = memory;
        this.base = memory.base;
        this.baseOffset = 0L;
        this.address = memory.address;
        this.rsize = memory.size;
        this.wsize = memory.size;
        drop.attach(this);
    }

    @Override
    public Buffer split(int splitOffset) {
        if (splitOffset < 0) {
            throw new IllegalArgumentException("The split offset cannot be negative: " + splitOffset + ".");
        }
        if (this.capacity() < splitOffset) {
            throw new IllegalArgumentException("The split offset cannot be greater than the buffer capacity, but the split offset was " + splitOffset + ", and capacity is " + this.capacity() + ".");
        }
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (!this.isOwned()) {
            throw this.attachTrace(new IllegalStateException("Cannot split a buffer that is not owned."));
        }
        Drop<UnsafeBuffer> drop = this.unsafeGetDrop().fork();
        UnsafeBuffer splitBuffer = new UnsafeBuffer(this.memory, this.baseOffset, splitOffset, this.control, drop);
        drop.attach(splitBuffer);
        splitBuffer.woff = Math.min(this.woff, splitOffset);
        splitBuffer.roff = Math.min(this.roff, splitOffset);
        boolean readOnly = this.readOnly();
        if (readOnly) {
            splitBuffer.makeReadOnly();
        }
        this.rsize -= splitOffset;
        this.baseOffset += (long)splitOffset;
        this.address += (long)splitOffset;
        if (!readOnly) {
            this.wsize = this.rsize;
        }
        this.woff = Math.max(this.woff, splitOffset) - splitOffset;
        this.roff = Math.max(this.roff, splitOffset) - splitOffset;
        return splitBuffer;
    }

    @Override
    public Buffer compact() {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (!this.isOwned()) {
            throw this.attachTrace(new IllegalStateException("Buffer must be owned in order to compact."));
        }
        if (this.readOnly()) {
            throw new BufferReadOnlyException("Buffer must be writable in order to compact, but was read-only.");
        }
        if (this.roff == 0) {
            return this;
        }
        try {
            PlatformDependent.copyMemory(this.base, this.address + (long)this.roff, this.base, this.address, (long)(this.woff - this.roff));
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        this.woff -= this.roff;
        this.roff = 0;
        return this;
    }

    @Override
    public int countComponents() {
        return 1;
    }

    @Override
    public int countReadableComponents() {
        return this.readableBytes() > 0 ? 1 : 0;
    }

    @Override
    public int countWritableComponents() {
        return this.writableBytes() > 0 ? 1 : 0;
    }

    @Override
    public boolean hasReadableArray() {
        return this.base instanceof byte[];
    }

    @Override
    public byte[] readableArray() {
        this.checkHasReadableArray();
        return (byte[])this.base;
    }

    @Override
    public int readableArrayOffset() {
        this.checkHasReadableArray();
        return Math.toIntExact(this.address + (long)this.roff - PlatformDependent.byteArrayBaseOffset());
    }

    private void checkHasReadableArray() {
        if (!this.hasReadableArray()) {
            throw new UnsupportedOperationException("No readable array available.");
        }
    }

    @Override
    public int readableArrayLength() {
        return this.woff - this.roff;
    }

    @Override
    public long baseNativeAddress() {
        return this.nativeAddress();
    }

    @Override
    public long readableNativeAddress() {
        return InternalBufferUtils.nativeAddressWithOffset(this.nativeAddress(), this.roff);
    }

    @Override
    public ByteBuffer readableBuffer() {
        return this.mutableReadableBuffer().asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer mutableReadableBuffer() {
        ByteBuffer buf = this.hasReadableArray() ? InternalBufferUtils.bbslice(ByteBuffer.wrap(this.readableArray()), this.readableArrayOffset(), this.readableArrayLength()) : PlatformDependent.directBuffer(this.address + (long)this.roff, this.readableBytes(), this.memory);
        return buf;
    }

    @Override
    public boolean hasWritableArray() {
        return this.hasReadableArray();
    }

    @Override
    public byte[] writableArray() {
        this.checkHasWritableArray();
        return (byte[])this.base;
    }

    @Override
    public int writableArrayOffset() {
        this.checkHasWritableArray();
        return Math.toIntExact(this.address + (long)this.woff - PlatformDependent.byteArrayBaseOffset());
    }

    private void checkHasWritableArray() {
        if (!this.hasReadableArray()) {
            throw new UnsupportedOperationException("No writable array available.");
        }
    }

    @Override
    public int writableArrayLength() {
        return this.writableBytes();
    }

    @Override
    public long writableNativeAddress() {
        return InternalBufferUtils.nativeAddressWithOffset(this.nativeAddress(), this.woff);
    }

    @Override
    public ByteBuffer writableBuffer() {
        ByteBuffer buf = this.hasWritableArray() ? InternalBufferUtils.bbslice(ByteBuffer.wrap(this.writableArray()), this.writableArrayOffset(), this.writableArrayLength()) : PlatformDependent.directBuffer(this.address + (long)this.woff, this.writableBytes(), this.memory);
        return buf;
    }

    @Override
    public UnsafeBuffer first() {
        return this;
    }

    @Override
    public <N extends ComponentIterator.Next & BufferComponent> N next() {
        return null;
    }

    @Override
    public <T extends BufferComponent & ComponentIterator.Next> ComponentIterator<T> forEachComponent() {
        return (ComponentIterator)this.acquire();
    }

    @Override
    public byte readByte() {
        this.checkRead(this.roff, 1);
        try {
            byte value = this.loadByte(this.address + (long)this.roff);
            ++this.roff;
            byte by = value;
            return by;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    @Override
    public byte getByte(int roff) {
        this.checkGet(roff, 1);
        try {
            byte by = this.loadByte(this.address + (long)roff);
            return by;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int getUnsignedByte(int roff) {
        return this.getByte(roff) & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeByte(byte value) {
        this.checkWrite(this.woff, 1, true);
        long offset = this.address + (long)this.woff;
        ++this.woff;
        try {
            this.storeByte(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setByte(int woff, byte value) {
        this.checkSet(woff, 1);
        long offset = this.address + (long)woff;
        try {
            this.storeByte(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeUnsignedByte(int value) {
        this.checkWrite(this.woff, 1, true);
        long offset = this.address + (long)this.woff;
        ++this.woff;
        try {
            this.storeByte(offset, (byte)(value & 0xFF));
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setUnsignedByte(int woff, int value) {
        this.checkSet(woff, 1);
        long offset = this.address + (long)woff;
        try {
            this.storeByte(offset, (byte)(value & 0xFF));
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char readChar() {
        this.checkRead(this.roff, 2);
        try {
            long offset = this.address + (long)this.roff;
            this.roff += 2;
            char c = this.loadChar(offset);
            return c;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getChar(int roff) {
        this.checkGet(roff, 2);
        try {
            long offset = this.address + (long)roff;
            char c = this.loadChar(offset);
            return c;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeChar(char value) {
        this.checkWrite(this.woff, 2, true);
        long offset = this.address + (long)this.woff;
        this.woff += 2;
        try {
            this.storeChar(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setChar(int woff, char value) {
        this.checkSet(woff, 2);
        long offset = this.address + (long)woff;
        try {
            this.storeChar(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short readShort() {
        this.checkRead(this.roff, 2);
        try {
            long offset = this.address + (long)this.roff;
            this.roff += 2;
            short s = this.loadShort(offset);
            return s;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int roff) {
        this.checkGet(roff, 2);
        try {
            long offset = this.address + (long)roff;
            short s = this.loadShort(offset);
            return s;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int getUnsignedShort(int roff) {
        return this.getShort(roff) & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeShort(short value) {
        this.checkWrite(this.woff, 2, true);
        long offset = this.address + (long)this.woff;
        this.woff += 2;
        try {
            this.storeShort(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setShort(int woff, short value) {
        this.checkSet(woff, 2);
        long offset = this.address + (long)woff;
        try {
            this.storeShort(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeUnsignedShort(int value) {
        this.checkWrite(this.woff, 2, true);
        long offset = this.address + (long)this.woff;
        this.woff += 2;
        try {
            this.storeShort(offset, (short)(value & 0xFFFF));
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setUnsignedShort(int woff, int value) {
        this.checkSet(woff, 2);
        long offset = this.address + (long)woff;
        try {
            this.storeShort(offset, (short)(value & 0xFFFF));
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    @Override
    public int readMedium() {
        this.checkRead(this.roff, 3);
        long offset = this.address + (long)this.roff;
        int value = this.loadByte(offset) << 16 | (this.loadByte(offset + 1L) & 0xFF) << 8 | this.loadByte(offset + 2L) & 0xFF;
        this.roff += 3;
        return value;
    }

    @Override
    public int getMedium(int roff) {
        this.checkGet(roff, 3);
        long offset = this.address + (long)roff;
        return this.loadByte(offset) << 16 | (this.loadByte(offset + 1L) & 0xFF) << 8 | this.loadByte(offset + 2L) & 0xFF;
    }

    @Override
    public int readUnsignedMedium() {
        this.checkRead(this.roff, 3);
        long offset = this.address + (long)this.roff;
        int value = (this.loadByte(offset) << 16 | (this.loadByte(offset + 1L) & 0xFF) << 8 | this.loadByte(offset + 2L) & 0xFF) & 0xFFFFFF;
        this.roff += 3;
        return value;
    }

    @Override
    public int getUnsignedMedium(int roff) {
        this.checkGet(roff, 3);
        long offset = this.address + (long)roff;
        return (this.loadByte(offset) << 16 | (this.loadByte(offset + 1L) & 0xFF) << 8 | this.loadByte(offset + 2L) & 0xFF) & 0xFFFFFF;
    }

    @Override
    public Buffer writeMedium(int value) {
        this.checkWrite(this.woff, 3, true);
        long offset = this.address + (long)this.woff;
        this.storeByte(offset, (byte)(value >> 16));
        this.storeByte(offset + 1L, (byte)(value >> 8 & 0xFF));
        this.storeByte(offset + 2L, (byte)(value & 0xFF));
        this.woff += 3;
        return this;
    }

    @Override
    public Buffer setMedium(int woff, int value) {
        this.checkSet(woff, 3);
        long offset = this.address + (long)woff;
        this.storeByte(offset, (byte)(value >> 16));
        this.storeByte(offset + 1L, (byte)(value >> 8 & 0xFF));
        this.storeByte(offset + 2L, (byte)(value & 0xFF));
        return this;
    }

    @Override
    public Buffer writeUnsignedMedium(int value) {
        this.checkWrite(this.woff, 3, true);
        long offset = this.address + (long)this.woff;
        this.storeByte(offset, (byte)(value >> 16));
        this.storeByte(offset + 1L, (byte)(value >> 8 & 0xFF));
        this.storeByte(offset + 2L, (byte)(value & 0xFF));
        this.woff += 3;
        return this;
    }

    @Override
    public Buffer setUnsignedMedium(int woff, int value) {
        this.checkSet(woff, 3);
        long offset = this.address + (long)woff;
        this.storeByte(offset, (byte)(value >> 16));
        this.storeByte(offset + 1L, (byte)(value >> 8 & 0xFF));
        this.storeByte(offset + 2L, (byte)(value & 0xFF));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt() {
        this.checkRead(this.roff, 4);
        try {
            long offset = this.address + (long)this.roff;
            this.roff += 4;
            int n = this.loadInt(offset);
            return n;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int roff) {
        this.checkGet(roff, 4);
        try {
            long offset = this.address + (long)roff;
            int n = this.loadInt(offset);
            return n;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedInt(int roff) {
        return (long)this.getInt(roff) & 0xFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeInt(int value) {
        this.checkWrite(this.woff, 4, true);
        long offset = this.address + (long)this.woff;
        this.woff += 4;
        try {
            this.storeInt(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setInt(int woff, int value) {
        this.checkSet(woff, 4);
        long offset = this.address + (long)woff;
        try {
            this.storeInt(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeUnsignedInt(long value) {
        this.checkWrite(this.woff, 4, true);
        long offset = this.address + (long)this.woff;
        this.woff += 4;
        try {
            this.storeInt(offset, (int)(value & 0xFFFFFFFFL));
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setUnsignedInt(int woff, long value) {
        this.checkSet(woff, 4);
        long offset = this.address + (long)woff;
        try {
            this.storeInt(offset, (int)(value & 0xFFFFFFFFL));
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float readFloat() {
        this.checkRead(this.roff, 4);
        try {
            long offset = this.address + (long)this.roff;
            this.roff += 4;
            float f = this.loadFloat(offset);
            return f;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int roff) {
        this.checkGet(roff, 4);
        try {
            long offset = this.address + (long)roff;
            float f = this.loadFloat(offset);
            return f;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeFloat(float value) {
        this.checkWrite(this.woff, 4, true);
        long offset = this.address + (long)this.woff;
        this.woff += 4;
        try {
            this.storeFloat(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setFloat(int woff, float value) {
        this.checkSet(woff, 4);
        long offset = this.address + (long)woff;
        try {
            this.storeFloat(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLong() {
        this.checkRead(this.roff, 8);
        try {
            long offset = this.address + (long)this.roff;
            this.roff += 8;
            long l = this.loadLong(offset);
            return l;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int roff) {
        this.checkGet(roff, 8);
        try {
            long offset = this.address + (long)roff;
            long l = this.loadLong(offset);
            return l;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeLong(long value) {
        this.checkWrite(this.woff, 8, true);
        long offset = this.address + (long)this.woff;
        this.woff += 8;
        try {
            this.storeLong(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setLong(int woff, long value) {
        this.checkSet(woff, 8);
        long offset = this.address + (long)woff;
        try {
            this.storeLong(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double readDouble() {
        this.checkRead(this.roff, 8);
        try {
            long offset = this.address + (long)this.roff;
            this.roff += 8;
            double d = this.loadDouble(offset);
            return d;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int roff) {
        this.checkGet(roff, 8);
        try {
            long offset = this.address + (long)roff;
            double d = this.loadDouble(offset);
            return d;
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer writeDouble(double value) {
        this.checkWrite(this.woff, 8, true);
        long offset = this.address + (long)this.woff;
        this.woff += 8;
        try {
            this.storeDouble(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer setDouble(int woff, double value) {
        this.checkSet(woff, 8);
        long offset = this.address + (long)woff;
        try {
            this.storeDouble(offset, value);
        }
        finally {
            Reference.reachabilityFence(this.memory);
        }
        return this;
    }

    @Override
    protected Owned<UnsafeBuffer> prepareSend() {
        int roff = this.roff;
        int woff = this.woff;
        boolean readOnly = this.readOnly();
        int implicitCapacityLimit = this.implicitCapacityLimit;
        UnsafeMemory memory = this.memory;
        AllocatorControl control = this.control;
        long baseOffset = this.baseOffset;
        int rsize = this.rsize;
        return drop -> {
            UnsafeBuffer copy = new UnsafeBuffer(memory, baseOffset, rsize, control, drop);
            copy.roff = roff;
            copy.woff = woff;
            copy.implicitCapacityLimit = implicitCapacityLimit;
            if (readOnly) {
                copy.makeReadOnly();
            }
            return copy;
        };
    }

    @Override
    protected void makeInaccessible() {
        this.roff = 0;
        this.woff = 0;
        this.rsize = -1;
        this.wsize = -1;
        this.readOnly = false;
    }

    private void checkRead(int index, int size) {
        if (index < 0 | this.woff < index + size) {
            throw this.readAccessCheckException(index, size);
        }
    }

    private void checkGet(int index, int size) {
        if (index < 0 | this.rsize < index + size) {
            throw this.readAccessCheckException(index, size);
        }
    }

    private void checkWrite(int index, int size, boolean mayExpand) {
        if (index < this.roff | this.wsize < index + size) {
            this.handleWriteAccessBoundsFailure(index, size, mayExpand);
        }
    }

    private void checkSet(int index, int size) {
        if (index < 0 | this.wsize < index + size) {
            this.handleWriteAccessBoundsFailure(index, size, false);
        }
    }

    private RuntimeException readAccessCheckException(int index, int size) {
        if (this.rsize == -1) {
            throw this.bufferIsClosed();
        }
        return this.outOfBounds(index, size);
    }

    private void handleWriteAccessBoundsFailure(int index, int size, boolean mayExpand) {
        if (this.rsize == -1) {
            throw this.bufferIsClosed();
        }
        if (this.wsize != this.rsize) {
            throw InternalBufferUtils.bufferIsReadOnly(this);
        }
        int capacity = this.capacity();
        if (mayExpand && index >= 0 && index <= capacity && this.woff + size <= this.implicitCapacityLimit && this.isOwned()) {
            int minimumGrowth = Math.min(Math.max(PlatformDependent.roundToPowerOfTwo(capacity * 2), size), this.implicitCapacityLimit) - capacity;
            this.ensureWritable(size, minimumGrowth, false);
            this.checkSet(index, size);
            return;
        }
        throw this.outOfBounds(index, size);
    }

    private BufferClosedException bufferIsClosed() {
        return this.attachTrace(InternalBufferUtils.bufferIsClosed(this));
    }

    private IndexOutOfBoundsException outOfBounds(int index, int size) {
        return new IndexOutOfBoundsException("Access at index " + index + " of size " + size + " is out of bounds: [read 0 to " + this.woff + ", write 0 to " + this.rsize + "].");
    }

    private byte loadByte(long off) {
        return PlatformDependent.getByte(this.base, off);
    }

    private char loadChar(long offset) {
        if (ACCESS_UNALIGNED) {
            char value = PlatformDependent.getChar(this.base, offset);
            return FLIP_BYTES ? Character.reverseBytes(value) : value;
        }
        return this.loadCharUnaligned(offset);
    }

    private char loadCharUnaligned(long offset) {
        Object b = this.base;
        char value = (offset & 1L) == 0L ? PlatformDependent.getChar(b, offset) : (char)(PlatformDependent.getByte(b, offset) << 8 | PlatformDependent.getByte(b, offset + 1L));
        return FLIP_BYTES ? Character.reverseBytes(value) : value;
    }

    private short loadShort(long offset) {
        if (ACCESS_UNALIGNED) {
            short value = PlatformDependent.getShort(this.base, offset);
            return FLIP_BYTES ? Short.reverseBytes(value) : value;
        }
        return this.loadShortUnaligned(offset);
    }

    private short loadShortUnaligned(long offset) {
        Object b = this.base;
        short value = (offset & 1L) == 0L ? PlatformDependent.getShort(b, offset) : (short)(PlatformDependent.getByte(b, offset) << 8 | PlatformDependent.getByte(b, offset + 1L));
        return FLIP_BYTES ? Short.reverseBytes(value) : value;
    }

    private int loadInt(long offset) {
        if (ACCESS_UNALIGNED) {
            int value = PlatformDependent.getInt(this.base, offset);
            return FLIP_BYTES ? Integer.reverseBytes(value) : value;
        }
        return this.loadIntUnaligned(offset);
    }

    private int loadIntUnaligned(long offset) {
        Object b = this.base;
        int value = (offset & 3L) == 0L ? PlatformDependent.getInt(b, offset) : ((offset & 1L) == 0L ? PlatformDependent.getShort(b, offset) << 16 | PlatformDependent.getShort(b, offset + 2L) : PlatformDependent.getByte(b, offset) << 24 | PlatformDependent.getByte(b, offset + 1L) << 16 | PlatformDependent.getByte(b, offset + 2L) << 8 | PlatformDependent.getByte(b, offset + 3L));
        return FLIP_BYTES ? Integer.reverseBytes(value) : value;
    }

    private float loadFloat(long offset) {
        if (ACCESS_UNALIGNED) {
            if (FLIP_BYTES) {
                int value = PlatformDependent.getInt(this.base, offset);
                return Float.intBitsToFloat(Integer.reverseBytes(value));
            }
            return PlatformDependent.getFloat(this.base, offset);
        }
        return this.loadFloatUnaligned(offset);
    }

    private float loadFloatUnaligned(long offset) {
        return Float.intBitsToFloat(this.loadIntUnaligned(offset));
    }

    private long loadLong(long offset) {
        if (ACCESS_UNALIGNED) {
            long value = PlatformDependent.getLong(this.base, offset);
            return FLIP_BYTES ? Long.reverseBytes(value) : value;
        }
        return this.loadLongUnaligned(offset);
    }

    private long loadLongUnaligned(long offset) {
        Object b = this.base;
        long value = (offset & 7L) == 0L ? PlatformDependent.getLong(b, offset) : ((offset & 3L) == 0L ? (long)PlatformDependent.getInt(b, offset) << 32 | (long)PlatformDependent.getInt(b, offset + 4L) : ((offset & 1L) == 0L ? (long)PlatformDependent.getShort(b, offset) << 48 | (long)PlatformDependent.getShort(b, offset + 2L) << 32 | (long)PlatformDependent.getShort(b, offset + 4L) << 16 | (long)PlatformDependent.getShort(b, offset + 6L) : (long)PlatformDependent.getByte(b, offset) << 54 | (long)PlatformDependent.getByte(b, offset + 1L) << 48 | (long)PlatformDependent.getByte(b, offset + 2L) << 40 | (long)PlatformDependent.getByte(b, offset + 3L) << 32 | (long)PlatformDependent.getByte(b, offset + 4L) << 24 | (long)PlatformDependent.getByte(b, offset + 5L) << 16 | (long)PlatformDependent.getByte(b, offset + 6L) << 8 | (long)PlatformDependent.getByte(b, offset + 7L)));
        return FLIP_BYTES ? Long.reverseBytes(value) : value;
    }

    private double loadDouble(long offset) {
        if (ACCESS_UNALIGNED) {
            if (FLIP_BYTES) {
                long value = PlatformDependent.getLong(this.base, offset);
                return Double.longBitsToDouble(Long.reverseBytes(value));
            }
            return PlatformDependent.getDouble(this.base, offset);
        }
        return this.loadDoubleUnaligned(offset);
    }

    private double loadDoubleUnaligned(long offset) {
        return Double.longBitsToDouble(this.loadLongUnaligned(offset));
    }

    private void storeByte(long offset, byte value) {
        PlatformDependent.putByte(this.base, offset, value);
    }

    private void storeChar(long offset, char value) {
        if (FLIP_BYTES) {
            value = Character.reverseBytes(value);
        }
        if (ACCESS_UNALIGNED) {
            PlatformDependent.putChar(this.base, offset, value);
        } else {
            this.storeCharUnaligned(offset, value);
        }
    }

    private void storeCharUnaligned(long offset, char value) {
        Object b = this.base;
        if ((offset & 1L) == 0L) {
            PlatformDependent.putChar(b, offset, value);
        } else {
            PlatformDependent.putByte(b, offset, (byte)(value >> 8));
            PlatformDependent.putByte(b, offset + 1L, (byte)value);
        }
    }

    private void storeShort(long offset, short value) {
        if (FLIP_BYTES) {
            value = Short.reverseBytes(value);
        }
        if (ACCESS_UNALIGNED) {
            PlatformDependent.putShort(this.base, offset, value);
        } else {
            this.storeShortUnaligned(offset, value);
        }
    }

    private void storeShortUnaligned(long offset, short value) {
        Object b = this.base;
        if ((offset & 1L) == 0L) {
            PlatformDependent.putShort(b, offset, value);
        } else {
            PlatformDependent.putByte(b, offset, (byte)(value >> 8));
            PlatformDependent.putByte(b, offset + 1L, (byte)value);
        }
    }

    private void storeInt(long offset, int value) {
        if (FLIP_BYTES) {
            value = Integer.reverseBytes(value);
        }
        if (ACCESS_UNALIGNED) {
            PlatformDependent.putInt(this.base, offset, value);
        } else {
            this.storeIntUnaligned(offset, value);
        }
    }

    private void storeIntUnaligned(long offset, int value) {
        Object b = this.base;
        if ((offset & 3L) == 0L) {
            PlatformDependent.putInt(b, offset, value);
        } else if ((offset & 1L) == 0L) {
            PlatformDependent.putShort(b, offset, (short)(value >> 16));
            PlatformDependent.putShort(b, offset + 2L, (short)value);
        } else {
            PlatformDependent.putByte(b, offset, (byte)(value >> 24));
            PlatformDependent.putByte(b, offset + 1L, (byte)(value >> 16));
            PlatformDependent.putByte(b, offset + 2L, (byte)(value >> 8));
            PlatformDependent.putByte(b, offset + 3L, (byte)value);
        }
    }

    private void storeFloat(long offset, float value) {
        this.storeInt(offset, Float.floatToRawIntBits(value));
    }

    private void storeLong(long offset, long value) {
        if (FLIP_BYTES) {
            value = Long.reverseBytes(value);
        }
        if (ACCESS_UNALIGNED) {
            PlatformDependent.putLong(this.base, offset, value);
        } else {
            this.storeLongUnaligned(offset, value);
        }
    }

    private void storeLongUnaligned(long offset, long value) {
        Object b = this.base;
        if ((offset & 7L) == 0L) {
            PlatformDependent.putLong(b, offset, value);
        } else if ((offset & 3L) == 0L) {
            PlatformDependent.putInt(b, offset, (int)(value >> 32));
            PlatformDependent.putInt(b, offset + 4L, (int)value);
        } else if ((offset & 1L) == 0L) {
            PlatformDependent.putShort(b, offset, (short)(value >> 48));
            PlatformDependent.putShort(b, offset + 16L, (short)(value >> 32));
            PlatformDependent.putShort(b, offset + 32L, (short)(value >> 16));
            PlatformDependent.putShort(b, offset + 48L, (short)value);
        } else {
            PlatformDependent.putByte(b, offset, (byte)(value >> 56));
            PlatformDependent.putByte(b, offset + 1L, (byte)(value >> 48));
            PlatformDependent.putByte(b, offset + 2L, (byte)(value >> 40));
            PlatformDependent.putByte(b, offset + 3L, (byte)(value >> 32));
            PlatformDependent.putByte(b, offset + 4L, (byte)(value >> 24));
            PlatformDependent.putByte(b, offset + 5L, (byte)(value >> 16));
            PlatformDependent.putByte(b, offset + 6L, (byte)(value >> 8));
            PlatformDependent.putByte(b, offset + 7L, (byte)value);
        }
    }

    private void storeDouble(long offset, double value) {
        this.storeLong(offset, Double.doubleToRawLongBits(value));
    }

    Object recover() {
        return this.memory;
    }

    UnsafeBuffer newConstChild() {
        assert (this.readOnly());
        Drop<UnsafeBuffer> drop = this.unsafeGetDrop().fork();
        UnsafeBuffer child = new UnsafeBuffer(this, drop);
        drop.attach(child);
        return child;
    }

    private static final class ReverseUnsafeByteCursor
    implements ByteCursor {
        final UnsafeMemory memory;
        final Object baseObj;
        final long baseAddress;
        int index;
        final int end;
        byte byteValue;

        ReverseUnsafeByteCursor(UnsafeMemory memory, Object base, long address, int fromOffset, int length) {
            this.memory = memory;
            this.baseObj = base;
            this.baseAddress = address;
            this.index = fromOffset;
            this.end = this.index - length;
            this.byteValue = (byte)-1;
        }

        @Override
        public boolean readByte() {
            if (this.index > this.end) {
                try {
                    this.byteValue = PlatformDependent.getByte(this.baseObj, this.baseAddress + (long)this.index);
                }
                finally {
                    Reference.reachabilityFence(this.memory);
                }
                --this.index;
                return true;
            }
            return false;
        }

        @Override
        public byte getByte() {
            return this.byteValue;
        }

        @Override
        public int currentOffset() {
            return this.index;
        }

        @Override
        public int bytesLeft() {
            return this.index - this.end;
        }
    }

    private static final class ForwardUnsafeByteCursor
    implements ByteCursor {
        final UnsafeMemory memory;
        final Object baseObj;
        final long baseAddress;
        int index;
        final int end;
        byte byteValue;

        ForwardUnsafeByteCursor(UnsafeMemory memory, Object base, long address, int fromOffset, int length) {
            this.memory = memory;
            this.baseObj = base;
            this.baseAddress = address;
            this.index = fromOffset;
            this.end = this.index + length;
            this.byteValue = (byte)-1;
        }

        @Override
        public boolean readByte() {
            if (this.index < this.end) {
                try {
                    this.byteValue = PlatformDependent.getByte(this.baseObj, this.baseAddress + (long)this.index);
                }
                finally {
                    Reference.reachabilityFence(this.memory);
                }
                ++this.index;
                return true;
            }
            return false;
        }

        @Override
        public byte getByte() {
            return this.byteValue;
        }

        @Override
        public int currentOffset() {
            return this.index;
        }

        @Override
        public int bytesLeft() {
            return this.end - this.index;
        }
    }
}

