/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.pool;

import io.netty5.buffer.pool.PoolArena;
import io.netty5.buffer.pool.PoolChunk;
import io.netty5.buffer.pool.UntetheredMemory;
import io.netty5.util.internal.MathUtil;
import io.netty5.util.internal.ObjectPool;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

final class PoolThreadCache {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PoolThreadCache.class);
    private static final int INTEGER_SIZE_MINUS_ONE = 31;
    final AtomicInteger arenaReferenceCounter;
    private final PoolArena arena;
    private final MemoryRegionCache[] smallSubPageCaches;
    private final MemoryRegionCache[] normalCaches;
    private final int freeSweepAllocationThreshold;
    private int allocations;

    PoolThreadCache(PoolArena arena, int smallCacheSize, int normalCacheSize, int maxCachedBufferCapacity, int freeSweepAllocationThreshold) {
        ObjectUtil.checkPositiveOrZero(maxCachedBufferCapacity, "maxCachedBufferCapacity");
        this.freeSweepAllocationThreshold = freeSweepAllocationThreshold;
        if (arena != null) {
            MemoryRegionCache[] smallSubPageCaches = PoolThreadCache.createSubPageCaches(smallCacheSize, arena.numSmallSubpagePools);
            MemoryRegionCache[] normalCaches = PoolThreadCache.createNormalCaches(normalCacheSize, maxCachedBufferCapacity, arena);
            if ((smallSubPageCaches != null || normalCaches != null) && freeSweepAllocationThreshold < 1) {
                throw new IllegalArgumentException("freeSweepAllocationThreshold: " + freeSweepAllocationThreshold + " (expected: > 0)");
            }
            this.arena = arena;
            this.smallSubPageCaches = smallSubPageCaches;
            this.normalCaches = normalCaches;
            this.arenaReferenceCounter = arena.numThreadCaches;
            this.arenaReferenceCounter.getAndIncrement();
        } else {
            this.arena = null;
            this.smallSubPageCaches = null;
            this.normalCaches = null;
            this.arenaReferenceCounter = null;
        }
    }

    private static MemoryRegionCache[] createSubPageCaches(int cacheSize, int numCaches) {
        if (cacheSize > 0 && numCaches > 0) {
            MemoryRegionCache[] cache = new MemoryRegionCache[numCaches];
            for (int i = 0; i < cache.length; ++i) {
                cache[i] = new SubPageMemoryRegionCache(cacheSize);
            }
            return cache;
        }
        return null;
    }

    private static MemoryRegionCache[] createNormalCaches(int cacheSize, int maxCachedBufferCapacity, PoolArena area) {
        if (cacheSize > 0 && maxCachedBufferCapacity > 0) {
            int max = Math.min(area.chunkSize, maxCachedBufferCapacity);
            ArrayList<NormalMemoryRegionCache> cache = new ArrayList<NormalMemoryRegionCache>();
            for (int idx = area.numSmallSubpagePools; idx < area.nSizes && area.sizeIdx2size(idx) <= max; ++idx) {
                cache.add(new NormalMemoryRegionCache(cacheSize));
            }
            return (MemoryRegionCache[])cache.toArray(MemoryRegionCache[]::new);
        }
        return null;
    }

    PoolArena getArena() {
        return this.arena;
    }

    static int log2(int val) {
        return 31 - Integer.numberOfLeadingZeros(val);
    }

    UntetheredMemory allocateSmall(int size, int sizeIdx) {
        return this.allocate(this.cacheForSmall(sizeIdx), size);
    }

    UntetheredMemory allocateNormal(PoolArena area, int size, int sizeIdx) {
        return this.allocate(this.cacheForNormal(area, sizeIdx), size);
    }

    private UntetheredMemory allocate(MemoryRegionCache cache, int size) {
        if (cache == null) {
            return null;
        }
        UntetheredMemory allocated = cache.allocate(size, this);
        if (++this.allocations >= this.freeSweepAllocationThreshold) {
            this.allocations = 0;
            this.trim();
        }
        return allocated;
    }

    boolean add(PoolArena area, PoolChunk chunk, long handle, int normCapacity, PoolArena.SizeClass sizeClass) {
        int sizeIdx = area.size2SizeIdx(normCapacity);
        MemoryRegionCache cache = this.cache(area, sizeIdx, sizeClass);
        if (cache == null) {
            return false;
        }
        return cache.add(chunk, handle, normCapacity);
    }

    private MemoryRegionCache cache(PoolArena area, int sizeIdx, PoolArena.SizeClass sizeClass) {
        if (sizeClass == PoolArena.SizeClass.Normal) {
            return this.cacheForNormal(area, sizeIdx);
        }
        if (sizeClass == PoolArena.SizeClass.Small) {
            return this.cacheForSmall(sizeIdx);
        }
        throw new AssertionError((Object)("Unexpected size class: " + sizeClass));
    }

    void free() {
        int numFreed;
        if (this.arena != null && (numFreed = PoolThreadCache.free(this.smallSubPageCaches) + PoolThreadCache.free(this.normalCaches)) > 0 && logger.isDebugEnabled()) {
            logger.debug("Freed {} thread-local buffer(s) from thread: {}", (Object)numFreed, (Object)Thread.currentThread().getName());
        }
        if (this.arenaReferenceCounter != null) {
            this.arenaReferenceCounter.getAndDecrement();
        }
    }

    private static int free(MemoryRegionCache[] caches) {
        if (caches == null) {
            return 0;
        }
        int numFreed = 0;
        for (MemoryRegionCache c : caches) {
            numFreed += PoolThreadCache.free(c);
        }
        return numFreed;
    }

    private static int free(MemoryRegionCache cache) {
        if (cache == null) {
            return 0;
        }
        return cache.free();
    }

    void trim() {
        if (this.arena != null) {
            PoolThreadCache.trim(this.smallSubPageCaches);
            PoolThreadCache.trim(this.normalCaches);
        }
    }

    private static void trim(MemoryRegionCache[] caches) {
        if (caches == null) {
            return;
        }
        for (MemoryRegionCache c : caches) {
            PoolThreadCache.trim(c);
        }
    }

    private static void trim(MemoryRegionCache cache) {
        if (cache == null) {
            return;
        }
        cache.trim();
    }

    private MemoryRegionCache cacheForSmall(int sizeIdx) {
        if (this.arena != null) {
            return PoolThreadCache.cache(this.smallSubPageCaches, sizeIdx);
        }
        return null;
    }

    private MemoryRegionCache cacheForNormal(PoolArena area, int sizeIdx) {
        if (area != null) {
            int idx = sizeIdx - area.numSmallSubpagePools;
            return PoolThreadCache.cache(this.normalCaches, idx);
        }
        return null;
    }

    private static MemoryRegionCache cache(MemoryRegionCache[] cache, int sizeIdx) {
        if (cache == null || sizeIdx > cache.length - 1) {
            return null;
        }
        return cache[sizeIdx];
    }

    private static abstract class MemoryRegionCache {
        private final int size;
        private final Queue<Entry> queue;
        private final PoolArena.SizeClass sizeClass;
        private int allocations;
        private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool(Entry::new);

        MemoryRegionCache(int size, PoolArena.SizeClass sizeClass) {
            this.size = MathUtil.safeFindNextPositivePowerOfTwo(size);
            this.queue = PlatformDependent.newFixedMpscQueue(this.size);
            this.sizeClass = sizeClass;
        }

        protected abstract UntetheredMemory allocBuf(PoolChunk var1, long var2, int var4, PoolThreadCache var5);

        public final boolean add(PoolChunk chunk, long handle, int normCapacity) {
            Entry entry = MemoryRegionCache.newEntry(chunk, handle, normCapacity);
            boolean queued = this.queue.offer(entry);
            if (!queued) {
                entry.recycle();
            }
            return queued;
        }

        public final UntetheredMemory allocate(int size, PoolThreadCache threadCache) {
            Entry entry = this.queue.poll();
            if (entry == null) {
                return null;
            }
            UntetheredMemory buffer = this.allocBuf(entry.chunk, entry.handle, size, threadCache);
            entry.recycle();
            ++this.allocations;
            return buffer;
        }

        public final int free() {
            return this.free(Integer.MAX_VALUE);
        }

        private int free(int max) {
            int numFreed;
            for (numFreed = 0; numFreed < max; ++numFreed) {
                Entry entry = this.queue.poll();
                if (entry == null) {
                    return numFreed;
                }
                this.freeEntry(entry);
            }
            return numFreed;
        }

        public final void trim() {
            int free = this.size - this.allocations;
            this.allocations = 0;
            if (free > 0) {
                this.free(free);
            }
        }

        private void freeEntry(Entry entry) {
            PoolChunk chunk = entry.chunk;
            long handle = entry.handle;
            entry.recycle();
            chunk.arena.freeChunk(chunk, handle, entry.normCapacity, this.sizeClass);
        }

        private static Entry newEntry(PoolChunk chunk, long handle, int normCapacity) {
            Entry entry = RECYCLER.get();
            entry.chunk = chunk;
            entry.handle = handle;
            entry.normCapacity = normCapacity;
            return entry;
        }

        static final class Entry {
            final ObjectPool.Handle<Entry> recyclerHandle;
            PoolChunk chunk;
            long handle = -1L;
            int normCapacity;

            Entry(ObjectPool.Handle<Entry> recyclerHandle) {
                this.recyclerHandle = recyclerHandle;
            }

            void recycle() {
                this.chunk = null;
                this.handle = -1L;
                this.recyclerHandle.recycle(this);
            }
        }
    }

    private static final class NormalMemoryRegionCache
    extends MemoryRegionCache {
        NormalMemoryRegionCache(int size) {
            super(size, PoolArena.SizeClass.Normal);
        }

        @Override
        protected UntetheredMemory allocBuf(PoolChunk chunk, long handle, int size, PoolThreadCache threadCache) {
            return chunk.allocateBuffer(handle, size, threadCache);
        }
    }

    private static final class SubPageMemoryRegionCache
    extends MemoryRegionCache {
        SubPageMemoryRegionCache(int size) {
            super(size, PoolArena.SizeClass.Small);
        }

        @Override
        protected UntetheredMemory allocBuf(PoolChunk chunk, long handle, int size, PoolThreadCache threadCache) {
            return chunk.allocateBufferWithSubpage(handle, size, threadCache);
        }
    }
}

