/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.internal;

import io.netty5.buffer.Drop;
import io.netty5.buffer.Owned;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.internal.ResourceSupport;
import io.netty5.util.Resource;
import io.netty5.util.Send;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class SendFromOwned<I extends Resource<I>, T extends ResourceSupport<I, T>>
implements Send<I> {
    private static final VarHandle RECEIVED = InternalBufferUtils.findVarHandle(MethodHandles.lookup(), SendFromOwned.class, "received", Boolean.TYPE);
    private final Owned<T> outgoing;
    private final Drop<T> drop;
    private final Class<?> concreteType;
    private volatile boolean received;

    public SendFromOwned(Owned<T> outgoing, Drop<T> drop, Class<?> concreteType) {
        this.outgoing = outgoing;
        this.drop = drop;
        this.concreteType = concreteType;
    }

    @Override
    public I receive() {
        this.gateReception();
        ResourceSupport copy = (ResourceSupport)this.outgoing.transferOwnership(this.drop);
        this.drop.attach(copy);
        return (I)copy;
    }

    private void gateReception() {
        if (RECEIVED.getAndSet(this, true)) {
            throw new IllegalStateException("This object has already been received.");
        }
    }

    @Override
    public boolean referentIsInstanceOf(Class<?> cls) {
        return cls.isAssignableFrom(this.concreteType);
    }

    @Override
    public void close() {
        if (!RECEIVED.getAndSet(this, true)) {
            ResourceSupport copy = (ResourceSupport)this.outgoing.transferOwnership(this.drop);
            this.drop.attach(copy);
            copy.close();
        }
    }
}

