/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.internal;

import io.netty5.buffer.LeakInfo;
import io.netty5.buffer.LoggingLeakCallback;
import io.netty5.buffer.internal.LifecycleTracer;
import io.netty5.util.SafeCloseable;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.UnstableApi;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;

@UnstableApi
public final class LeakDetection {
    static volatile int leakDetectionEnabled;
    private static final Map<Consumer<LeakInfo>, Integer> CALLBACKS;
    private static final Integer INTEGER_ONE;
    private static final boolean ENABLED_BY_PROPERTY;
    private static final VarHandle LEAK_DETECTION_ENABLED_UPDATER;

    private static VarHandle getLeakDetectionEnabledUpdater() throws NoSuchFieldException, IllegalAccessException {
        String fieldName = "leakDetectionEnabled";
        if (SystemPropertyUtil.contains("io.netty5.buffer.leakDetection.nativeimageworkaround")) {
            fieldName = "This should never happen, please unset the system property: io.netty5.buffer.leakDetection.nativeimageworkaround";
        }
        return MethodHandles.lookup().findStaticVarHandle(LeakDetection.class, fieldName, Integer.TYPE);
    }

    private LeakDetection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SafeCloseable onLeakDetected(Consumer<LeakInfo> callback) {
        Objects.requireNonNull(callback, "callback");
        Map<Consumer<LeakInfo>, Integer> map = CALLBACKS;
        synchronized (map) {
            Integer newValue = CALLBACKS.compute(callback, (k, v) -> v == null ? INTEGER_ONE : v + 1);
            if (newValue.equals(INTEGER_ONE)) {
                LEAK_DETECTION_ENABLED_UPDATER.getAndAddAcquire(1);
            }
        }
        return new CallbackRemover(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportLeak(LifecycleTracer tracer, String leakedObjectDescription) {
        Objects.requireNonNull(tracer, "tracer");
        Objects.requireNonNull(leakedObjectDescription, "leakedObjectDescription");
        Map<Consumer<LeakInfo>, Integer> map = CALLBACKS;
        synchronized (map) {
            if (!CALLBACKS.isEmpty()) {
                InternalLeakInfo info = new InternalLeakInfo(tracer, leakedObjectDescription);
                for (Consumer<LeakInfo> callback : CALLBACKS.keySet()) {
                    callback.accept(info);
                }
            } else if (ENABLED_BY_PROPERTY) {
                InternalLeakInfo info = new InternalLeakInfo(tracer, leakedObjectDescription);
                LoggingLeakCallback.getInstance().accept(info);
            }
        }
    }

    static {
        CALLBACKS = new IdentityHashMap<Consumer<LeakInfo>, Integer>();
        INTEGER_ONE = 1;
        ENABLED_BY_PROPERTY = SystemPropertyUtil.getBoolean("io.netty5.buffer.leakDetectionEnabled", false);
        try {
            LEAK_DETECTION_ENABLED_UPDATER = LeakDetection.getLeakDetectionEnabledUpdater();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        leakDetectionEnabled = ENABLED_BY_PROPERTY ? 1 : 0;
    }

    private static final class InternalLeakInfo
    implements LeakInfo {
        private final LifecycleTracer tracer;
        private final String leakedObjectDescription;
        private Collection<LeakInfo.TracePoint> cachedTrace;

        InternalLeakInfo(LifecycleTracer tracer, String leakedObjectDescription) {
            this.tracer = tracer;
            this.leakedObjectDescription = leakedObjectDescription;
        }

        @Override
        public Iterator<LeakInfo.TracePoint> iterator() {
            return this.getTracePoints().iterator();
        }

        @Override
        public Stream<LeakInfo.TracePoint> stream() {
            return this.getTracePoints().stream();
        }

        @Override
        public String objectDescription() {
            return this.leakedObjectDescription;
        }

        private Collection<LeakInfo.TracePoint> getTracePoints() {
            if (this.cachedTrace == null) {
                this.cachedTrace = this.tracer.collectTraces();
            }
            return this.cachedTrace;
        }
    }

    private static final class CallbackRemover
    extends AtomicBoolean
    implements SafeCloseable {
        private static final long serialVersionUID = -7883321389305330790L;
        private final Consumer<LeakInfo> callback;

        CallbackRemover(Consumer<LeakInfo> callback) {
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.getAndSet(true)) {
                Map<Consumer<LeakInfo>, Integer> map = CALLBACKS;
                synchronized (map) {
                    CALLBACKS.compute(this.callback, (k, v) -> {
                        assert (v != null);
                        if (v.equals(INTEGER_ONE)) {
                            LEAK_DETECTION_ENABLED_UPDATER.getAndAddRelease(-1);
                            return null;
                        }
                        return v - 1;
                    });
                }
            }
        }
    }
}

