/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.internal;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAccessor;
import io.netty5.buffer.BufferClosedException;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.BufferReadOnlyException;
import io.netty5.buffer.Drop;
import io.netty5.buffer.MemoryManager;
import io.netty5.buffer.internal.CleanerDrop;
import io.netty5.buffer.internal.JniBufferAccess;
import io.netty5.buffer.internal.NotReadOnlyReadableComponent;
import io.netty5.buffer.internal.ResourceSupport;
import io.netty5.util.AsciiString;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

public interface InternalBufferUtils {
    public static final LongAdder MEM_USAGE_NATIVE = new LongAdder();
    public static final Cleaner CLEANER = Cleaner.create();
    public static final Drop<Buffer> NO_OP_DROP = new Drop<Buffer>(){

        @Override
        public void drop(Buffer obj) {
        }

        @Override
        public Drop<Buffer> fork() {
            return this;
        }

        @Override
        public void attach(Buffer obj) {
        }

        public String toString() {
            return "NO_OP_DROP";
        }
    };
    public static final MethodHandle BB_SLICE_OFFSETS = InternalBufferUtils.getByteBufferSliceOffsetsMethodHandle();
    public static final MethodHandle BB_PUT_OFFSETS = InternalBufferUtils.getByteBufferPutOffsetsMethodHandle();
    public static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    public static final UncheckedLoadByte UNCHECKED_LOAD_BYTE_BUFFER = BufferAccessor::getByte;

    public static MethodHandle getByteBufferSliceOffsetsMethodHandle() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType type = MethodType.methodType(ByteBuffer.class, Integer.TYPE, Integer.TYPE);
            return lookup.findVirtual(ByteBuffer.class, "slice", type);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static MethodHandle getByteBufferPutOffsetsMethodHandle() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType type = MethodType.methodType(ByteBuffer.class, Integer.TYPE, ByteBuffer.class, Integer.TYPE, Integer.TYPE);
            return lookup.findVirtual(ByteBuffer.class, "put", type);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static Function<Drop<Buffer>, Drop<Buffer>> standardDrop(MemoryManager manager) {
        return drop -> CleanerDrop.wrap(drop, manager);
    }

    public static VarHandle findVarHandle(MethodHandles.Lookup lookup, Class<?> recv, String name, Class<?> type) {
        try {
            return lookup.findVarHandle(recv, name, type);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static <T, R> Drop<R> convert(Drop<T> drop) {
        return drop;
    }

    public static void assertValidBufferSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Buffer size must not be negative, but was " + size + ".");
        }
        if (size > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Buffer size cannot be greater than 2147483639, but was " + size + ".");
        }
    }

    public static void checkImplicitCapacity(int implicitCapacity, int currentCapacity) {
        if (implicitCapacity < currentCapacity) {
            throw new IndexOutOfBoundsException("Implicit capacity limit (" + implicitCapacity + ") cannot be less than capacity (" + currentCapacity + ")");
        }
        if (implicitCapacity > 0x7FFFFFF7) {
            throw new IndexOutOfBoundsException("Implicit capacity limit (" + implicitCapacity + ") cannot be greater than max buffer size (2147483639)");
        }
    }

    public static void checkLength(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("The length cannot be negative: " + length + ".");
        }
    }

    public static void copyToViaReverseLoop(Buffer src, int srcPos, Buffer dest, int destPos, int length) {
        InternalBufferUtils.checkLength(length);
        if (length == 0) {
            return;
        }
        int i = length;
        while (i >= 8) {
            dest.setLong(destPos + (i -= 8), src.getLong(srcPos + i));
        }
        while (i > 0) {
            dest.setByte(destPos + --i, src.getByte(srcPos + i));
        }
    }

    public static ByteBuffer tryGetWritableBufferFromReadableComponent(BufferComponent component) {
        if (component instanceof NotReadOnlyReadableComponent) {
            return ((NotReadOnlyReadableComponent)((Object)component)).mutableReadableBuffer();
        }
        return null;
    }

    public static ByteBuffer bbslice(ByteBuffer buffer, int fromOffset, int length) {
        if (BB_SLICE_OFFSETS != null) {
            return InternalBufferUtils.bbsliceJdk13(buffer, fromOffset, length);
        }
        return InternalBufferUtils.bbsliceFallback(buffer, fromOffset, length);
    }

    private static ByteBuffer bbsliceJdk13(ByteBuffer buffer, int fromOffset, int length) {
        try {
            return BB_SLICE_OFFSETS.invokeExact(buffer, fromOffset, length);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable throwable) {
            throw new LinkageError("Unexpected exception from ByteBuffer.slice(int,int).", throwable);
        }
    }

    private static ByteBuffer bbsliceFallback(ByteBuffer buffer, int fromOffset, int length) {
        if (fromOffset < 0) {
            throw new IndexOutOfBoundsException("The fromOffset must be positive: " + fromOffset + ".");
        }
        int newLimit = fromOffset + length;
        if (newLimit > buffer.capacity()) {
            throw new IndexOutOfBoundsException("The limit of " + newLimit + " would be greater than capacity: " + buffer.capacity() + ".");
        }
        return buffer.duplicate().clear().position(fromOffset).limit(newLimit).slice();
    }

    public static void bbput(ByteBuffer dest, int destPos, ByteBuffer src, int srcPos, int length) {
        if (BB_PUT_OFFSETS != null) {
            InternalBufferUtils.bbputJdk16(dest, destPos, src, srcPos, length);
        } else {
            InternalBufferUtils.bbputFallback(dest, destPos, src, srcPos, length);
        }
    }

    private static void bbputJdk16(ByteBuffer dest, int destPos, ByteBuffer src, int srcPos, int length) {
        try {
            ByteBuffer byteBuffer = BB_PUT_OFFSETS.invokeExact(dest, destPos, src, srcPos, length);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable throwable) {
            throw new LinkageError("Unexpected exception from ByteBuffer.put(int,ByteBuffer,int,int).", throwable);
        }
    }

    private static void bbputFallback(ByteBuffer dest, int destPos, ByteBuffer src, int srcPos, int length) {
        dest.position(destPos).put(InternalBufferUtils.bbslice(src, srcPos, length));
    }

    public static void setMemory(ByteBuffer buffer, int length, byte value) {
        if (!buffer.hasArray()) {
            long address;
            if (PlatformDependent.hasUnsafe() && (address = InternalBufferUtils.nativeAddressOfDirectByteBuffer(buffer)) != 0L) {
                PlatformDependent.setMemory(address, length, value);
            } else {
                int intFillValue = (value & 0xFF) * 0x1010101;
                int intCount = length >>> 2;
                for (int i = 0; i < intCount; ++i) {
                    buffer.putInt(i << 2, intFillValue);
                }
                int byteCount = length & 3;
                int bytesOffset = intCount << 2;
                for (int i = 0; i < byteCount; ++i) {
                    buffer.put(bytesOffset + i, value);
                }
            }
        } else {
            int start = buffer.arrayOffset();
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.setMemory(buffer.array(), start, (long)length, value);
            } else {
                int end = start + length;
                Arrays.fill(buffer.array(), start, end, value);
            }
        }
    }

    public static BufferClosedException bufferIsClosed(Buffer buffer) {
        return new BufferClosedException("This buffer is closed: " + buffer);
    }

    public static BufferReadOnlyException bufferIsReadOnly(Buffer buffer) {
        return new BufferReadOnlyException("This buffer is read-only: " + buffer);
    }

    public static IllegalStateException allocatorClosedException() {
        return new IllegalStateException("This allocator has been closed.");
    }

    public static <T> T acquire(ResourceSupport<?, ?> obj) {
        return ResourceSupport.acquire(obj);
    }

    public static boolean isOwned(ResourceSupport<?, ?> obj) {
        return ResourceSupport.isOwned(obj);
    }

    public static int countBorrows(ResourceSupport<?, ?> obj) {
        return ResourceSupport.countBorrows(obj);
    }

    public static <E extends Throwable> E attachTrace(ResourceSupport<?, ?> obj, E throwable) {
        return ResourceSupport.getTracer(obj).attachTrace(throwable);
    }

    public static void unsafeSetDrop(ResourceSupport<?, ?> obj, Drop<?> replacement) {
        obj.unsafeSetDrop(replacement);
    }

    public static CharSequence readCharSequence(Buffer source, int length, Charset charset) {
        CharSequence charSequence = InternalBufferUtils.copyToCharSequence(source, source.readerOffset(), length, charset);
        source.skipReadableBytes(length);
        return charSequence;
    }

    public static String toString(Buffer source, Charset charset) {
        return InternalBufferUtils.copyToCharSequence(source, source.readerOffset(), source.readableBytes(), charset).toString();
    }

    public static CharSequence copyToCharSequence(Buffer source, int srcIdx, int length, Charset charset) {
        byte[] data = new byte[length];
        source.copyInto(srcIdx, data, 0, length);
        if (StandardCharsets.US_ASCII.equals(charset)) {
            return new AsciiString(data).toString();
        }
        return new String(data, 0, length, charset);
    }

    public static void writeCharSequence(CharSequence source, Buffer destination, Charset charset) {
        if (StandardCharsets.US_ASCII.equals(charset) && source instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)source;
            destination.writeBytes(asciiString.array(), asciiString.arrayOffset(), source.length());
            return;
        }
        byte[] bytes = source.toString().getBytes(charset);
        destination.writeBytes(bytes);
    }

    public static boolean equals(Buffer bufferA, Buffer bufferB) {
        if (bufferA == null && bufferB != null || bufferB == null && bufferA != null) {
            return false;
        }
        if (bufferA == bufferB) {
            return true;
        }
        int aLen = bufferA.readableBytes();
        if (aLen != bufferB.readableBytes()) {
            return false;
        }
        return InternalBufferUtils.equals(bufferA, bufferA.readerOffset(), bufferB, bufferB.readerOffset(), aLen);
    }

    public static boolean equals(Buffer a, int aStartIndex, Buffer b, int bStartIndex, int length) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        ObjectUtil.checkPositiveOrZero(aStartIndex, "aStartIndex");
        ObjectUtil.checkPositiveOrZero(bStartIndex, "bStartIndex");
        ObjectUtil.checkPositiveOrZero(length, "length");
        if (a.writerOffset() - length < aStartIndex || b.writerOffset() - length < bStartIndex) {
            return false;
        }
        return InternalBufferUtils.equalsInner(a, aStartIndex, b, bStartIndex, length);
    }

    private static boolean equalsInner(Buffer a, int aStartIndex, Buffer b, int bStartIndex, int length) {
        int i;
        int longCount = length >>> 3;
        int byteCount = length & 7;
        for (i = longCount; i > 0; --i) {
            if (a.getLong(aStartIndex) != b.getLong(bStartIndex)) {
                return false;
            }
            aStartIndex += 8;
            bStartIndex += 8;
        }
        for (i = byteCount; i > 0; --i) {
            if (a.getByte(aStartIndex) != b.getByte(bStartIndex)) {
                return false;
            }
            ++aStartIndex;
            ++bStartIndex;
        }
        return true;
    }

    public static int hashCode(Buffer buffer) {
        int i;
        int aLen = buffer.readableBytes();
        int intCount = aLen >>> 2;
        int byteCount = aLen & 3;
        int hashCode = 0;
        int arrayIndex = buffer.readerOffset();
        for (i = intCount; i > 0; --i) {
            hashCode = 31 * hashCode + buffer.getInt(arrayIndex);
            arrayIndex += 4;
        }
        for (i = byteCount; i > 0; --i) {
            hashCode = 31 * hashCode + buffer.getByte(arrayIndex++);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    public static long nativeAddressWithOffset(long address, int offset) {
        if (address == 0L) {
            return 0L;
        }
        return address + (long)offset;
    }

    public static long nativeAddressOfDirectByteBuffer(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            return 0L;
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.directBufferAddress(byteBuffer);
        }
        if (JniBufferAccess.IS_AVAILABLE) {
            try {
                return JniBufferAccess.MEMORY_ADDRESS.invokeExact(byteBuffer);
            }
            catch (Throwable e) {
                throw new LinkageError("JNI bypass native memory address accessor was supposed to be available, but threw an exception", e);
            }
        }
        return 0L;
    }

    public static int bytesBefore(Buffer haystack, UncheckedLoadByte hl, Buffer needle, UncheckedLoadByte nl) {
        int length;
        if (!haystack.isAccessible()) {
            throw InternalBufferUtils.bufferIsClosed(haystack);
        }
        if (!needle.isAccessible()) {
            throw InternalBufferUtils.bufferIsClosed(needle);
        }
        if (needle.readableBytes() > haystack.readableBytes()) {
            return -1;
        }
        if (hl == null) {
            hl = UNCHECKED_LOAD_BYTE_BUFFER;
        }
        if (nl == null) {
            nl = UNCHECKED_LOAD_BYTE_BUFFER;
        }
        int haystackLen = haystack.readableBytes();
        int needleLen = needle.readableBytes();
        if (needleLen == 0) {
            return 0;
        }
        if (needleLen == 1) {
            return haystack.bytesBefore(needle.getByte(needle.readerOffset()));
        }
        int needleStart = needle.readerOffset();
        int haystackStart = haystack.readerOffset();
        long suffixes = InternalBufferUtils.maxFixes(needle, nl, needleLen, needleStart, true);
        long prefixes = InternalBufferUtils.maxFixes(needle, nl, needleLen, needleStart, false);
        int maxSuffix = Math.max((int)(suffixes >> 32), (int)(prefixes >> 32));
        int period = Math.max((int)suffixes, (int)prefixes);
        if (InternalBufferUtils.equalsInner(needle, needleStart, needle, needleStart + period, length = Math.min(needleLen - period, maxSuffix + 1))) {
            return InternalBufferUtils.bytesBeforeInnerPeriodic(haystack, hl, needle, nl, haystackLen, needleLen, needleStart, haystackStart, maxSuffix, period);
        }
        return InternalBufferUtils.bytesBeforeInnerNonPeriodic(haystack, hl, needle, nl, haystackLen, needleLen, needleStart, haystackStart, maxSuffix);
    }

    private static int bytesBeforeInnerPeriodic(Buffer haystack, UncheckedLoadByte hl, Buffer needle, UncheckedLoadByte nl, int haystackLen, int needleLen, int needleStart, int haystackStart, int maxSuffix, int period) {
        int j = 0;
        int memory = -1;
        while (j <= haystackLen - needleLen) {
            int i;
            for (i = Math.max(maxSuffix, memory) + 1; i < needleLen && nl.load(needle, i + needleStart) == hl.load(haystack, i + j + haystackStart); ++i) {
            }
            if (i > haystackLen) {
                return -1;
            }
            if (i >= needleLen) {
                for (i = maxSuffix; i > memory && nl.load(needle, i + needleStart) == hl.load(haystack, i + j + haystackStart); --i) {
                }
                if (i <= memory) {
                    return j;
                }
                j += period;
                memory = needleLen - period - 1;
                continue;
            }
            j += i - maxSuffix;
            memory = -1;
        }
        return -1;
    }

    private static int bytesBeforeInnerNonPeriodic(Buffer haystack, UncheckedLoadByte hl, Buffer needle, UncheckedLoadByte nl, int haystackLen, int needleLen, int needleStart, int haystackStart, int maxSuffix) {
        int j = 0;
        int period = Math.max(maxSuffix + 1, needleLen - maxSuffix - 1) + 1;
        while (j <= haystackLen - needleLen) {
            int i;
            for (i = maxSuffix + 1; i < needleLen && nl.load(needle, i + needleStart) == hl.load(haystack, i + j + haystackStart); ++i) {
            }
            if (i > haystackLen) {
                return -1;
            }
            if (i >= needleLen) {
                for (i = maxSuffix; i >= 0 && nl.load(needle, i + needleStart) == hl.load(haystack, i + j + haystackStart); --i) {
                }
                if (i < 0) {
                    return j;
                }
                j += period;
                continue;
            }
            j += i - maxSuffix;
        }
        return -1;
    }

    private static long maxFixes(Buffer needle, UncheckedLoadByte nl, int needleLen, int start, boolean isSuffix) {
        int period = 1;
        int maxSuffix = -1;
        int lastRest = start;
        int k = 1;
        while (lastRest + k < needleLen) {
            boolean suffix;
            byte a = nl.load(needle, lastRest + k);
            byte b = nl.load(needle, maxSuffix + k);
            boolean bl = isSuffix ? a < b : (suffix = a > b);
            if (suffix) {
                k = 1;
                period = (lastRest += k) - maxSuffix;
                continue;
            }
            if (a == b) {
                if (k != period) {
                    ++k;
                    continue;
                }
                lastRest += period;
                k = 1;
                continue;
            }
            maxSuffix = lastRest;
            lastRest = maxSuffix + 1;
            period = 1;
            k = 1;
        }
        return ((long)maxSuffix << 32) + (long)period;
    }

    public static interface UncheckedLoadByte {
        public byte load(Buffer var1, int var2);
    }
}

