/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.util.Resource;
import io.netty5.util.Send;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

public abstract class BufferHolder<T extends Resource<T>>
implements Resource<T> {
    private static final VarHandle BUF = InternalBufferUtils.findVarHandle(MethodHandles.lookup(), BufferHolder.class, "buf", Buffer.class);
    private Buffer buf;

    protected BufferHolder(Buffer buf) {
        this.buf = Objects.requireNonNull(buf, "The buffer cannot be null.");
    }

    protected BufferHolder(Send<Buffer> send) {
        this.buf = Objects.requireNonNull(send, "The Send-object cannot be null.").receive();
    }

    @Override
    public void close() {
        this.buf.close();
    }

    @Override
    public Send<T> send() {
        return this.buf.send().map(this.getClass(), this::receive);
    }

    protected abstract T receive(Buffer var1);

    protected final void replaceBuffer(Send<Buffer> send) {
        Buffer received = send.receive();
        this.buf.close();
        this.buf = received;
    }

    protected final void replaceBufferVolatile(Send<Buffer> send) {
        Buffer received = send.receive();
        Buffer prev = BUF.getAndSet(this, received);
        prev.close();
    }

    protected final Buffer getBuffer() {
        return this.buf;
    }

    protected final Buffer getBufferVolatile() {
        return BUF.getVolatile(this);
    }

    @Override
    public boolean isAccessible() {
        return this.buf.isAccessible();
    }

    @Override
    public T touch(Object hint) {
        this.buf.touch(hint);
        return (T)this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            return this.buf.equals(((BufferHolder)other).buf);
        }
        return false;
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        return result *= 31 + this.buf.hashCode();
    }
}

