/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.BufferAccessor;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ByteCursor;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.util.Resource;
import io.netty5.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public interface Buffer
extends Resource<Buffer>,
BufferAccessor {
    public int capacity();

    public int readerOffset();

    default public Buffer skipReadableBytes(int delta) {
        ObjectUtil.checkPositiveOrZero(delta, "delta");
        this.readerOffset(this.readerOffset() + delta);
        return this;
    }

    public Buffer readerOffset(int var1);

    public int writerOffset();

    default public Buffer skipWritableBytes(int delta) {
        ObjectUtil.checkPositiveOrZero(delta, "delta");
        this.writerOffset(this.writerOffset() + delta);
        return this;
    }

    public Buffer writerOffset(int var1);

    default public int readableBytes() {
        return this.writerOffset() - this.readerOffset();
    }

    default public int writableBytes() {
        return this.readOnly() ? 0 : this.capacity() - this.writerOffset();
    }

    public Buffer fill(byte var1);

    public Buffer makeReadOnly();

    public boolean readOnly();

    public boolean isDirect();

    public Buffer implicitCapacityLimit(int var1);

    public int implicitCapacityLimit();

    public void copyInto(int var1, byte[] var2, int var3, int var4);

    public void copyInto(int var1, ByteBuffer var2, int var3, int var4);

    public void copyInto(int var1, Buffer var2, int var3, int var4);

    public int transferTo(WritableByteChannel var1, int var2) throws IOException;

    public int transferFrom(FileChannel var1, long var2, int var4) throws IOException;

    public int transferFrom(ReadableByteChannel var1, int var2) throws IOException;

    default public Buffer writeCharSequence(CharSequence source, Charset charset) {
        InternalBufferUtils.writeCharSequence(source, this, charset);
        return this;
    }

    default public CharSequence readCharSequence(int length, Charset charset) {
        return InternalBufferUtils.readCharSequence(this, length, charset);
    }

    default public Buffer writeBytes(Buffer source) {
        int size = source.readableBytes();
        if (this.writableBytes() < size && this.writerOffset() + size <= this.implicitCapacityLimit()) {
            this.ensureWritable(size, 1, false);
        }
        int woff = this.writerOffset();
        source.copyInto(source.readerOffset(), this, woff, size);
        source.skipReadableBytes(size);
        this.skipWritableBytes(size);
        return this;
    }

    default public Buffer writeBytes(byte[] source) {
        return this.writeBytes(source, 0, source.length);
    }

    default public Buffer writeBytes(byte[] source, int srcPos, int length) {
        if (source.length < srcPos + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.writableBytes() < length && this.writerOffset() + length <= this.implicitCapacityLimit()) {
            this.ensureWritable(length, 1, false);
        }
        int woff = this.writerOffset();
        for (int i = 0; i < length; ++i) {
            this.setByte(woff + i, source[srcPos + i]);
        }
        this.skipWritableBytes(length);
        return this;
    }

    default public Buffer writeBytes(ByteBuffer source) {
        if (source.hasArray()) {
            this.writeBytes(source.array(), source.arrayOffset() + source.position(), source.remaining());
            source.position(source.limit());
        } else {
            boolean needReverse;
            int woff = this.writerOffset();
            int length = source.remaining();
            if (this.writableBytes() < length && woff + length <= this.implicitCapacityLimit()) {
                this.ensureWritable(length, 1, false);
            }
            this.writerOffset(woff + length);
            boolean bl = needReverse = source.order() != ByteOrder.BIG_ENDIAN;
            while (length >= 8) {
                this.setLong(woff, needReverse ? Long.reverseBytes(source.getLong()) : source.getLong());
                length -= 8;
                woff += 8;
            }
            while (length >= 4) {
                this.setInt(woff, needReverse ? Integer.reverseBytes(source.getInt()) : source.getInt());
                length -= 4;
                woff += 4;
            }
            while (length > 0) {
                this.setByte(woff, source.get());
                --length;
                ++woff;
            }
        }
        return this;
    }

    default public Buffer readBytes(ByteBuffer destination) {
        int byteCount = destination.remaining();
        this.copyInto(this.readerOffset(), destination, destination.position(), byteCount);
        this.skipReadableBytes(byteCount);
        destination.position(destination.limit());
        return this;
    }

    default public Buffer readBytes(byte[] destination, int destPos, int length) {
        int roff = this.readerOffset();
        this.copyInto(roff, destination, destPos, length);
        this.readerOffset(roff + length);
        return this;
    }

    default public Buffer resetOffsets() {
        this.readerOffset(0);
        if (!this.readOnly()) {
            this.writerOffset(0);
        }
        return this;
    }

    public int bytesBefore(byte var1);

    public int bytesBefore(Buffer var1);

    public ByteCursor openCursor();

    public ByteCursor openCursor(int var1, int var2);

    default public ByteCursor openReverseCursor() {
        int woff = this.writerOffset();
        return this.openReverseCursor(woff == 0 ? 0 : woff - 1, this.readableBytes());
    }

    public ByteCursor openReverseCursor(int var1, int var2);

    default public Buffer ensureWritable(int size) {
        this.ensureWritable(size, this.capacity(), true);
        return this;
    }

    public Buffer ensureWritable(int var1, int var2, boolean var3);

    default public Buffer copy() {
        int offset = this.readerOffset();
        int length = this.readableBytes();
        return this.copy(offset, length);
    }

    default public Buffer copy(int offset, int length) {
        return this.copy(offset, length, false);
    }

    default public Buffer copy(boolean readOnly) {
        return this.copy(this.readerOffset(), this.readableBytes(), readOnly);
    }

    public Buffer copy(int var1, int var2, boolean var3);

    default public Buffer readSplit(int length) {
        return this.split(this.readerOffset() + length);
    }

    default public Buffer writeSplit(int length) {
        return this.split(this.writerOffset() + length);
    }

    default public Buffer split() {
        return this.split(this.writerOffset());
    }

    public Buffer split(int var1);

    public Buffer compact();

    public int countComponents();

    public int countReadableComponents();

    public int countWritableComponents();

    public <T extends BufferComponent & ComponentIterator.Next> ComponentIterator<T> forEachComponent();

    default public String toString(Charset charset) {
        return InternalBufferUtils.toString(this, charset);
    }
}

