/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.bootstrap;

import io.netty5.bootstrap.AbstractBootstrap;
import io.netty5.bootstrap.ServerBootstrapConfig;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ReflectiveServerChannelFactory;
import io.netty5.channel.ServerChannel;
import io.netty5.channel.ServerChannelFactory;
import io.netty5.util.AttributeKey;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ServerBootstrap
extends AbstractBootstrap<ServerBootstrap, ServerChannel, ServerChannelFactory<? extends ServerChannel>> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new ConcurrentHashMap();
    private final ServerBootstrapConfig config = new ServerBootstrapConfig(this);
    private volatile EventLoopGroup childGroup;
    private volatile ChannelHandler childHandler;
    volatile ServerChannelFactory<? extends ServerChannel> channelFactory;

    public ServerBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerBootstrap(ServerBootstrap bootstrap) {
        super(bootstrap);
        this.childGroup = bootstrap.childGroup;
        this.childHandler = bootstrap.childHandler;
        this.channelFactory = bootstrap.channelFactory;
        Map<ChannelOption<?>, Object> map = bootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(bootstrap.childOptions);
        }
        this.childAttrs.putAll(bootstrap.childAttrs);
    }

    @Override
    public ServerBootstrap group(EventLoopGroup group) {
        return this.group(group, group);
    }

    public ServerBootstrap group(EventLoopGroup parentGroup, EventLoopGroup childGroup) {
        super.group(parentGroup);
        Objects.requireNonNull(childGroup, "childGroup");
        if (this.childGroup != null) {
            throw new IllegalStateException("childGroup set already");
        }
        this.childGroup = childGroup;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServerBootstrap childOption(ChannelOption<T> childOption, T value) {
        Objects.requireNonNull(childOption, "childOption");
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            if (value == null) {
                this.childOptions.remove(childOption);
            } else {
                this.childOptions.put(childOption, value);
            }
        }
        return this;
    }

    public <T> ServerBootstrap childAttr(AttributeKey<T> childKey, T value) {
        Objects.requireNonNull(childKey, "childKey");
        if (value == null) {
            this.childAttrs.remove(childKey);
        } else {
            this.childAttrs.put(childKey, value);
        }
        return this;
    }

    public ServerBootstrap childHandler(ChannelHandler childHandler) {
        Objects.requireNonNull(childHandler, "childHandler");
        this.childHandler = childHandler;
        return this;
    }

    public ServerBootstrap channel(Class<? extends ServerChannel> channelClass) {
        Objects.requireNonNull(channelClass, "channelClass");
        return this.channelFactory(new ReflectiveServerChannelFactory<ServerChannel>(channelClass));
    }

    public ServerBootstrap channelFactory(ServerChannelFactory<? extends ServerChannel> channelFactory) {
        Objects.requireNonNull(channelFactory, "channelFactory");
        if (this.channelFactory != null) {
            throw new IllegalStateException("channelFactory set already");
        }
        this.channelFactory = channelFactory;
        return this;
    }

    @Override
    Future<Channel> init(Channel channel) {
        final Promise promise = channel.executor().newPromise();
        ServerBootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        ServerBootstrap.setAttributes(channel, this.newAttributesArray());
        ChannelPipeline p = channel.pipeline();
        final ChannelHandler currentChildHandler = this.childHandler;
        final Map.Entry[] currentChildOptions = ServerBootstrap.newOptionsArray(this.childOptions);
        final Map.Entry[] currentChildAttrs = ServerBootstrap.newAttributesArray(this.childAttrs);
        p.addLast(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                ChannelHandler handler = ServerBootstrap.this.config.handler();
                if (handler != null) {
                    pipeline.addLast(handler);
                }
                ch.executor().execute(() -> {
                    pipeline.addLast(new ServerBootstrapAcceptor(ch, currentChildHandler, currentChildOptions, currentChildAttrs));
                    promise.setSuccess(ch);
                });
            }
        });
        return promise.asFuture();
    }

    @Override
    ServerChannel newChannel(EventLoop eventLoop) throws Exception {
        return this.channelFactory.newChannel(eventLoop, this.childGroup);
    }

    @Override
    public ServerBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.channelFactory == null) {
            throw new IllegalStateException("channelFactory not set");
        }
        if (this.childGroup == null) {
            logger.warn("childGroup is not set. Using parentGroup instead.");
            this.childGroup = this.config.group();
        }
        return this;
    }

    @Override
    public ServerBootstrap clone() {
        return new ServerBootstrap(this);
    }

    @Deprecated
    public EventLoopGroup childGroup() {
        return this.childGroup;
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<ChannelOption<?>, Object> childOptions() {
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            return ServerBootstrap.copiedMap(this.childOptions);
        }
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return ServerBootstrap.copiedMap(this.childAttrs);
    }

    public final ServerBootstrapConfig config() {
        return this.config;
    }

    private static class ServerBootstrapAcceptor
    implements ChannelHandler {
        private final ChannelHandler childHandler;
        private final Map.Entry<ChannelOption<?>, Object>[] childOptions;
        private final Map.Entry<AttributeKey<?>, Object>[] childAttrs;
        private final Runnable enableAutoReadTask;

        ServerBootstrapAcceptor(Channel channel, ChannelHandler childHandler, Map.Entry<ChannelOption<?>, Object>[] childOptions, Map.Entry<AttributeKey<?>, Object>[] childAttrs) {
            this.childHandler = childHandler;
            this.childOptions = childOptions;
            this.childAttrs = childAttrs;
            this.enableAutoReadTask = () -> channel.setOption(ChannelOption.AUTO_READ, true);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Channel child = (Channel)msg;
            EventLoop childEventLoop = child.executor();
            if (childEventLoop.inEventLoop()) {
                this.initChild(child);
            } else {
                try {
                    childEventLoop.execute(() -> this.initChild(child));
                }
                catch (Throwable cause) {
                    ServerBootstrapAcceptor.forceClose(child, cause);
                }
            }
        }

        private void initChild(Channel child) {
            assert (child.executor().inEventLoop());
            try {
                AbstractBootstrap.setChannelOptions(child, this.childOptions, logger);
                AbstractBootstrap.setAttributes(child, this.childAttrs);
                child.pipeline().addLast(this.childHandler);
                child.register().addListener(future -> {
                    if (future.isFailed()) {
                        ServerBootstrapAcceptor.forceClose(child, future.cause());
                    }
                });
            }
            catch (Throwable t) {
                ServerBootstrapAcceptor.forceClose(child, t);
            }
        }

        private static void forceClose(Channel child, Throwable t) {
            child.close();
            logger.warn("Failed to register an accepted channel: {}", (Object)child, (Object)t);
        }

        @Override
        public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (ctx.channel().getOption(ChannelOption.AUTO_READ).booleanValue()) {
                ctx.channel().setOption(ChannelOption.AUTO_READ, false);
                ctx.channel().executor().schedule(this.enableAutoReadTask, 1L, TimeUnit.SECONDS);
            }
            ctx.fireChannelExceptionCaught(cause);
        }
    }
}

