/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.bootstrap;

import io.netty5.bootstrap.AbstractBootstrap;
import io.netty5.bootstrap.BootstrapConfig;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFactory;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ReflectiveChannelFactory;
import io.netty5.resolver.AddressResolver;
import io.netty5.resolver.AddressResolverGroup;
import io.netty5.resolver.DefaultAddressResolverGroup;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel, ChannelFactory<? extends Channel>> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private static final AddressResolverGroup<?> DEFAULT_RESOLVER = DefaultAddressResolverGroup.INSTANCE;
    private final BootstrapConfig config = new BootstrapConfig(this);
    private volatile AddressResolverGroup<SocketAddress> resolver = DEFAULT_RESOLVER;
    private volatile SocketAddress remoteAddress;
    volatile ChannelFactory<? extends Channel> channelFactory;

    public Bootstrap() {
    }

    private Bootstrap(Bootstrap bootstrap) {
        super(bootstrap);
        this.resolver = bootstrap.resolver;
        this.remoteAddress = bootstrap.remoteAddress;
        this.channelFactory = bootstrap.channelFactory;
    }

    public Bootstrap resolver(AddressResolverGroup<?> resolver) {
        this.resolver = resolver == null ? DEFAULT_RESOLVER : resolver;
        return this;
    }

    public Bootstrap remoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public Bootstrap remoteAddress(String inetHost, int inetPort) {
        this.remoteAddress = InetSocketAddress.createUnresolved(inetHost, inetPort);
        return this;
    }

    public Bootstrap remoteAddress(InetAddress inetHost, int inetPort) {
        this.remoteAddress = new InetSocketAddress(inetHost, inetPort);
        return this;
    }

    public Bootstrap channel(Class<? extends Channel> channelClass) {
        Objects.requireNonNull(channelClass, "channelClass");
        return this.channelFactory(new ReflectiveChannelFactory<Channel>(channelClass));
    }

    public Bootstrap channelFactory(ChannelFactory<? extends Channel> channelFactory) {
        Objects.requireNonNull(channelFactory, "channelFactory");
        if (this.channelFactory != null) {
            throw new IllegalStateException("channelFactory set already");
        }
        this.channelFactory = channelFactory;
        return this;
    }

    public Future<Channel> connect() {
        this.validate();
        SocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        return this.doResolveAndConnect(remoteAddress, this.config.localAddress());
    }

    public Future<Channel> connect(String inetHost, int inetPort) {
        return this.connect(InetSocketAddress.createUnresolved(inetHost, inetPort));
    }

    public Future<Channel> connect(InetAddress inetHost, int inetPort) {
        return this.connect(new InetSocketAddress(inetHost, inetPort));
    }

    public Future<Channel> connect(SocketAddress remoteAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        this.validate();
        return this.doResolveAndConnect(remoteAddress, this.config.localAddress());
    }

    public Future<Channel> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        this.validate();
        return this.doResolveAndConnect(remoteAddress, localAddress);
    }

    private Future<Channel> doResolveAndConnect(SocketAddress remoteAddress, SocketAddress localAddress) {
        EventLoop loop = this.group.next();
        Future<Channel> regFuture = this.initAndRegister(loop);
        Promise<Channel> resolveAndConnectPromise = loop.newPromise();
        if (regFuture.isDone()) {
            if (regFuture.isFailed()) {
                return regFuture;
            }
            Channel channel = (Channel)regFuture.getNow();
            this.doResolveAndConnect0(channel, remoteAddress, localAddress, resolveAndConnectPromise);
        } else {
            regFuture.addListener(future -> {
                Throwable cause = future.cause();
                if (cause != null) {
                    resolveAndConnectPromise.setFailure(cause);
                } else {
                    Channel channel = (Channel)future.getNow();
                    this.doResolveAndConnect0(channel, remoteAddress, localAddress, resolveAndConnectPromise);
                }
            });
        }
        return resolveAndConnectPromise.asFuture();
    }

    private void doResolveAndConnect0(Channel channel, SocketAddress remoteAddress, SocketAddress localAddress, Promise<Channel> promise) {
        try {
            EventLoop eventLoop = channel.executor();
            AddressResolver<SocketAddress> resolver = this.resolver.getResolver(eventLoop);
            if (!resolver.isSupported(remoteAddress) || resolver.isResolved(remoteAddress)) {
                Bootstrap.doConnect(remoteAddress, localAddress, channel, promise);
                return;
            }
            Future<SocketAddress> resolveFuture = resolver.resolve(remoteAddress);
            if (resolveFuture.isDone()) {
                Throwable resolveFailureCause = resolveFuture.cause();
                if (resolveFailureCause != null) {
                    channel.close();
                    promise.setFailure(resolveFailureCause);
                } else {
                    Bootstrap.doConnect((SocketAddress)resolveFuture.getNow(), localAddress, channel, promise);
                    return;
                }
            }
            resolveFuture.addListener(future -> {
                if (future.cause() != null) {
                    channel.close();
                    promise.setFailure(future.cause());
                } else {
                    Bootstrap.doConnect((SocketAddress)future.getNow(), localAddress, channel, promise);
                }
            });
        }
        catch (Throwable cause) {
            promise.tryFailure(cause);
        }
    }

    private static void doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Channel channel, Promise<Channel> promise) {
        channel.executor().execute(() -> {
            Future<Void> future = localAddress == null ? channel.connect(remoteAddress) : channel.connect(remoteAddress, localAddress);
            future.addListener(channel, ChannelFutureListeners.CLOSE_ON_FAILURE);
            future.map(v -> channel).cascadeTo(promise);
        });
    }

    @Override
    Future<Channel> init(Channel channel) {
        ChannelPipeline p = channel.pipeline();
        Bootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        Bootstrap.setAttributes(channel, this.newAttributesArray());
        p.addLast(this.config.handler());
        return channel.executor().newSucceededFuture(channel);
    }

    @Override
    Channel newChannel(EventLoop eventLoop) throws Exception {
        return this.channelFactory.newChannel(eventLoop);
    }

    @Override
    public Bootstrap validate() {
        super.validate();
        if (this.config.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        if (this.config.channelFactory() == null) {
            throw new IllegalStateException("channelFactory not set");
        }
        return this;
    }

    @Override
    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    public Bootstrap clone(EventLoopGroup group) {
        Bootstrap bs = new Bootstrap(this);
        bs.group = group;
        return bs;
    }

    public final BootstrapConfig config() {
        return this.config;
    }

    final SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    final AddressResolverGroup<?> resolver() {
        return this.resolver;
    }
}

