/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.bootstrap;

import io.netty5.bootstrap.AbstractBootstrapConfig;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.util.AttributeKey;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.SocketUtils;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.logging.InternalLogger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractBootstrap<B extends AbstractBootstrap<B, C, F>, C extends Channel, F>
implements Cloneable {
    private static final Map.Entry<ChannelOption<?>, Object>[] EMPTY_OPTION_ARRAY = new Map.Entry[0];
    private static final Map.Entry<AttributeKey<?>, Object>[] EMPTY_ATTRIBUTE_ARRAY = new Map.Entry[0];
    volatile EventLoopGroup group;
    private volatile SocketAddress localAddress;
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new ConcurrentHashMap();
    private volatile ChannelHandler handler;

    AbstractBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractBootstrap(AbstractBootstrap<B, C, F> bootstrap) {
        this.group = bootstrap.group;
        this.handler = bootstrap.handler;
        this.localAddress = bootstrap.localAddress;
        Map<ChannelOption<?>, Object> map = bootstrap.options;
        synchronized (map) {
            this.options.putAll(bootstrap.options);
        }
        this.attrs.putAll(bootstrap.attrs);
    }

    public B group(EventLoopGroup group) {
        Objects.requireNonNull(group, "group");
        if (this.group != null) {
            throw new IllegalStateException("group set already");
        }
        this.group = group;
        return this.self();
    }

    private B self() {
        return (B)this;
    }

    public B localAddress(SocketAddress localAddress) {
        this.localAddress = localAddress;
        return this.self();
    }

    public B localAddress(int inetPort) {
        return this.localAddress(new InetSocketAddress(inetPort));
    }

    public B localAddress(String inetHost, int inetPort) {
        return this.localAddress(SocketUtils.socketAddress(inetHost, inetPort));
    }

    public B localAddress(InetAddress inetHost, int inetPort) {
        return this.localAddress(new InetSocketAddress(inetHost, inetPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> B option(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            if (value == null) {
                this.options.remove(option);
            } else {
                this.options.put(option, value);
            }
        }
        return this.self();
    }

    public <T> B attr(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        if (value == null) {
            this.attrs.remove(key);
        } else {
            this.attrs.put(key, value);
        }
        return this.self();
    }

    public B validate() {
        if (this.group == null) {
            throw new IllegalStateException("group not set");
        }
        return this.self();
    }

    public abstract B clone();

    public Future<Channel> register() {
        this.validate();
        return this.initAndRegister(this.group.next());
    }

    public Channel createUnregistered() throws Exception {
        this.validate();
        return this.initWithoutRegister();
    }

    public Future<Channel> bind() {
        this.validate();
        SocketAddress localAddress = this.localAddress;
        Objects.requireNonNull(localAddress, "localAddress");
        return this.doBind(localAddress);
    }

    public Future<Channel> bind(int inetPort) {
        return this.bind(new InetSocketAddress(inetPort));
    }

    public Future<Channel> bind(String inetHost, int inetPort) {
        return this.bind(SocketUtils.socketAddress(inetHost, inetPort));
    }

    public Future<Channel> bind(InetAddress inetHost, int inetPort) {
        return this.bind(new InetSocketAddress(inetHost, inetPort));
    }

    public Future<Channel> bind(SocketAddress localAddress) {
        this.validate();
        Objects.requireNonNull(localAddress, "localAddress");
        return this.doBind(localAddress);
    }

    private Future<Channel> doBind(SocketAddress localAddress) {
        EventLoop loop = this.group.next();
        Future<Channel> regFuture = this.initAndRegister(loop);
        if (regFuture.isFailed()) {
            return regFuture;
        }
        Promise bindPromise = loop.newPromise();
        if (regFuture.isDone()) {
            Channel channel = (Channel)regFuture.getNow();
            Promise<Void> promise = channel.newPromise();
            promise.asFuture().map(v -> channel).cascadeTo(bindPromise);
            AbstractBootstrap.doBind0(regFuture, channel, localAddress, promise);
        } else {
            regFuture.addListener(future -> {
                Throwable cause = future.cause();
                if (cause != null) {
                    bindPromise.setFailure(cause);
                } else {
                    Channel channel = (Channel)future.getNow();
                    Promise<Void> promise = channel.newPromise();
                    promise.asFuture().map(v -> channel).cascadeTo(bindPromise);
                    AbstractBootstrap.doBind0(regFuture, channel, localAddress, promise);
                }
            });
        }
        return bindPromise.asFuture();
    }

    final Future<Channel> initAndRegister(EventLoop loop) {
        Object channel;
        try {
            channel = this.newChannel(loop);
        }
        catch (Throwable t) {
            return loop.newFailedFuture(t);
        }
        Promise promise = loop.newPromise();
        loop.execute(() -> this.init((Channel)channel).addListener(future -> {
            if (future.isSuccess()) {
                channel.register().addListener(f -> promise.setSuccess(channel));
            } else {
                channel.close();
                promise.setFailure(future.cause());
            }
        }));
        return promise.asFuture();
    }

    final Channel initWithoutRegister() throws Exception {
        EventLoop loop = this.group.next();
        C channel = this.newChannel(loop);
        this.init((Channel)channel).addListener(channel, ChannelFutureListeners.CLOSE_ON_FAILURE);
        return channel;
    }

    abstract C newChannel(EventLoop var1) throws Exception;

    abstract Future<Channel> init(Channel var1);

    private static void doBind0(Future<Channel> regFuture, Channel channel, SocketAddress localAddress, Promise<Void> promise) {
        channel.executor().execute(() -> {
            if (regFuture.isSuccess()) {
                channel.bind(localAddress).cascadeTo(promise).addListener(channel, ChannelFutureListeners.CLOSE_ON_FAILURE);
            } else {
                promise.setFailure(regFuture.cause());
            }
        });
    }

    public B handler(ChannelHandler handler) {
        Objects.requireNonNull(handler, "handler");
        this.handler = handler;
        return this.self();
    }

    @Deprecated
    public final EventLoopGroup group() {
        return this.group;
    }

    public abstract AbstractBootstrapConfig<B, C, F> config();

    final Map.Entry<ChannelOption<?>, Object>[] newOptionsArray() {
        return AbstractBootstrap.newOptionsArray(this.options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map.Entry<ChannelOption<?>, Object>[] newOptionsArray(Map<ChannelOption<?>, Object> options) {
        Map<ChannelOption<?>, Object> map = options;
        synchronized (map) {
            return new LinkedHashMap(options).entrySet().toArray(EMPTY_OPTION_ARRAY);
        }
    }

    final Map.Entry<AttributeKey<?>, Object>[] newAttributesArray() {
        return AbstractBootstrap.newAttributesArray(this.attrs);
    }

    static Map.Entry<AttributeKey<?>, Object>[] newAttributesArray(Map<AttributeKey<?>, Object> attributes) {
        return attributes.entrySet().toArray(EMPTY_ATTRIBUTE_ARRAY);
    }

    final SocketAddress localAddress() {
        return this.localAddress;
    }

    final ChannelHandler handler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<ChannelOption<?>, Object> options() {
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            return AbstractBootstrap.copiedMap(this.options);
        }
    }

    final Map<AttributeKey<?>, Object> attrs() {
        return AbstractBootstrap.copiedMap(this.attrs);
    }

    static <K, V> Map<K, V> copiedMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Map.copyOf(map);
    }

    static void setAttributes(Channel channel, Map.Entry<AttributeKey<?>, Object>[] attrs) {
        for (Map.Entry<AttributeKey<?>, Object> e : attrs) {
            AttributeKey<?> key = e.getKey();
            channel.attr(key).set(e.getValue());
        }
    }

    static void setChannelOptions(Channel channel, Map.Entry<ChannelOption<?>, Object>[] options, InternalLogger logger) {
        for (Map.Entry<ChannelOption<?>, Object> e : options) {
            AbstractBootstrap.setChannelOption(channel, e.getKey(), e.getValue(), logger);
        }
    }

    private static void setChannelOption(Channel channel, ChannelOption<?> option, Object value, InternalLogger logger) {
        try {
            if (!channel.isOptionSupported(option)) {
                logger.warn("Unknown channel option '{}' for channel '{}'", (Object)option, (Object)channel);
            } else {
                channel.setOption(option, value);
            }
        }
        catch (Throwable t) {
            logger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", option, value, channel, t);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName(this)).append('(').append(this.config()).append(')');
        return buf.toString();
    }
}

