/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.util;

import eu.cloudnetservice.driver.network.HostAndPort;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import lombok.NonNull;

public final class BridgeHostAndPortUtil {
    private BridgeHostAndPortUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static HostAndPort fromSocketAddress(@NonNull SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (address instanceof InetSocketAddress || address instanceof UnixDomainSocketAddress) {
            return HostAndPort.fromSocketAddress(address);
        }
        if (address instanceof DomainSocketAddress) {
            DomainSocketAddress domain = (DomainSocketAddress)address;
            return new HostAndPort(domain.path(), -1);
        }
        if (address instanceof LocalAddress) {
            LocalAddress local = (LocalAddress)address;
            return new HostAndPort(local.id(), -1);
        }
        throw new IllegalArgumentException("Unsupported socket address type: " + address.getClass().getName());
    }
}

