/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.rpc;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import lombok.NonNull;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;

public final class TitleObjectSerializer
implements ObjectSerializer<Title> {
    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull Title object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Title.Times times = Objects.requireNonNullElse(object.times(), Title.DEFAULT_TIMES);
        dataBuf.writeLong(times.fadeIn().toMillis());
        dataBuf.writeLong(times.stay().toMillis());
        dataBuf.writeLong(times.fadeOut().toMillis());
        dataBuf.writeObject(object.title());
        dataBuf.writeObject(object.subtitle());
    }

    @Override
    @NonNull
    public Object read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        Title.Times times = Title.Times.times(Duration.ofMillis(source.readLong()), Duration.ofMillis(source.readLong()), Duration.ofMillis(source.readLong()));
        TextComponent title = source.readObject(TextComponent.class);
        TextComponent subtitle = source.readObject(TextComponent.class);
        return Title.title(title, subtitle, times);
    }
}

