/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.player.executor;

import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.modules.bridge.BridgeDocProperties;
import java.util.Comparator;
import java.util.concurrent.ThreadLocalRandom;
import lombok.NonNull;

public enum ServerSelectorType {
    LOWEST_PLAYERS(Comparator.comparingInt(ser -> ser.readProperty(BridgeDocProperties.ONLINE_COUNT))),
    HIGHEST_PLAYERS(ServerSelectorType.LOWEST_PLAYERS.comparator.reversed()),
    RANDOM(Comparator.comparingInt(value -> ThreadLocalRandom.current().nextInt(-1, 2)));

    private final Comparator<ServiceInfoSnapshot> comparator;

    private ServerSelectorType(Comparator<ServiceInfoSnapshot> comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        this.comparator = comparator;
    }

    @NonNull
    public Comparator<ServiceInfoSnapshot> comparator() {
        return this.comparator;
    }
}

