/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.player;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public interface PlayerProvider {
    @NonNull
    public Collection<CloudPlayer> players();

    @NonNull
    public Collection<UUID> uniqueIds();

    @NonNull
    public Collection<String> names();

    public int count();

    @NonNull
    default public CompletableFuture<Collection<CloudPlayer>> playersAsync() {
        return TaskUtil.supplyAsync(this::players);
    }

    @NonNull
    default public CompletableFuture<Collection<UUID>> uniqueIdsAsync() {
        return TaskUtil.supplyAsync(this::uniqueIds);
    }

    @NonNull
    default public CompletableFuture<Collection<String>> namesAsync() {
        return TaskUtil.supplyAsync(this::names);
    }

    @NonNull
    default public CompletableFuture<Integer> countAsync() {
        return TaskUtil.supplyAsync(this::count);
    }
}

