/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.player;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.modules.bridge.player.CloudOfflinePlayer;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.PlayerProvider;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface PlayerManager {
    public @Range(from=0L, to=0x7FFFFFFFL) int onlineCount();

    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long registeredCount();

    @Nullable
    public CloudPlayer onlinePlayer(@NonNull UUID var1);

    @Nullable
    public CloudPlayer firstOnlinePlayer(@NonNull String var1);

    @NonNull
    public List<CloudPlayer> onlinePlayers(@NonNull String var1);

    @NonNull
    public List<CloudPlayer> environmentOnlinePlayers(@NonNull ServiceEnvironmentType var1);

    @NonNull
    public PlayerExecutor globalPlayerExecutor();

    @NonNull
    public PlayerExecutor playerExecutor(@NonNull UUID var1);

    @NonNull
    public PlayerProvider onlinePlayers();

    @NonNull
    public PlayerProvider taskOnlinePlayers(@NonNull String var1);

    @NonNull
    public PlayerProvider groupOnlinePlayers(@NonNull String var1);

    @Nullable
    public CloudOfflinePlayer offlinePlayer(@NonNull UUID var1);

    @Nullable
    public CloudOfflinePlayer firstOfflinePlayer(@NonNull String var1);

    @NonNull
    public List<CloudOfflinePlayer> offlinePlayers(@NonNull String var1);

    @NonNull
    public List<CloudOfflinePlayer> registeredPlayers();

    public void updateOfflinePlayer(@NonNull CloudOfflinePlayer var1);

    public void updateOnlinePlayer(@NonNull CloudPlayer var1);

    public void deleteCloudOfflinePlayer(@NonNull CloudOfflinePlayer var1);

    @NonNull
    default public CompletableFuture<Integer> onlineCountAsync() {
        return TaskUtil.supplyAsync(this::onlineCount);
    }

    @NonNull
    default public CompletableFuture<Long> registeredCountAsync() {
        return TaskUtil.supplyAsync(this::registeredCount);
    }

    @NonNull
    default public CompletableFuture<CloudPlayer> onlinePlayerAsync(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.onlinePlayer(uniqueId));
    }

    @NonNull
    default public CompletableFuture<CloudPlayer> firstOnlinePlayerAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.firstOnlinePlayer(name));
    }

    @NonNull
    default public CompletableFuture<List<CloudPlayer>> onlinePlayerAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.onlinePlayers(name));
    }

    @NonNull
    default public CompletableFuture<List<CloudPlayer>> onlinePlayerAsync(@NonNull ServiceEnvironmentType env) {
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.environmentOnlinePlayers(env));
    }

    @NonNull
    default public CompletableFuture<CloudOfflinePlayer> offlinePlayerAsync(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.offlinePlayer(uniqueId));
    }

    @NonNull
    default public CompletableFuture<CloudOfflinePlayer> firstOfflinePlayerAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.firstOnlinePlayer(name));
    }

    @NonNull
    default public CompletableFuture<List<CloudOfflinePlayer>> offlinePlayerAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync(() -> this.offlinePlayers(name));
    }

    @NonNull
    default public CompletableFuture<Void> updateOfflinePlayerAsync(@NonNull CloudOfflinePlayer cloudOfflinePlayer) {
        if (cloudOfflinePlayer == null) {
            throw new NullPointerException("cloudOfflinePlayer is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.updateOfflinePlayer(cloudOfflinePlayer));
    }

    @NonNull
    default public CompletableFuture<Void> updateOnlinePlayerAsync(@NonNull CloudPlayer cloudPlayer) {
        if (cloudPlayer == null) {
            throw new NullPointerException("cloudPlayer is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.updateOnlinePlayer(cloudPlayer));
    }

    @NonNull
    default public CompletableFuture<Void> deleteCloudOfflinePlayerAsync(@NonNull CloudOfflinePlayer cloudOfflinePlayer) {
        if (cloudOfflinePlayer == null) {
            throw new NullPointerException("cloudOfflinePlayer is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.deleteCloudOfflinePlayer(cloudOfflinePlayer));
    }
}

