/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.player;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class CloudOfflinePlayer
implements DefaultedDocPropertyHolder,
Cloneable,
Named {
    protected final String name;
    protected long firstLoginTimeMillis;
    protected long lastLoginTimeMillis;
    protected NetworkPlayerProxyInfo lastNetworkPlayerProxyInfo;
    protected Document properties;

    public CloudOfflinePlayer(@NonNull String name, long firstLoginTimeMillis, long lastLoginTimeMillis, @NonNull NetworkPlayerProxyInfo proxyInfo, @NonNull Document properties) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (proxyInfo == null) {
            throw new NullPointerException("proxyInfo is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.name = name;
        this.firstLoginTimeMillis = firstLoginTimeMillis;
        this.lastLoginTimeMillis = lastLoginTimeMillis;
        this.properties = properties;
        this.lastNetworkPlayerProxyInfo = proxyInfo;
    }

    @NonNull
    public static CloudOfflinePlayer offlineCopy(@NonNull CloudPlayer onlineVariant) {
        if (onlineVariant == null) {
            throw new NullPointerException("onlineVariant is marked non-null but is null");
        }
        return new CloudOfflinePlayer(onlineVariant.name(), onlineVariant.firstLoginTimeMillis(), onlineVariant.lastLoginTimeMillis(), onlineVariant.networkPlayerProxyInfo().clone(), onlineVariant.propertyHolder().immutableCopy());
    }

    @NonNull
    public UUID uniqueId() {
        return this.lastNetworkPlayerProxyInfo.uniqueId();
    }

    @Override
    @NonNull
    public String name() {
        return this.name;
    }

    @Nullable
    public String xBoxId() {
        return this.lastNetworkPlayerProxyInfo.xBoxId();
    }

    public long firstLoginTimeMillis() {
        return this.firstLoginTimeMillis;
    }

    public long lastLoginTimeMillis() {
        return this.lastLoginTimeMillis;
    }

    @NonNull
    public NetworkPlayerProxyInfo lastNetworkPlayerProxyInfo() {
        return this.lastNetworkPlayerProxyInfo;
    }

    public void lastNetworkPlayerProxyInfo(@NonNull NetworkPlayerProxyInfo lastNetworkPlayerProxyInfo) {
        if (lastNetworkPlayerProxyInfo == null) {
            throw new NullPointerException("lastNetworkPlayerProxyInfo is marked non-null but is null");
        }
        this.lastNetworkPlayerProxyInfo = lastNetworkPlayerProxyInfo;
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this.properties;
    }

    @NonNull
    public CloudOfflinePlayer clone() {
        try {
            return (CloudOfflinePlayer)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException();
        }
    }

    @Generated
    public String toString() {
        return "CloudOfflinePlayer(name=" + this.name + ", firstLoginTimeMillis=" + this.firstLoginTimeMillis + ", lastLoginTimeMillis=" + this.lastLoginTimeMillis + ", lastNetworkPlayerProxyInfo=" + String.valueOf(this.lastNetworkPlayerProxyInfo) + ", properties=" + String.valueOf(this.properties) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudOfflinePlayer)) {
            return false;
        }
        CloudOfflinePlayer other = (CloudOfflinePlayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.firstLoginTimeMillis != other.firstLoginTimeMillis) {
            return false;
        }
        if (this.lastLoginTimeMillis != other.lastLoginTimeMillis) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NetworkPlayerProxyInfo this$lastNetworkPlayerProxyInfo = this.lastNetworkPlayerProxyInfo;
        NetworkPlayerProxyInfo other$lastNetworkPlayerProxyInfo = other.lastNetworkPlayerProxyInfo;
        if (this$lastNetworkPlayerProxyInfo == null ? other$lastNetworkPlayerProxyInfo != null : !((Object)this$lastNetworkPlayerProxyInfo).equals(other$lastNetworkPlayerProxyInfo)) {
            return false;
        }
        Document this$properties = this.properties;
        Document other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudOfflinePlayer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $firstLoginTimeMillis = this.firstLoginTimeMillis;
        result = result * 59 + (int)($firstLoginTimeMillis >>> 32 ^ $firstLoginTimeMillis);
        long $lastLoginTimeMillis = this.lastLoginTimeMillis;
        result = result * 59 + (int)($lastLoginTimeMillis >>> 32 ^ $lastLoginTimeMillis);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NetworkPlayerProxyInfo $lastNetworkPlayerProxyInfo = this.lastNetworkPlayerProxyInfo;
        result = result * 59 + ($lastNetworkPlayerProxyInfo == null ? 43 : ((Object)$lastNetworkPlayerProxyInfo).hashCode());
        Document $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }
}

