/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.waterdog.command;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.command.Command;
import dev.waterdog.waterdogpe.command.CommandSender;
import dev.waterdog.waterdogpe.command.CommandSettings;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import java.util.Locale;
import lombok.NonNull;

public final class WaterDogPEHubCommand
extends Command {
    private final ProxyServer proxyServer;
    private final PlatformBridgeManagement<ProxiedPlayer, ?> management;

    public WaterDogPEHubCommand(@NonNull PlatformBridgeManagement<ProxiedPlayer, ?> management, @NonNull ProxyServer proxyServer, @NonNull String name, String @NonNull [] aliases) {
        super(name, CommandSettings.builder().setAliases(aliases).build());
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        this.management = management;
        this.proxyServer = proxyServer;
    }

    public boolean onExecute(CommandSender sender, String alias, String[] args) {
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)sender;
            if (this.management.isOnAnyFallbackInstance(player)) {
                this.management.configuration().handleMessage(Locale.ENGLISH, "command-hub-already-in-hub", ComponentFormats.ADVENTURE_TO_BUNGEE::convertText, arg_0 -> ((ProxiedPlayer)player).sendMessage(arg_0));
            } else {
                ServerInfo hub = this.management.fallback(player).map(service -> this.proxyServer.getServerInfo(service.name())).orElse(null);
                if (hub != null) {
                    player.connect(hub);
                    this.management.configuration().handleMessage(Locale.ENGLISH, "command-hub-success-connect", message -> ComponentFormats.BUNGEE_TO_ADVENTURE.convertText(message.replace("%server%", hub.getServerName())), arg_0 -> ((ProxiedPlayer)player).sendMessage(arg_0));
                }
            }
        }
        return true;
    }
}

