/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.waterdog.command;

import dev.waterdog.waterdogpe.command.Command;
import dev.waterdog.waterdogpe.command.CommandSender;
import dev.waterdog.waterdogpe.command.CommandSettings;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import eu.cloudnetservice.driver.provider.ClusterNodeProvider;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Locale;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public final class WaterDogPECloudCommand
extends Command {
    private final ClusterNodeProvider clusterNodeProvider;
    private final PlatformBridgeManagement<?, ?> management;

    @Inject
    public WaterDogPECloudCommand(@NonNull ClusterNodeProvider clusterNodeProvider, @NonNull PlatformBridgeManagement<?, ?> management) {
        super("cloudnet", CommandSettings.builder().setAliases(new String[]{"cloud", "cn"}).setPermission("cloudnet.command.cloudnet").build());
        if (clusterNodeProvider == null) {
            throw new NullPointerException("clusterNodeProvider is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.clusterNodeProvider = clusterNodeProvider;
        this.management = management;
    }

    public boolean onExecute(@NonNull CommandSender sender, @Nullable String alias, String @NonNull [] args) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (args.length == 0) {
            sender.sendMessage(ComponentFormats.ADVENTURE_TO_BUNGEE.convertText(this.management.configuration().prefix() + "/cloudnet <command>"));
            return true;
        }
        String commandLine = String.join((CharSequence)" ", args);
        if (sender instanceof ProxiedPlayer) {
            this.clusterNodeProvider.consoleCommandAsync(args[0]).thenAcceptAsync(info -> {
                if (info != null && sender.hasPermission(info.permission())) {
                    this.executeNow(sender, commandLine);
                    return;
                }
                this.management.configuration().handleMessage(Locale.ENGLISH, "command-cloud-sub-command-no-permission", message -> message.replace("%command%", args[0]), arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
            });
        } else {
            this.executeNow(sender, commandLine);
        }
        return true;
    }

    private void executeNow(@NonNull CommandSender sender, @NonNull String commandLine) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        for (String output : this.clusterNodeProvider.sendCommandLine(commandLine)) {
            sender.sendMessage(ComponentFormats.ADVENTURE_TO_BUNGEE.convertText(this.management.configuration().prefix() + output));
        }
    }
}

