/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.waterdog;

import dev.waterdog.waterdogpe.event.EventManager;
import dev.waterdog.waterdogpe.event.defaults.InitialServerConnectedEvent;
import dev.waterdog.waterdogpe.event.defaults.PlayerDisconnectEvent;
import dev.waterdog.waterdogpe.event.defaults.PlayerLoginEvent;
import dev.waterdog.waterdogpe.event.defaults.TransferCompleteEvent;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import dev.waterdog.waterdogpe.scheduler.WaterdogScheduler;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.modules.bridge.node.event.LocalPlayerPreLoginEvent;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.helper.ProxyPlatformHelper;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Locale;
import lombok.NonNull;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

@Singleton
public final class WaterDogPEPlayerManagementListener {
    private final WaterdogScheduler scheduler;
    private final ServiceInfoHolder serviceInfoHolder;
    private final ProxyPlatformHelper proxyPlatformHelper;
    private final PlatformBridgeManagement<ProxiedPlayer, NetworkPlayerProxyInfo> management;

    @Inject
    public WaterDogPEPlayerManagementListener(@NonNull EventManager eventManager, @NonNull WaterdogScheduler scheduler, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull ProxyPlatformHelper proxyPlatformHelper, @NonNull PlatformBridgeManagement<ProxiedPlayer, NetworkPlayerProxyInfo> management) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (proxyPlatformHelper == null) {
            throw new NullPointerException("proxyPlatformHelper is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.scheduler = scheduler;
        this.serviceInfoHolder = serviceInfoHolder;
        this.proxyPlatformHelper = proxyPlatformHelper;
        this.management = management;
        eventManager.subscribe(PlayerLoginEvent.class, this::handleLogin);
        eventManager.subscribe(TransferCompleteEvent.class, this::handleTransfer);
        eventManager.subscribe(PlayerDisconnectEvent.class, this::handleDisconnected);
        eventManager.subscribe(InitialServerConnectedEvent.class, this::handleInitialConnect);
    }

    private void handleLogin(@NonNull PlayerLoginEvent event) {
        LocalPlayerPreLoginEvent.Result loginResult;
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        ServiceTask task = this.management.selfTask();
        if (task != null) {
            if (task.maintenance() && !event.getPlayer().hasPermission("cloudnet.bridge.maintenance")) {
                event.setCancelled(true);
                this.management.configuration().handleMessage(Locale.ENGLISH, "proxy-join-cancel-because-maintenance", arg_0 -> ((PlayerLoginEvent)event).setCancelReason(arg_0));
                return;
            }
            String permission = task.propertyHolder().getString("requiredPermission");
            if (permission != null && !event.getPlayer().hasPermission(permission)) {
                event.setCancelled(true);
                this.management.configuration().handleMessage(Locale.ENGLISH, "proxy-join-cancel-because-permission", arg_0 -> ((PlayerLoginEvent)event).setCancelReason(arg_0));
                return;
            }
        }
        if (!(loginResult = this.proxyPlatformHelper.sendChannelMessagePreLogin(this.management.createPlayerInformation(event.getPlayer()))).permitLogin()) {
            event.setCancelled(true);
            event.setCancelReason(LegacyComponentSerializer.legacySection().serialize(loginResult.result()));
        }
    }

    private void handleInitialConnect(@NonNull InitialServerConnectedEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.proxyPlatformHelper.sendChannelMessageLoginSuccess(this.management.createPlayerInformation(event.getPlayer()), this.management.cachedService(service -> service.name().equals(event.getInitialDownstream().getServerInfo().getServerName())).map(NetworkServiceInfo::fromServiceInfoSnapshot).orElse(null));
        this.serviceInfoHolder.publishServiceInfoUpdate();
        this.management.handleFallbackConnectionSuccess(event.getPlayer());
    }

    private void handleTransfer(@NonNull TransferCompleteEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.management.cachedService(service -> service.name().equals(event.getNewClient().getServerInfo().getServerName())).map(NetworkServiceInfo::fromServiceInfoSnapshot).ifPresent(serviceInfo -> this.proxyPlatformHelper.sendChannelMessageServiceSwitch(event.getPlayer().getUniqueId(), (NetworkServiceInfo)serviceInfo));
        this.management.handleFallbackConnectionSuccess(event.getPlayer());
    }

    private void handleDisconnected(@NonNull PlayerDisconnectEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.getPlayer().getServerInfo() != null) {
            this.proxyPlatformHelper.sendChannelMessageDisconnected(event.getPlayer().getUniqueId());
            this.scheduler.scheduleDelayed(() -> ((ServiceInfoHolder)this.serviceInfoHolder).publishServiceInfoUpdate(), 1);
        }
        this.management.removeFallbackProfile(event.getPlayer());
    }
}

