/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.waterdog;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import dev.waterdog.waterdogpe.utils.types.IForcedHostHandler;
import dev.waterdog.waterdogpe.utils.types.IReconnectHandler;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import java.util.Locale;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class WaterDogPEHandlers
implements IForcedHostHandler,
IReconnectHandler {
    private final ProxyServer proxyServer;
    private final PlatformBridgeManagement<ProxiedPlayer, ?> management;

    public WaterDogPEHandlers(@NonNull ProxyServer proxyServer, @NonNull PlatformBridgeManagement<ProxiedPlayer, ?> management) {
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.management = management;
    }

    public ServerInfo resolveForcedHost(@Nullable String domain, @NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.management.fallback(player.getUniqueId(), null, domain, arg_0 -> ((ProxiedPlayer)player).hasPermission(arg_0)).map(server -> this.proxyServer.getServerInfo(server.name())).orElse(null);
    }

    public ServerInfo getFallbackServer(@NonNull ProxiedPlayer player, @NonNull ServerInfo oldServer, @NonNull String kickMessage) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (oldServer == null) {
            throw new NullPointerException("oldServer is marked non-null but is null");
        }
        if (kickMessage == null) {
            throw new NullPointerException("kickMessage is marked non-null but is null");
        }
        this.management.configuration().handleMessage(Locale.ENGLISH, "error-connecting-to-server", message -> message.replace("%server%", oldServer.getServerName()).replace("%reason%", kickMessage), arg_0 -> ((ProxiedPlayer)player).sendMessage(arg_0));
        return this.management.fallback(player, oldServer.getServerName()).map(server -> this.proxyServer.getServerInfo(server.name())).orElse(null);
    }
}

