/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.waterdog;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.command.CommandSender;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerExecutorAdapter;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.Nullable;

final class WaterDogPEDirectPlayerExecutor
extends PlatformPlayerExecutorAdapter<ProxiedPlayer> {
    private final ProxyServer proxyServer;
    private final PlatformBridgeManagement<ProxiedPlayer, ?> management;

    public WaterDogPEDirectPlayerExecutor(@NonNull UUID uniqueId, @NonNull ProxyServer proxyServer, @NonNull PlatformBridgeManagement<ProxiedPlayer, ?> management, @NonNull Supplier<Collection<? extends ProxiedPlayer>> playerSupplier) {
        super(uniqueId, playerSupplier);
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        if (playerSupplier == null) {
            throw new NullPointerException("playerSupplier is marked non-null but is null");
        }
        this.management = management;
        this.proxyServer = proxyServer;
    }

    @Override
    public void connect(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        ServerInfo serverInfo = this.proxyServer.getServerInfo(serviceName);
        if (serverInfo != null) {
            this.forEach(player -> player.connect(serverInfo));
        }
    }

    @Override
    public void connectSelecting(@NonNull ServerSelectorType selectorType) {
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().sorted(selectorType.comparator()).map(service -> this.proxyServer.getServerInfo(service.name())).filter(Objects::nonNull).findFirst().ifPresent(server -> this.forEach(player -> player.connect(server)));
    }

    @Override
    public void connectToFallback() {
        ((Collection)this.playerSupplier.get()).stream().filter(Objects::nonNull).map(player -> new Tuple2<ProxiedPlayer, Optional<ServiceInfoSnapshot>>((ProxiedPlayer)player, this.management.fallback((ProxiedPlayer)player))).filter(pair -> ((Optional)pair.second()).isPresent()).map(p -> new Tuple2<ProxiedPlayer, ServerInfo>((ProxiedPlayer)p.first(), this.proxyServer.getServerInfo(((ServiceInfoSnapshot)((Optional)p.second()).get()).name()))).filter(pair -> pair.second() != null).findFirst().ifPresent(pair -> ((ProxiedPlayer)pair.first()).connect((ServerInfo)pair.second()));
    }

    @Override
    public void connectToGroup(@NonNull String group, @NonNull ServerSelectorType selectorType) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().filter(service -> service.configuration().groups().contains(group)).sorted(selectorType.comparator()).map(service -> this.proxyServer.getServerInfo(service.name())).filter(Objects::nonNull).findFirst().ifPresent(server -> this.forEach(player -> player.connect(server)));
    }

    @Override
    public void connectToTask(@NonNull String task, @NonNull ServerSelectorType selectorType) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().filter(service -> service.serviceId().taskName().equals(task)).sorted(selectorType.comparator()).map(service -> this.proxyServer.getServerInfo(service.name())).filter(Objects::nonNull).findFirst().ifPresent(server -> this.forEach(player -> player.connect(server)));
    }

    @Override
    public void kick(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> player.disconnect(ComponentFormats.ADVENTURE_TO_BUNGEE.convertText(LegacyComponentSerializer.legacySection().serialize(message))));
    }

    @Override
    public void sendChatMessage(@NonNull Component message, @Nullable String permission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> {
            if (permission == null || player.hasPermission(permission)) {
                player.sendMessage(ComponentFormats.ADVENTURE_TO_BUNGEE.convertText(LegacyComponentSerializer.legacySection().serialize(message)));
            }
        });
    }

    @Override
    public void sendPluginMessage(@NonNull String key, byte[] data) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
    }

    @Override
    public void spoofCommandExecution(@NonNull String command, boolean redirectToServer) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.forEach(player -> {
            if (!this.proxyServer.dispatchCommand((CommandSender)player, command) && redirectToServer) {
                player.chat("/" + command);
            }
        });
    }
}

