/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.waterdog;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.command.Command;
import dev.waterdog.waterdogpe.utils.types.IForcedHostHandler;
import dev.waterdog.waterdogpe.utils.types.IReconnectHandler;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import eu.cloudnetservice.modules.bridge.platform.waterdog.WaterDogPEBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.waterdog.WaterDogPEHandlers;
import eu.cloudnetservice.modules.bridge.platform.waterdog.WaterDogPEPlayerManagementListener;
import eu.cloudnetservice.modules.bridge.platform.waterdog.command.WaterDogPECloudCommand;
import eu.cloudnetservice.modules.bridge.platform.waterdog.command.WaterDogPEHubCommand;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import lombok.NonNull;

@Singleton
@PlatformPlugin(platform="waterdog", name="CloudNet-Bridge", version="4.0.0-RC11", description="Bridges service software support between all supported versions for easy CloudNet plugin development", authors={"CloudNetService"})
public final class WaterDogPEBridgePlugin
implements PlatformEntrypoint {
    private final ProxyServer proxyServer;
    private final ModuleHelper moduleHelper;
    private final ServiceRegistry serviceRegistry;
    private final WaterDogPECloudCommand cloudCommand;
    private final WaterDogPEBridgeManagement bridgeManagement;

    @Inject
    public WaterDogPEBridgePlugin(@NonNull ProxyServer proxyServer, @NonNull ModuleHelper moduleHelper, @NonNull ServiceRegistry serviceRegistry, @NonNull WaterDogPECloudCommand cloudCommand, @NonNull WaterDogPEBridgeManagement bridgeManagement, @NonNull WaterDogPEPlayerManagementListener managementListener) {
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (cloudCommand == null) {
            throw new NullPointerException("cloudCommand is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (managementListener == null) {
            throw new NullPointerException("managementListener is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.moduleHelper = moduleHelper;
        this.serviceRegistry = serviceRegistry;
        this.cloudCommand = cloudCommand;
        this.bridgeManagement = bridgeManagement;
    }

    @Override
    public void onLoad() {
        this.bridgeManagement.registerServices(this.serviceRegistry);
        this.bridgeManagement.postInit();
        WaterDogPEHandlers handlers = new WaterDogPEHandlers(this.proxyServer, this.bridgeManagement);
        this.proxyServer.setReconnectHandler((IReconnectHandler)handlers);
        this.proxyServer.setForcedHostHandler((IForcedHostHandler)handlers);
        this.proxyServer.getCommandMap().registerCommand((Command)this.cloudCommand);
        if (!this.bridgeManagement.configuration().hubCommandNames().isEmpty()) {
            String[] names = this.bridgeManagement.configuration().hubCommandNames().toArray(new String[0]);
            this.proxyServer.getCommandMap().registerCommand((Command)new WaterDogPEHubCommand(this.bridgeManagement, this.proxyServer, names[0], names.length > 1 ? Arrays.copyOfRange(names, 1, names.length) : new String[]{}));
        }
    }

    @Override
    public void onDisable() {
        this.moduleHelper.unregisterAll(this.getClass().getClassLoader());
    }
}

