/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.waterdog;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.WaterdogPE;
import dev.waterdog.waterdogpe.command.CommandSender;
import dev.waterdog.waterdogpe.network.serverinfo.BedrockServerInfo;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ProvidesFor;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.waterdog.WaterDogPEDirectPlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.util.BridgeHostAndPortUtil;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@ProvidesFor(platform="waterdog", types={PlatformBridgeManagement.class, BridgeManagement.class})
final class WaterDogPEBridgeManagement
extends PlatformBridgeManagement<ProxiedPlayer, NetworkPlayerProxyInfo> {
    private static final BiFunction<ProxiedPlayer, String, Boolean> PERM_FUNCTION = CommandSender::hasPermission;
    private final ProxyServer proxyServer;
    private final PlayerExecutor globalDirectPlayerExecutor;

    @Inject
    public WaterDogPEBridgeManagement(@NonNull RPCFactory rpcFactory, @NonNull ProxyServer proxyServer, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfiguration) {
        super(rpcFactory, eventManager, networkClient, taskProvider, serviceHelper, serviceInfoHolder, serviceProvider, wrapperConfiguration);
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.globalDirectPlayerExecutor = new WaterDogPEDirectPlayerExecutor(PlayerExecutor.GLOBAL_UNIQUE_ID, this.proxyServer, this, this.proxyServer.getPlayers()::values);
        serviceHelper.motd().set(this.proxyServer.getConfiguration().getMotd());
        serviceHelper.maxPlayers().set(this.proxyServer.getConfiguration().getMaxPlayerCount());
        this.cacheTester = CONNECTED_SERVICE_TESTER.and(service -> service.serviceId().environment().readProperty(ServiceEnvironmentType.PE_SERVER));
        this.cacheRegisterListener = service -> this.proxyServer.getServerInfoMap().put(service.name(), (ServerInfo)new BedrockServerInfo(service.name(), new InetSocketAddress(service.address().host(), service.address().port()), new InetSocketAddress(service.address().host(), service.address().port())));
        this.cacheUnregisterListener = service -> this.proxyServer.getServerInfoMap().remove(service.name());
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(PlayerManager.class, "PlayerManager", this.playerManager);
        registry.registerProvider(PlatformBridgeManagement.class, "WaterDogPEBridgeManagement", this);
    }

    @Override
    @NonNull
    public ServicePlayer wrapPlayer(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new ServicePlayer(player.getUniqueId(), player.getName());
    }

    @Override
    @NonNull
    public NetworkPlayerProxyInfo createPlayerInformation(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new NetworkPlayerProxyInfo(player.getUniqueId(), player.getName(), player.getXuid(), player.getProtocol().getRaknetVersion(), BridgeHostAndPortUtil.fromSocketAddress(player.getAddress()), BridgeHostAndPortUtil.fromSocketAddress(this.proxyServer.getConfiguration().getBindAddress()), player.getLoginData().isXboxAuthed(), this.ownNetworkServiceInfo);
    }

    @Override
    @NonNull
    public BiFunction<ProxiedPlayer, String, Boolean> permissionFunction() {
        return PERM_FUNCTION;
    }

    @Override
    public boolean isOnAnyFallbackInstance(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.isOnAnyFallbackInstance(player.getServerInfo() == null ? null : player.getServerInfo().getServerName(), player.getLoginData().getJoinHostname(), arg_0 -> ((ProxiedPlayer)player).hasPermission(arg_0));
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player, player.getServerInfo() == null ? null : player.getServerInfo().getServerName());
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull ProxiedPlayer player, @Nullable String currServer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player.getUniqueId(), currServer, player.getLoginData().getJoinHostname(), arg_0 -> ((ProxiedPlayer)player).hasPermission(arg_0));
    }

    @Override
    public void handleFallbackConnectionSuccess(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.handleFallbackConnectionSuccess(player.getUniqueId());
    }

    @Override
    public void removeFallbackProfile(@NonNull ProxiedPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.removeFallbackProfile(player.getUniqueId());
    }

    @Override
    @NonNull
    public PlayerExecutor directPlayerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return uniqueId.equals(PlayerExecutor.GLOBAL_UNIQUE_ID) ? this.globalDirectPlayerExecutor : new WaterDogPEDirectPlayerExecutor(uniqueId, this.proxyServer, this, () -> Collections.singleton(this.proxyServer.getPlayer(uniqueId)));
    }

    @Override
    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        super.appendServiceInformation(configureEvent);
        configureEvent.propertyHolder().append("Online-Count", this.proxyServer.getPlayers().size());
        configureEvent.propertyHolder().append("Version", WaterdogPE.version().baseVersion());
        configureEvent.propertyHolder().append("Players", this.proxyServer.getPlayers().values().stream().map(this::createPlayerInformation).toList());
    }
}

