/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import java.util.List;
import lombok.NonNull;

public final class VelocityHubCommand
implements SimpleCommand {
    private final ProxyServer proxyServer;
    private final PlatformBridgeManagement<Player, ?> management;

    public VelocityHubCommand(@NonNull ProxyServer server, @NonNull PlatformBridgeManagement<Player, ?> management) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.proxyServer = server;
        this.management = management;
    }

    public void execute(@NonNull SimpleCommand.Invocation invocation) {
        if (invocation == null) {
            throw new NullPointerException("invocation is marked non-null but is null");
        }
        CommandSource commandSource = invocation.source();
        if (commandSource instanceof Player) {
            Player player = (Player)commandSource;
            if (this.management.isOnAnyFallbackInstance(player)) {
                this.management.configuration().handleMessage(player.getEffectiveLocale(), "command-hub-already-in-hub", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, arg_0 -> player.sendMessage(arg_0));
            } else {
                RegisteredServer hub = this.management.fallback(player).flatMap(service -> this.proxyServer.getServer(service.name())).orElse(null);
                if (hub != null) {
                    player.createConnectionRequest(hub).connectWithIndication().whenComplete((result, ex) -> {
                        if (result.booleanValue() && ex == null) {
                            this.management.configuration().handleMessage(player.getEffectiveLocale(), "command-hub-success-connect", message -> ComponentFormats.BUNGEE_TO_ADVENTURE.convert(message.replace("%server%", hub.getServerInfo().getName())), arg_0 -> player.sendMessage(arg_0));
                        } else {
                            this.management.configuration().handleMessage(player.getEffectiveLocale(), "command-hub-no-server-found", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, arg_0 -> player.sendMessage(arg_0));
                        }
                    });
                }
            }
        }
    }

    @NonNull
    public List<String> suggest(@NonNull SimpleCommand.Invocation invocation) {
        if (invocation == null) {
            throw new NullPointerException("invocation is marked non-null but is null");
        }
        return List.copyOf(this.management.configuration().hubCommandNames());
    }
}

