/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import eu.cloudnetservice.driver.command.CommandInfo;
import eu.cloudnetservice.driver.provider.ClusterNodeProvider;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.config.BridgeConfiguration;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

@Singleton
public final class VelocityCloudCommand
implements SimpleCommand {
    private final ClusterNodeProvider clusterNodeProvider;
    private final PlatformBridgeManagement<?, ?> management;

    @Inject
    public VelocityCloudCommand(@NonNull ClusterNodeProvider clusterNodeProvider, @NonNull PlatformBridgeManagement<?, ?> management) {
        if (clusterNodeProvider == null) {
            throw new NullPointerException("clusterNodeProvider is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.clusterNodeProvider = clusterNodeProvider;
        this.management = management;
    }

    public void execute(@NonNull SimpleCommand.Invocation invocation) {
        if (invocation == null) {
            throw new NullPointerException("invocation is marked non-null but is null");
        }
        CharSequence[] arguments = (String[])invocation.arguments();
        if (arguments.length == 0) {
            invocation.source().sendMessage(ComponentFormats.BUNGEE_TO_ADVENTURE.convert(this.management.configuration().prefix() + "/cloudnet <command>"));
            return;
        }
        String commandLine = String.join((CharSequence)" ", arguments);
        if (invocation.source() instanceof ConsoleCommandSource) {
            this.executeNow(invocation.source(), commandLine);
        } else {
            this.clusterNodeProvider.consoleCommandAsync((String)arguments[0]).thenAcceptAsync(arg_0 -> this.lambda$execute$1(invocation, (String[])arguments, commandLine, arg_0));
        }
    }

    private void executeNow(@NonNull CommandSource source, @NonNull String commandLine) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        for (String output : this.clusterNodeProvider.sendCommandLine(commandLine)) {
            source.sendMessage(ComponentFormats.BUNGEE_TO_ADVENTURE.convert(this.management.configuration().prefix() + output));
        }
    }

    @NonNull
    public CompletableFuture<List<String>> suggestAsync(@NonNull SimpleCommand.Invocation invocation) {
        if (invocation == null) {
            throw new NullPointerException("invocation is marked non-null but is null");
        }
        return this.clusterNodeProvider.consoleTabCompleteResultsAsync(String.join((CharSequence)" ", (CharSequence[])invocation.arguments())).thenApply(List::copyOf);
    }

    public boolean hasPermission(@NonNull SimpleCommand.Invocation invocation) {
        if (invocation == null) {
            throw new NullPointerException("invocation is marked non-null but is null");
        }
        return invocation.source().hasPermission("cloudnet.command.cloudnet");
    }

    private /* synthetic */ void lambda$execute$1(SimpleCommand.Invocation invocation, String[] arguments, String commandLine, CommandInfo info) {
        if (info == null || !invocation.source().hasPermission(info.permission())) {
            Locale locale;
            BridgeConfiguration bridgeConfiguration = this.management.configuration();
            CommandSource patt0$temp = invocation.source();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                locale = player.getEffectiveLocale();
            } else {
                locale = Locale.ENGLISH;
            }
            bridgeConfiguration.handleMessage(locale, "command-cloud-sub-command-no-permission", message -> ComponentFormats.BUNGEE_TO_ADVENTURE.convert(message.replace("%command%", arguments[0])), arg_0 -> invocation.source().sendMessage(arg_0));
        } else {
            this.executeNow(invocation.source(), commandLine);
        }
    }
}

