/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.velocity;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.node.event.LocalPlayerPreLoginEvent;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.helper.ProxyPlatformHelper;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Locale;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;

@Singleton
public final class VelocityPlayerManagementListener {
    private final ProxyServer proxyServer;
    private final ServiceInfoHolder serviceInfoHolder;
    private final ProxyPlatformHelper proxyPlatformHelper;
    private final PlatformBridgeManagement<Player, NetworkPlayerProxyInfo> management;

    @Inject
    public VelocityPlayerManagementListener(@NonNull ProxyServer proxyServer, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull ProxyPlatformHelper proxyPlatformHelper, @NonNull PlatformBridgeManagement<Player, NetworkPlayerProxyInfo> management) {
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (proxyPlatformHelper == null) {
            throw new NullPointerException("proxyPlatformHelper is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.serviceInfoHolder = serviceInfoHolder;
        this.proxyPlatformHelper = proxyPlatformHelper;
        this.management = management;
    }

    @Subscribe
    public void handleLogin(@NonNull LoginEvent event) {
        LocalPlayerPreLoginEvent.Result loginResult;
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        ServiceTask task = this.management.selfTask();
        if (task != null) {
            if (task.maintenance() && !event.getPlayer().hasPermission("cloudnet.bridge.maintenance")) {
                this.management.configuration().handleMessage(Locale.ENGLISH, "proxy-join-cancel-because-maintenance", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, component -> event.setResult(ResultedEvent.ComponentResult.denied((Component)component)));
                return;
            }
            String permission = task.propertyHolder().getString("requiredPermission");
            if (permission != null && !event.getPlayer().hasPermission(permission)) {
                this.management.configuration().handleMessage(Locale.ENGLISH, "proxy-join-cancel-because-permission", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, component -> event.setResult(ResultedEvent.ComponentResult.denied((Component)component)));
                return;
            }
        }
        if (!(loginResult = this.proxyPlatformHelper.sendChannelMessagePreLogin(this.management.createPlayerInformation(event.getPlayer()))).permitLogin()) {
            event.setResult(ResultedEvent.ComponentResult.denied((Component)loginResult.result()));
        }
    }

    @Subscribe(order=PostOrder.FIRST)
    public void handleInitialServerChoose(@NonNull PlayerChooseInitialServerEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        event.setInitialServer((RegisteredServer)this.management.fallback(event.getPlayer()).flatMap(service -> this.proxyServer.getServer(service.name())).orElse(null));
    }

    @Subscribe(order=PostOrder.FIRST)
    public void handleServerKick(@NonNull KickedFromServerEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.getPlayer().isActive()) {
            event.setResult(this.management.fallback(event.getPlayer(), event.getServer().getServerInfo().getName()).flatMap(service -> this.proxyServer.getServer(service.name())).map(server -> {
                ServerInfo curServer = event.getPlayer().getCurrentServer().map(ServerConnection::getServerInfo).orElse(null);
                if (event.kickedDuringServerConnect() && curServer != null && curServer.equals((Object)server.getServerInfo())) {
                    this.management.handleFallbackConnectionSuccess(event.getPlayer());
                    return KickedFromServerEvent.Notify.create((Component)this.extractReasonComponent(event));
                }
                return KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)server, (Component)this.extractReasonComponent(event));
            }).orElse((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)this.management.configuration().findMessage(event.getPlayer().getEffectiveLocale(), "proxy-join-disconnect-because-no-hub", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, Component.empty(), true))));
        }
    }

    @Subscribe
    public void handleServiceConnected(@NonNull ServerPostConnectEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        NetworkServiceInfo joinedServiceInfo = event.getPlayer().getCurrentServer().flatMap(server -> this.management.cachedService(service -> server.getServerInfo().getName().equals(service.name())).map(NetworkServiceInfo::fromServiceInfoSnapshot)).orElse(null);
        if (event.getPreviousServer() == null) {
            this.proxyPlatformHelper.sendChannelMessageLoginSuccess(this.management.createPlayerInformation(event.getPlayer()), joinedServiceInfo);
            this.serviceInfoHolder.publishServiceInfoUpdate();
        } else if (joinedServiceInfo != null) {
            this.proxyPlatformHelper.sendChannelMessageServiceSwitch(event.getPlayer().getUniqueId(), joinedServiceInfo);
        }
        this.management.handleFallbackConnectionSuccess(event.getPlayer());
    }

    @Subscribe
    public void handleDisconnect(@NonNull DisconnectEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        DisconnectEvent.LoginStatus status = event.getLoginStatus();
        if (status == DisconnectEvent.LoginStatus.SUCCESSFUL_LOGIN || status == DisconnectEvent.LoginStatus.PRE_SERVER_JOIN) {
            this.proxyPlatformHelper.sendChannelMessageDisconnected(event.getPlayer().getUniqueId());
            this.serviceInfoHolder.publishServiceInfoUpdate();
        }
        this.management.removeFallbackProfile(event.getPlayer());
    }

    @NonNull
    private Component extractReasonComponent(@NonNull KickedFromServerEvent event) {
        KickedFromServerEvent.ServerKickResult serverKickResult;
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        Locale playerLocale = event.getPlayer().getEffectiveLocale();
        Component message = event.getServerKickReason().orElse(null);
        if (message == null && (serverKickResult = event.getResult()) instanceof KickedFromServerEvent.Notify) {
            KickedFromServerEvent.Notify notify = (KickedFromServerEvent.Notify)serverKickResult;
            message = notify.getMessageComponent();
        }
        if (message != null) {
            if (message instanceof TranslatableComponent) {
                message = GlobalTranslator.render(message, playerLocale == null ? Locale.getDefault() : playerLocale);
            }
            if (message instanceof TextComponent) {
                TextComponent textComponent = (TextComponent)message;
                return this.management.configuration().findMessage(playerLocale, "error-connecting-to-server", rawMessage -> ComponentFormats.BUNGEE_TO_ADVENTURE.convert(rawMessage.replace("%server%", event.getServer().getServerInfo().getName()).replace("%reason%", LegacyComponentSerializer.legacySection().serialize(textComponent))), Component.empty(), true);
            }
        }
        return this.management.configuration().findMessage(playerLocale, "error-connecting-to-server", rawMessage -> ComponentFormats.BUNGEE_TO_ADVENTURE.convert(rawMessage.replace("%server%", event.getServer().getServerInfo().getName()).replace("%reason%", "\u00a7cUnknown")), Component.empty(), true);
    }
}

