/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import eu.cloudnetservice.common.tuple.Tuple2;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerExecutorAdapter;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.Nullable;

final class VelocityDirectPlayerExecutor
extends PlatformPlayerExecutorAdapter<Player> {
    private final ProxyServer proxyServer;
    private final PlatformBridgeManagement<Player, ?> management;

    public VelocityDirectPlayerExecutor(@NonNull UUID uniqueId, @NonNull ProxyServer proxyServer, @NonNull PlatformBridgeManagement<Player, ?> management, @NonNull Supplier<Collection<? extends Player>> playerSupplier) {
        super(uniqueId, playerSupplier);
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        if (playerSupplier == null) {
            throw new NullPointerException("playerSupplier is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.management = management;
    }

    @Override
    public void connect(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.proxyServer.getServer(serviceName).ifPresent(server -> this.forEach(player -> player.createConnectionRequest(server).fireAndForget()));
    }

    @Override
    public void connectSelecting(@NonNull ServerSelectorType selectorType) {
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().sorted(selectorType.comparator()).map(server -> this.proxyServer.getServer(server.name())).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(server -> this.forEach(player -> player.createConnectionRequest(server).fireAndForget()));
    }

    @Override
    public void connectToFallback() {
        ((Collection)this.playerSupplier.get()).stream().filter(Objects::nonNull).map(player -> new Tuple2<Player, Optional<ServiceInfoSnapshot>>((Player)player, this.management.fallback((Player)player))).filter(pair -> ((Optional)pair.second()).isPresent()).map(pair -> new Tuple2<Player, Optional>((Player)pair.first(), this.proxyServer.getServer(((ServiceInfoSnapshot)((Optional)pair.second()).get()).name()))).filter(pair -> ((Optional)pair.second()).isPresent()).findFirst().ifPresent(pair -> ((Player)pair.first()).createConnectionRequest((RegisteredServer)((Optional)pair.second()).get()).fireAndForget());
    }

    @Override
    public void connectToGroup(@NonNull String group, @NonNull ServerSelectorType selectorType) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().filter(service -> service.configuration().groups().contains(group)).sorted(selectorType.comparator()).map(service -> this.proxyServer.getServer(service.name())).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(server -> this.forEach(player -> player.createConnectionRequest(server).fireAndForget()));
    }

    @Override
    public void connectToTask(@NonNull String task, @NonNull ServerSelectorType selectorType) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
        this.management.cachedServices().stream().filter(service -> service.serviceId().taskName().equals(task)).sorted(selectorType.comparator()).map(service -> this.proxyServer.getServer(service.name())).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(server -> this.forEach(player -> player.createConnectionRequest(server).fireAndForget()));
    }

    @Override
    public void kick(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> player.disconnect(message));
    }

    @Override
    public void sendTitle(@NonNull Title title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.forEach(player -> player.showTitle(title));
    }

    @Override
    public void sendChatMessage(@NonNull Component message, @Nullable String permission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> {
            if (permission == null || player.hasPermission(permission)) {
                player.sendMessage(message);
            }
        });
    }

    @Override
    public void sendPluginMessage(@NonNull String key, byte[] data) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.forEach(player -> player.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)key), data));
    }

    @Override
    public void spoofCommandExecution(@NonNull String command, boolean redirectToServer) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.forEach(player -> this.proxyServer.getCommandManager().executeAsync((CommandSource)player, command).thenAccept(success -> {
            if (!success.booleanValue() && redirectToServer) {
                player.spoofChatInput("/" + command);
            }
        }));
    }
}

