/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.velocity;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.proxy.ProxyServer;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import eu.cloudnetservice.modules.bridge.platform.velocity.VelocityBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.velocity.VelocityPlayerManagementListener;
import eu.cloudnetservice.modules.bridge.platform.velocity.commands.VelocityCloudCommand;
import eu.cloudnetservice.modules.bridge.platform.velocity.commands.VelocityHubCommand;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Arrays;
import lombok.NonNull;

@Singleton
@PlatformPlugin(platform="velocity", name="CloudNet-Bridge", version="4.0.0-RC11", description="Bridges service software support between all supported versions for easy CloudNet plugin development", authors={"CloudNetService"})
public final class VelocityBridgePlugin
implements PlatformEntrypoint {
    private final ProxyServer proxy;
    private final Object pluginInstance;
    private final ModuleHelper moduleHelper;
    private final ServiceRegistry serviceRegistry;
    private final VelocityCloudCommand cloudCommand;
    private final VelocityBridgeManagement bridgeManagement;
    private final VelocityPlayerManagementListener playerListener;

    @Inject
    public VelocityBridgePlugin(@Named(value="plugin") @NonNull Object pluginInstance, @NonNull ProxyServer proxyServer, @NonNull ModuleHelper moduleHelper, @NonNull ServiceRegistry serviceRegistry, @NonNull VelocityCloudCommand cloudCommand, @NonNull VelocityBridgeManagement bridgeManagement, @NonNull VelocityPlayerManagementListener playerListener) {
        if (pluginInstance == null) {
            throw new NullPointerException("pluginInstance is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (cloudCommand == null) {
            throw new NullPointerException("cloudCommand is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (playerListener == null) {
            throw new NullPointerException("playerListener is marked non-null but is null");
        }
        this.pluginInstance = pluginInstance;
        this.proxy = proxyServer;
        this.moduleHelper = moduleHelper;
        this.serviceRegistry = serviceRegistry;
        this.cloudCommand = cloudCommand;
        this.bridgeManagement = bridgeManagement;
        this.playerListener = playerListener;
    }

    @Override
    public void onLoad() {
        this.bridgeManagement.registerServices(this.serviceRegistry);
        this.bridgeManagement.postInit();
        this.proxy.getEventManager().register(this.pluginInstance, (Object)this.playerListener);
        this.proxy.getCommandManager().register("cloudnet", (Command)this.cloudCommand, new String[]{"cloud"});
        if (!this.bridgeManagement.configuration().hubCommandNames().isEmpty()) {
            String[] names = this.bridgeManagement.configuration().hubCommandNames().toArray(new String[0]);
            this.proxy.getCommandManager().register(names[0], (Command)new VelocityHubCommand(this.proxy, this.bridgeManagement), names.length > 1 ? Arrays.copyOfRange(names, 1, names.length) : new String[]{});
        }
    }

    @Override
    public void onDisable() {
        this.moduleHelper.unregisterAll(this.getClass().getClassLoader());
    }
}

