/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.velocity;

import com.velocitypowered.api.permission.PermissionSubject;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ProvidesFor;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.velocity.VelocityDirectPlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerProxyInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.util.BridgeHostAndPortUtil;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.NonNull;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.Nullable;

@Singleton
@ProvidesFor(platform="velocity", types={PlatformBridgeManagement.class, BridgeManagement.class})
final class VelocityBridgeManagement
extends PlatformBridgeManagement<Player, NetworkPlayerProxyInfo> {
    private static final BiFunction<Player, String, Boolean> PERM_FUNCTION = PermissionSubject::hasPermission;
    private final ProxyServer proxyServer;
    private final PlayerExecutor globalDirectPlayerExecutor;

    @Inject
    public VelocityBridgeManagement(@NonNull RPCFactory rpcFactory, @NonNull ProxyServer proxyServer, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfiguration) {
        super(rpcFactory, eventManager, networkClient, taskProvider, serviceHelper, serviceInfoHolder, serviceProvider, wrapperConfiguration);
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        this.proxyServer = proxyServer;
        this.globalDirectPlayerExecutor = new VelocityDirectPlayerExecutor(PlayerExecutor.GLOBAL_UNIQUE_ID, proxyServer, this, () -> ((ProxyServer)proxyServer).getAllPlayers());
        serviceHelper.motd().set(LegacyComponentSerializer.legacySection().serialize(proxyServer.getConfiguration().getMotd()));
        serviceHelper.maxPlayers().set(proxyServer.getConfiguration().getShowMaxPlayers());
        this.cacheTester = CONNECTED_SERVICE_TESTER.and(service -> service.serviceId().environment().readProperty(ServiceEnvironmentType.JAVA_SERVER));
        this.cacheRegisterListener = service -> proxyServer.registerServer(new ServerInfo(service.name(), new InetSocketAddress(service.address().host(), service.address().port())));
        this.cacheUnregisterListener = service -> proxyServer.getServer(service.name()).map(RegisteredServer::getServerInfo).ifPresent(arg_0 -> ((ProxyServer)proxyServer).unregisterServer(arg_0));
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(PlayerManager.class, "PlayerManager", this.playerManager);
        registry.registerProvider(PlatformBridgeManagement.class, "VelocityBridgeManagement", this);
    }

    @Override
    @NonNull
    public ServicePlayer wrapPlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new ServicePlayer(player.getUniqueId(), player.getUsername());
    }

    @Override
    @NonNull
    public NetworkPlayerProxyInfo createPlayerInformation(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new NetworkPlayerProxyInfo(player.getUniqueId(), player.getUsername(), null, player.getProtocolVersion().getProtocol(), BridgeHostAndPortUtil.fromSocketAddress(player.getRemoteAddress()), BridgeHostAndPortUtil.fromSocketAddress(this.proxyServer.getBoundAddress()), player.isOnlineMode(), this.ownNetworkServiceInfo);
    }

    @Override
    @NonNull
    public BiFunction<Player, String, Boolean> permissionFunction() {
        return PERM_FUNCTION;
    }

    @Override
    public boolean isOnAnyFallbackInstance(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.isOnAnyFallbackInstance(player.getCurrentServer().map(connection -> connection.getServerInfo().getName()).orElse(null), player.getVirtualHost().map(InetSocketAddress::getHostString).orElse(null), arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player, (String)player.getCurrentServer().map(connection -> connection.getServerInfo().getName()).orElse(null));
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull Player player, @Nullable String currServer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player.getUniqueId(), currServer, player.getVirtualHost().map(InetSocketAddress::getHostString).orElse(null), arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    @Override
    public void handleFallbackConnectionSuccess(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.handleFallbackConnectionSuccess(player.getUniqueId());
    }

    @Override
    public void removeFallbackProfile(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.removeFallbackProfile(player.getUniqueId());
    }

    @Override
    @NonNull
    public PlayerExecutor directPlayerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return uniqueId.equals(PlayerExecutor.GLOBAL_UNIQUE_ID) ? this.globalDirectPlayerExecutor : new VelocityDirectPlayerExecutor(uniqueId, this.proxyServer, this, () -> Collections.singleton(this.proxyServer.getPlayer(uniqueId).orElse(null)));
    }

    @Override
    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        super.appendServiceInformation(configureEvent);
        configureEvent.propertyHolder().append("Online-Count", this.proxyServer.getPlayerCount());
        configureEvent.propertyHolder().append("Version", this.proxyServer.getVersion().getVersion());
        configureEvent.propertyHolder().append("Players", this.proxyServer.getAllPlayers().stream().map(this::createPlayerInformation).toList());
    }
}

