/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.sponge;

import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.helper.ServerPlatformHelper;
import eu.cloudnetservice.modules.bridge.platform.sponge.SpongeBridgeManagement;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.TaskExecutorService;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongePlayerManagementListener {
    private final ServiceInfoHolder serviceInfoHolder;
    private final TaskExecutorService executorService;
    private final ServerPlatformHelper serverPlatformHelper;
    private final PlatformBridgeManagement<ServerPlayer, NetworkPlayerServerInfo> management;

    @Inject
    public SpongePlayerManagementListener(@NonNull PluginContainer plugin, @Named(value="sync") @NonNull Scheduler scheduler, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull ServerPlatformHelper serverPlatformHelper, @NonNull SpongeBridgeManagement management) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serverPlatformHelper == null) {
            throw new NullPointerException("serverPlatformHelper is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.serviceInfoHolder = serviceInfoHolder;
        this.serverPlatformHelper = serverPlatformHelper;
        this.management = management;
        this.executorService = scheduler.executor(plugin);
    }

    @Listener
    public void handle(@NonNull ServerSideConnectionEvent.Login event, @First @NonNull User user) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        ServiceTask task = this.management.selfTask();
        if (task != null) {
            if (task.maintenance() && !user.hasPermission("cloudnet.bridge.maintenance")) {
                event.setCancelled(true);
                this.management.configuration().handleMessage(Locale.ENGLISH, "server-join-cancel-because-maintenance", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, arg_0 -> ((ServerSideConnectionEvent.Login)event).setMessage(arg_0));
                return;
            }
            String permission = task.propertyHolder().getString("requiredPermission");
            if (permission != null && !user.hasPermission(permission)) {
                event.setCancelled(true);
                this.management.configuration().handleMessage(Locale.ENGLISH, "server-join-cancel-because-permission", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, arg_0 -> ((ServerSideConnectionEvent.Login)event).setMessage(arg_0));
            }
        }
    }

    @Listener
    public void handle(@NonNull ServerSideConnectionEvent.Join event, @First @NonNull ServerPlayer player) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.serverPlatformHelper.sendChannelMessageLoginSuccess(player.uniqueId(), this.management.createPlayerInformation(player));
        this.executorService.schedule(() -> this.serviceInfoHolder.publishServiceInfoUpdate(), 50L, TimeUnit.MILLISECONDS);
    }

    @Listener
    public void handle(@NonNull ServerSideConnectionEvent.Disconnect event, @First @NonNull ServerPlayer player) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.serverPlatformHelper.sendChannelMessageDisconnected(player.uniqueId(), this.management.ownNetworkServiceInfo());
        this.executorService.schedule(() -> this.serviceInfoHolder.publishServiceInfoUpdate(), 50L, TimeUnit.MILLISECONDS);
    }
}

