/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.sponge;

import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerExecutorAdapter;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.channel.ChannelManager;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataChannel;
import org.spongepowered.api.service.permission.Subject;

final class SpongeDirectPlayerExecutor
extends PlatformPlayerExecutorAdapter<ServerPlayer> {
    private final ChannelManager channelManager;
    private final CommandManager commandManager;

    public SpongeDirectPlayerExecutor(@NonNull ChannelManager channelManager, @NonNull CommandManager commandManager, @NonNull UUID targetUniqueId, @NonNull Supplier<Collection<? extends ServerPlayer>> playerSupplier) {
        super(targetUniqueId, playerSupplier);
        if (channelManager == null) {
            throw new NullPointerException("channelManager is marked non-null but is null");
        }
        if (commandManager == null) {
            throw new NullPointerException("commandManager is marked non-null but is null");
        }
        if (targetUniqueId == null) {
            throw new NullPointerException("targetUniqueId is marked non-null but is null");
        }
        if (playerSupplier == null) {
            throw new NullPointerException("playerSupplier is marked non-null but is null");
        }
        this.channelManager = channelManager;
        this.commandManager = commandManager;
    }

    @Override
    public void connect(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
    }

    @Override
    public void connectSelecting(@NonNull ServerSelectorType selectorType) {
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void connectToFallback() {
    }

    @Override
    public void connectToGroup(@NonNull String group, @NonNull ServerSelectorType selectorType) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void connectToTask(@NonNull String task, @NonNull ServerSelectorType selectorType) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void kick(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> player.kick(message));
    }

    @Override
    public void sendTitle(@NonNull Title title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.forEach(player -> player.showTitle(title));
    }

    @Override
    public void sendChatMessage(@NonNull Component message, @Nullable String permission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> {
            if (permission == null || player.hasPermission(permission)) {
                player.sendMessage(message);
            }
        });
    }

    @Override
    public void sendPluginMessage(@NonNull String key, byte[] data) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        RawPlayDataChannel playChannel = ((RawDataChannel)this.channelManager.ofType(ResourceKey.resolve((String)key), RawDataChannel.class)).play();
        this.forEach(player -> playChannel.sendTo(player, buffer -> buffer.writeByteArray(data)));
    }

    @Override
    public void spoofCommandExecution(@NonNull String command, boolean redirectToServer) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.forEach(player -> {
            try {
                this.commandManager.process((Subject)player, command);
            }
            catch (CommandException commandException) {
                // empty catch block
            }
        });
    }
}

