/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.sponge;

import com.google.inject.Singleton;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.stereotype.Dependency;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import eu.cloudnetservice.modules.bridge.platform.sponge.SpongeBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.sponge.SpongePlayerManagementListener;
import jakarta.inject.Inject;
import lombok.NonNull;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.plugin.PluginContainer;

@Singleton
@PlatformPlugin(platform="sponge", name="CloudNet-Bridge", version="4.0.0-RC11", description="Bridges service software support between all supported versions for easy CloudNet plugin development", authors={"CloudNetService"}, dependencies={@Dependency(name="spongeapi", version="[8.0.0,)")})
public final class SpongeBridgePlugin
implements PlatformEntrypoint {
    private final PluginContainer plugin;
    private final EventManager eventManager;
    private final ModuleHelper moduleHelper;
    private final ServiceRegistry serviceRegistry;
    private final SpongeBridgeManagement bridgeManagement;
    private final SpongePlayerManagementListener playerListener;

    @Inject
    public SpongeBridgePlugin(@NonNull PluginContainer plugin, @NonNull EventManager eventManager, @NonNull ModuleHelper moduleHelper, @NonNull ServiceRegistry serviceRegistry, @NonNull SpongeBridgeManagement bridgeManagement, @NonNull SpongePlayerManagementListener playerListener) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (playerListener == null) {
            throw new NullPointerException("playerListener is marked non-null but is null");
        }
        this.plugin = plugin;
        this.eventManager = eventManager;
        this.moduleHelper = moduleHelper;
        this.serviceRegistry = serviceRegistry;
        this.bridgeManagement = bridgeManagement;
        this.playerListener = playerListener;
    }

    @Override
    public void onLoad() {
        this.bridgeManagement.registerServices(this.serviceRegistry);
        this.bridgeManagement.postInit();
        this.eventManager.registerListeners(this.plugin, (Object)this.playerListener);
    }

    @Override
    public void onDisable() {
        this.moduleHelper.unregisterAll(this.getClass().getClassLoader());
    }
}

