/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.sponge;

import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ProvidesFor;
import eu.cloudnetservice.modules.bridge.BridgeManagement;
import eu.cloudnetservice.modules.bridge.BridgeServiceHelper;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.sponge.SpongeAddressAccessor;
import eu.cloudnetservice.modules.bridge.platform.sponge.SpongeDirectPlayerExecutor;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.ServicePlayer;
import eu.cloudnetservice.modules.bridge.player.executor.PlayerExecutor;
import eu.cloudnetservice.modules.bridge.util.BridgeHostAndPortUtil;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.NonNull;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Server;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.channel.ChannelManager;
import org.spongepowered.api.service.permission.Subject;

@Singleton
@ProvidesFor(platform="sponge", types={PlatformBridgeManagement.class, BridgeManagement.class})
final class SpongeBridgeManagement
extends PlatformBridgeManagement<ServerPlayer, NetworkPlayerServerInfo> {
    private static final BiFunction<ServerPlayer, String, Boolean> PERM_FUNCTION = Subject::hasPermission;
    private final Server server;
    private final Platform platform;
    private final CommandManager commandManager;
    private final ChannelManager channelManager;
    private final PlayerExecutor directGlobalExecutor;
    private final SpongeAddressAccessor spongeAddressAccessor;

    @Inject
    public SpongeBridgeManagement(@NonNull Server server, @NonNull Platform platform, @NonNull RPCFactory rpcFactory, @NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull ChannelManager channelManager, @NonNull CommandManager commandManager, @NonNull ServiceTaskProvider taskProvider, @NonNull BridgeServiceHelper serviceHelper, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull CloudServiceProvider serviceProvider, @NonNull WrapperConfiguration wrapperConfiguration, @NonNull SpongeAddressAccessor spongeAddressAccessor) {
        super(rpcFactory, eventManager, networkClient, taskProvider, serviceHelper, serviceInfoHolder, serviceProvider, wrapperConfiguration);
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (platform == null) {
            throw new NullPointerException("platform is marked non-null but is null");
        }
        if (rpcFactory == null) {
            throw new NullPointerException("rpcFactory is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (channelManager == null) {
            throw new NullPointerException("channelManager is marked non-null but is null");
        }
        if (commandManager == null) {
            throw new NullPointerException("commandManager is marked non-null but is null");
        }
        if (taskProvider == null) {
            throw new NullPointerException("taskProvider is marked non-null but is null");
        }
        if (serviceHelper == null) {
            throw new NullPointerException("serviceHelper is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serviceProvider == null) {
            throw new NullPointerException("serviceProvider is marked non-null but is null");
        }
        if (wrapperConfiguration == null) {
            throw new NullPointerException("wrapperConfiguration is marked non-null but is null");
        }
        if (spongeAddressAccessor == null) {
            throw new NullPointerException("spongeAddressAccessor is marked non-null but is null");
        }
        this.server = server;
        this.platform = platform;
        this.commandManager = commandManager;
        this.channelManager = channelManager;
        this.spongeAddressAccessor = spongeAddressAccessor;
        this.directGlobalExecutor = new SpongeDirectPlayerExecutor(channelManager, commandManager, PlayerExecutor.GLOBAL_UNIQUE_ID, () -> ((Server)this.server).onlinePlayers());
        serviceHelper.maxPlayers().set(this.server.maxPlayers());
        serviceHelper.motd().set(LegacyComponentSerializer.legacySection().serialize(this.server.motd()));
    }

    @Override
    public void registerServices(@NonNull ServiceRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        registry.registerProvider(PlayerManager.class, "PlayerManager", this.playerManager);
        registry.registerProvider(PlatformBridgeManagement.class, "SpongeBridgeManagement", this);
    }

    @Override
    @NonNull
    public ServicePlayer wrapPlayer(@NonNull ServerPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new ServicePlayer(player.uniqueId(), player.name());
    }

    @Override
    @NonNull
    public NetworkPlayerServerInfo createPlayerInformation(@NonNull ServerPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new NetworkPlayerServerInfo(player.uniqueId(), player.name(), null, BridgeHostAndPortUtil.fromSocketAddress(this.spongeAddressAccessor.playerHostAddress(player)), this.ownNetworkServiceInfo);
    }

    @Override
    @NonNull
    public BiFunction<ServerPlayer, String, Boolean> permissionFunction() {
        return PERM_FUNCTION;
    }

    @Override
    public boolean isOnAnyFallbackInstance(@NonNull ServerPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.isOnAnyFallbackInstance(this.ownNetworkServiceInfo.serverName(), null, arg_0 -> ((ServerPlayer)player).hasPermission(arg_0));
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull ServerPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player, this.ownNetworkServiceInfo.serverName());
    }

    @Override
    @NonNull
    public Optional<ServiceInfoSnapshot> fallback(@NonNull ServerPlayer player, @Nullable String currServer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.fallback(player.uniqueId(), currServer, null, arg_0 -> ((ServerPlayer)player).hasPermission(arg_0));
    }

    @Override
    public void handleFallbackConnectionSuccess(@NonNull ServerPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.handleFallbackConnectionSuccess(player.uniqueId());
    }

    @Override
    public void removeFallbackProfile(@NonNull ServerPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.removeFallbackProfile(player.uniqueId());
    }

    @Override
    @NonNull
    public PlayerExecutor directPlayerExecutor(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return uniqueId.equals(PlayerExecutor.GLOBAL_UNIQUE_ID) ? this.directGlobalExecutor : new SpongeDirectPlayerExecutor(this.channelManager, this.commandManager, uniqueId, () -> Collections.singleton(this.server.player(uniqueId).orElse(null)));
    }

    @Override
    public void appendServiceInformation(@NonNull ServiceInfoPropertiesConfigureEvent configureEvent) {
        if (configureEvent == null) {
            throw new NullPointerException("configureEvent is marked non-null but is null");
        }
        super.appendServiceInformation(configureEvent);
        configureEvent.propertyHolder().append("Online-Count", this.server.onlinePlayers().size());
        configureEvent.propertyHolder().append("Version", this.platform.minecraftVersion().name());
        configureEvent.propertyHolder().append("Players", this.server.onlinePlayers().stream().map(this::createPlayerInformation).toList());
    }
}

