/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.sponge;

import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.Reflexion;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import lombok.NonNull;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.plugin.PluginManager;

@Singleton
public final class SpongeAddressAccessor {
    private static final MethodAccessor<Method> GET_CONNECT_ACCESSOR = Reflexion.on(ServerPlayer.class).findMethod("connection", new Class[0]).orElse(null);
    private final int spongeApiVersion;

    @Inject
    public SpongeAddressAccessor(@NonNull PluginManager pluginManager) {
        if (pluginManager == null) {
            throw new NullPointerException("pluginManager is marked non-null but is null");
        }
        this.spongeApiVersion = pluginManager.plugin("spongeapi").map(plugin -> plugin.metadata().version().getMajorVersion()).orElse(0);
    }

    @NonNull
    public InetSocketAddress playerHostAddress(@NonNull ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            throw new NullPointerException("serverPlayer is marked non-null but is null");
        }
        if (this.spongeApiVersion < 11) {
            return serverPlayer.connection().address();
        }
        if (GET_CONNECT_ACCESSOR == null) {
            throw new IllegalStateException("Unable to find connection accessor for api version >= 11");
        }
        return ((RemoteConnection)GET_CONNECT_ACCESSOR.invoke(serverPlayer).getOrThrow()).address();
    }
}

