/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.nukkit;

import cn.nukkit.Player;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.Listener;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerLoginEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.ServerScheduler;
import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.helper.ServerPlatformHelper;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;

@Singleton
public final class NukkitPlayerManagementListener
implements Listener {
    private final Plugin plugin;
    private final ServerScheduler scheduler;
    private final ServiceInfoHolder serviceInfoHolder;
    private final ServerPlatformHelper serverPlatformHelper;
    private final PlatformBridgeManagement<Player, NetworkPlayerServerInfo> management;

    @Inject
    public NukkitPlayerManagementListener(@NonNull Plugin plugin, @NonNull ServerScheduler scheduler, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull ServerPlatformHelper serverPlatformHelper, @NonNull PlatformBridgeManagement<Player, NetworkPlayerServerInfo> management) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serverPlatformHelper == null) {
            throw new NullPointerException("serverPlatformHelper is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.serviceInfoHolder = serviceInfoHolder;
        this.serverPlatformHelper = serverPlatformHelper;
        this.management = management;
    }

    @EventHandler
    public void handle(@NonNull PlayerLoginEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        ServiceTask task = this.management.selfTask();
        if (task != null) {
            if (task.maintenance() && !event.getPlayer().hasPermission("cloudnet.bridge.maintenance")) {
                event.setCancelled(true);
                this.management.configuration().handleMessage(event.getPlayer().getLocale(), "server-join-cancel-because-maintenance", arg_0 -> ((PlayerLoginEvent)event).setKickMessage(arg_0));
                return;
            }
            String permission = task.propertyHolder().getString("requiredPermission");
            if (permission != null && !event.getPlayer().hasPermission(permission)) {
                event.setCancelled(true);
                this.management.configuration().handleMessage(event.getPlayer().getLocale(), "server-join-cancel-because-permission", arg_0 -> ((PlayerLoginEvent)event).setKickMessage(arg_0));
            }
        }
    }

    @EventHandler
    public void handle(@NonNull PlayerJoinEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.serverPlatformHelper.sendChannelMessageLoginSuccess(event.getPlayer().getUniqueId(), this.management.createPlayerInformation(event.getPlayer()));
        this.scheduler.scheduleTask(this.plugin, () -> ((ServiceInfoHolder)this.serviceInfoHolder).publishServiceInfoUpdate());
    }

    @EventHandler
    public void handle(@NonNull PlayerQuitEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.serverPlatformHelper.sendChannelMessageDisconnected(event.getPlayer().getUniqueId(), this.management.ownNetworkServiceInfo());
        this.scheduler.scheduleTask(this.plugin, () -> ((ServiceInfoHolder)this.serviceInfoHolder).publishServiceInfoUpdate());
    }
}

