/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.nukkit;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerExecutorAdapter;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.Nullable;

final class NukkitDirectPlayerExecutor
extends PlatformPlayerExecutorAdapter<Player> {
    private final Server server;

    public NukkitDirectPlayerExecutor(@NonNull Server server, @NonNull UUID targetUniqueId, @NonNull Supplier<Collection<? extends Player>> playerSupplier) {
        super(targetUniqueId, playerSupplier);
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (targetUniqueId == null) {
            throw new NullPointerException("targetUniqueId is marked non-null but is null");
        }
        if (playerSupplier == null) {
            throw new NullPointerException("playerSupplier is marked non-null but is null");
        }
        this.server = server;
    }

    @Override
    public void connect(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
    }

    @Override
    public void connectSelecting(@NonNull ServerSelectorType selectorType) {
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void connectToFallback() {
    }

    @Override
    public void connectToGroup(@NonNull String group, @NonNull ServerSelectorType selectorType) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void connectToTask(@NonNull String task, @NonNull ServerSelectorType selectorType) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void kick(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> player.kick(LegacyComponentSerializer.legacySection().serialize(message)));
    }

    @Override
    protected void sendTitle(@NonNull Component title, @NonNull Component subtitle, int fadeIn, int stay, int fadeOut) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (subtitle == null) {
            throw new NullPointerException("subtitle is marked non-null but is null");
        }
        this.forEach(player -> player.sendTitle(LegacyComponentSerializer.legacySection().serialize(title), LegacyComponentSerializer.legacySection().serialize(subtitle), fadeIn, stay, fadeOut));
    }

    @Override
    public void sendChatMessage(@NonNull Component message, @Nullable String permission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> {
            if (permission == null || player.hasPermission(permission)) {
                player.sendMessage(LegacyComponentSerializer.legacySection().serialize(message));
            }
        });
    }

    @Override
    public void sendPluginMessage(@NonNull String key, byte[] data) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
    }

    @Override
    public void spoofCommandExecution(@NonNull String command, boolean redirectToServer) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.forEach(player -> this.server.dispatchCommand((CommandSender)player, command));
    }
}

