/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.nukkit;

import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginManager;
import cn.nukkit.scheduler.ServerScheduler;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.util.ModuleHelper;
import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import eu.cloudnetservice.modules.bridge.platform.nukkit.NukkitBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.nukkit.NukkitPlayerManagementListener;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;

@Singleton
@PlatformPlugin(platform="nukkit", api="1.0.5", name="CloudNet-Bridge", version="4.0.0-RC11", description="Bridges service software support between all supported versions for easy CloudNet plugin development", authors={"CloudNetService"})
public final class NukkitBridgePlugin
implements PlatformEntrypoint {
    private final Plugin plugin;
    private final ServerScheduler scheduler;
    private final ModuleHelper moduleHelper;
    private final PluginManager pluginManager;
    private final ServiceRegistry serviceRegistry;
    private final NukkitBridgeManagement bridgeManagement;
    private final NukkitPlayerManagementListener playerListener;

    @Inject
    public NukkitBridgePlugin(@NonNull Plugin plugin, @NonNull ServerScheduler scheduler, @NonNull ModuleHelper moduleHelper, @NonNull PluginManager pluginManager, @NonNull ServiceRegistry serviceRegistry, @NonNull NukkitBridgeManagement bridgeManagement, @NonNull NukkitPlayerManagementListener playerListener) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
        if (moduleHelper == null) {
            throw new NullPointerException("moduleHelper is marked non-null but is null");
        }
        if (pluginManager == null) {
            throw new NullPointerException("pluginManager is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (bridgeManagement == null) {
            throw new NullPointerException("bridgeManagement is marked non-null but is null");
        }
        if (playerListener == null) {
            throw new NullPointerException("playerListener is marked non-null but is null");
        }
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.moduleHelper = moduleHelper;
        this.pluginManager = pluginManager;
        this.serviceRegistry = serviceRegistry;
        this.bridgeManagement = bridgeManagement;
        this.playerListener = playerListener;
    }

    @Override
    public void onLoad() {
        this.bridgeManagement.registerServices(this.serviceRegistry);
        this.bridgeManagement.postInit();
        this.pluginManager.registerEvents((Listener)this.playerListener, this.plugin);
    }

    @Override
    public void onDisable() {
        this.scheduler.cancelTask(this.plugin);
        this.moduleHelper.unregisterAll(this.getClass().getClassLoader());
    }
}

