/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.minestom;

import eu.cloudnetservice.driver.service.ServiceTask;
import eu.cloudnetservice.ext.component.ComponentFormats;
import eu.cloudnetservice.modules.bridge.platform.PlatformBridgeManagement;
import eu.cloudnetservice.modules.bridge.platform.helper.ServerPlatformHelper;
import eu.cloudnetservice.modules.bridge.player.NetworkPlayerServerInfo;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.NonNull;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.event.player.AsyncPlayerPreLoginEvent;
import net.minestom.server.event.player.PlayerDisconnectEvent;
import net.minestom.server.event.player.PlayerSpawnEvent;

@Singleton
public final class MinestomPlayerManagementListener {
    private final ServiceInfoHolder serviceInfoHolder;
    private final ServerPlatformHelper serverPlatformHelper;
    private final PlatformBridgeManagement<Player, NetworkPlayerServerInfo> management;

    @Inject
    public MinestomPlayerManagementListener(@NonNull GlobalEventHandler eventHandler, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull ServerPlatformHelper serverPlatformHelper, @NonNull PlatformBridgeManagement<Player, NetworkPlayerServerInfo> management) {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (serverPlatformHelper == null) {
            throw new NullPointerException("serverPlatformHelper is marked non-null but is null");
        }
        if (management == null) {
            throw new NullPointerException("management is marked non-null but is null");
        }
        this.serviceInfoHolder = serviceInfoHolder;
        this.serverPlatformHelper = serverPlatformHelper;
        this.management = management;
        EventNode node = EventNode.type((String)"cloudnet-bridge", (EventFilter)EventFilter.PLAYER);
        eventHandler.addChild(node.addListener(AsyncPlayerPreLoginEvent.class, this::handleLogin).addListener(PlayerSpawnEvent.class, this::handleJoin).addListener(PlayerDisconnectEvent.class, this::handleDisconnect));
    }

    private void handleLogin(@NonNull AsyncPlayerPreLoginEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        Player player = event.getPlayer();
        ServiceTask task = this.management.selfTask();
        if (task != null) {
            if (task.maintenance() && !player.hasPermission("cloudnet.bridge.maintenance")) {
                this.management.configuration().handleMessage(player.getLocale(), "server-join-cancel-because-maintenance", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, arg_0 -> ((Player)player).kick(arg_0));
                return;
            }
            String permission = task.propertyHolder().getString("requiredPermission");
            if (permission != null && !player.hasPermission(permission)) {
                this.management.configuration().handleMessage(player.getLocale(), "server-join-cancel-because-permission", ComponentFormats.BUNGEE_TO_ADVENTURE::convert, arg_0 -> ((Player)player).kick(arg_0));
            }
        }
    }

    private void handleJoin(@NonNull PlayerSpawnEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.serverPlatformHelper.sendChannelMessageLoginSuccess(event.getPlayer().getUuid(), this.management.createPlayerInformation(event.getPlayer()));
        this.serviceInfoHolder.publishServiceInfoUpdate();
    }

    private void handleDisconnect(@NonNull PlayerDisconnectEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.serverPlatformHelper.sendChannelMessageDisconnected(event.getPlayer().getUuid(), this.management.ownNetworkServiceInfo());
        this.serviceInfoHolder.publishServiceInfoUpdate();
    }
}

