/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.bridge.platform.minestom;

import eu.cloudnetservice.modules.bridge.platform.PlatformPlayerExecutorAdapter;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.minestom.server.command.CommandManager;
import net.minestom.server.command.CommandSender;
import net.minestom.server.entity.Player;
import org.jetbrains.annotations.Nullable;

final class MinestomDirectPlayerExecutor
extends PlatformPlayerExecutorAdapter<Player> {
    private final CommandManager commandManager;

    public MinestomDirectPlayerExecutor(@NonNull CommandManager commandManager, @NonNull UUID uniqueId, @NonNull Supplier<? extends Collection<? extends Player>> supplier) {
        super(uniqueId, supplier);
        if (commandManager == null) {
            throw new NullPointerException("commandManager is marked non-null but is null");
        }
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.commandManager = commandManager;
    }

    @Override
    public void connect(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
    }

    @Override
    public void connectSelecting(@NonNull ServerSelectorType selectorType) {
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void connectToFallback() {
    }

    @Override
    public void connectToGroup(@NonNull String group, @NonNull ServerSelectorType selectorType) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void connectToTask(@NonNull String task, @NonNull ServerSelectorType selectorType) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (selectorType == null) {
            throw new NullPointerException("selectorType is marked non-null but is null");
        }
    }

    @Override
    public void kick(@NonNull Component message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> player.kick(message));
    }

    @Override
    public void sendTitle(@NonNull Title title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.forEach(player -> player.showTitle(title));
    }

    @Override
    public void sendChatMessage(@NonNull Component message, @Nullable String permission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.forEach(player -> {
            if (permission == null || player.hasPermission(permission)) {
                player.sendMessage(message);
            }
        });
    }

    @Override
    public void sendPluginMessage(@NonNull String key, byte[] data) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.forEach(player -> player.sendPluginMessage(key, data));
    }

    @Override
    public void spoofCommandExecution(@NonNull String command, boolean redirectToServer) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.forEach(player -> this.commandManager.execute((CommandSender)player, command));
    }
}

